/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.ui.NbProgressBar;
import org.netbeans.modules.progress.ui.StatusLineComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ListComponent
extends JPanel {
    private NbProgressBar bar;
    private JLabel mainLabel;
    private JLabel dynaLabel;
    private JButton closeButton;
    private InternalHandle handle;
    private boolean watched;
    private Action cancelAction;
    private Color selectBgColor;
    private Color selectFgColor;
    private Color bgColor;
    private Color fgColor;
    private int mainHeight;
    private int dynaHeight;
    private static final int UPPERMARGIN = 3;
    private static final int LEFTMARGIN = 2;
    private static final int BOTTOMMARGIN = 2;
    private static final int BETWEENTEXTMARGIN = 3;
    static final int ITEM_WIDTH = 600;

    public ListComponent(InternalHandle internalHandle) {
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.mainLabel = new JLabel();
        this.dynaLabel = new JLabel();
        this.setOpaque(true);
        this.dynaLabel.setFont(this.dynaLabel.getFont().deriveFont((float)(this.dynaLabel.getFont().getSize() - 2)));
        this.bar = new NbProgressBar();
        this.handle = internalHandle;
        Color color = UIManager.getColor("nbProgressBar.popupText.background");
        if (color != null) {
            this.setBackground(color);
            this.mainLabel.setBackground(color);
            this.dynaLabel.setBackground(color);
        }
        this.bgColor = this.getBackground();
        Color color2 = UIManager.getColor("nbProgressBar.popupDynaText.foreground");
        if (color2 != null) {
            this.dynaLabel.setForeground(color2);
        }
        this.fgColor = UIManager.getColor("nbProgressBar.popupText.foreground");
        if (this.fgColor != null) {
            this.mainLabel.setForeground(this.fgColor);
        }
        this.fgColor = this.mainLabel.getForeground();
        this.selectBgColor = UIManager.getColor("nbProgressBar.popupText.selectBackground");
        if (this.selectBgColor == null) {
            this.selectBgColor = UIManager.getColor("List.selectionBackground");
        }
        this.selectFgColor = UIManager.getColor("nbProgressBar.popupText.selectForeground");
        if (this.selectFgColor == null) {
            this.selectFgColor = UIManager.getColor("List.selectionForeground");
        }
        this.bar.setToolTipText(NbBundle.getMessage(ListComponent.class, (String)"ListComponent.bar.tooltip"));
        this.bar.setCursor(Cursor.getPredefinedCursor(12));
        this.mainLabel.setText("XYZ");
        this.dynaLabel.setText("XYZ");
        this.mainHeight = this.mainLabel.getPreferredSize().height;
        this.dynaHeight = this.dynaLabel.getPreferredSize().height;
        this.mainLabel.setText(null);
        this.dynaLabel.setText(null);
        this.setLayout(new CustomLayout());
        this.add(this.mainLabel);
        this.add(this.bar);
        MListener mListener = new MListener();
        if (this.handle.isAllowCancel()) {
            this.cancelAction = new CancelAction(false);
            this.closeButton = new JButton(this.cancelAction);
            this.closeButton.setBorderPainted(false);
            this.closeButton.setBorder(BorderFactory.createEmptyBorder());
            this.closeButton.setOpaque(false);
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setFocusable(false);
            Object object = UIManager.get("nb.progress.cancel.icon");
            if (null != object) {
                this.closeButton.setIcon(ListComponent.iconOrImage2icon(object));
            }
            if (null != (object = UIManager.get("nb.progress.cancel.icon.mouseover"))) {
                this.closeButton.setRolloverEnabled(true);
                this.closeButton.setRolloverIcon(ListComponent.iconOrImage2icon(object));
            }
            if (null != (object = UIManager.get("nb.progress.cancel.icon.pressed"))) {
                this.closeButton.setPressedIcon(ListComponent.iconOrImage2icon(object));
            }
            this.closeButton.setToolTipText(NbBundle.getMessage(ListComponent.class, (String)"ListComponent.btnClose.tooltip"));
            this.add(this.closeButton);
            if (this.handle.getState() != 1) {
                this.closeButton.setEnabled(false);
            }
        }
        this.add(this.dynaLabel);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(mListener);
        this.bar.addMouseListener(mListener);
        this.mainLabel.addMouseListener(mListener);
        this.dynaLabel.addMouseListener(mListener);
        if (this.handle.isAllowCancel()) {
            this.closeButton.addMouseListener(mListener);
        }
        this.mainLabel.setText(this.handle.getDisplayName());
        this.mainLabel.setToolTipText(this.mainLabel.getText());
        NbProgressBar.setupBar(this.handle, this.bar);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ListComponent.this.setBackground(ListComponent.this.selectBgColor);
                    ListComponent.this.mainLabel.setBackground(ListComponent.this.selectBgColor);
                    ListComponent.this.dynaLabel.setBackground(ListComponent.this.selectBgColor);
                    ListComponent.this.mainLabel.setForeground(ListComponent.this.selectFgColor);
                    ListComponent.this.scrollRectToVisible(ListComponent.this.getBounds());
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ListComponent.this.setBackground(ListComponent.this.bgColor);
                    ListComponent.this.mainLabel.setBackground(ListComponent.this.bgColor);
                    ListComponent.this.dynaLabel.setBackground(ListComponent.this.bgColor);
                    ListComponent.this.mainLabel.setForeground(ListComponent.this.fgColor);
                }
            }
        });
    }

    static Icon iconOrImage2icon(Object object) {
        return object instanceof Icon ? (Icon)object : new ImageIcon((Image)object);
    }

    Action getCancelAction() {
        return this.cancelAction;
    }

    InternalHandle getHandle() {
        return this.handle;
    }

    void processProgressEvent(ProgressEvent progressEvent) {
        if (progressEvent.getType() == 1 || progressEvent.getType() == 5 || progressEvent.getType() == 6) {
            if (progressEvent.getSource() != this.handle) {
                throw new IllegalStateException();
            }
            if (progressEvent.isSwitched()) {
                NbProgressBar.setupBar(progressEvent.getSource(), this.bar);
            }
            if (progressEvent.getWorkunitsDone() > 0) {
                this.bar.setValue(progressEvent.getWorkunitsDone());
            }
            this.bar.setString(StatusLineComponent.getBarString(progressEvent.getPercentageDone(), progressEvent.getEstimatedCompletion()));
            if (progressEvent.getMessage() != null) {
                this.dynaLabel.setText(progressEvent.getMessage());
            }
            if (progressEvent.getSource().getState() == 3) {
                this.closeButton.setEnabled(false);
            }
            if (progressEvent.getDisplayName() != null) {
                this.mainLabel.setText(progressEvent.getDisplayName());
            }
        } else {
            throw new IllegalStateException();
        }
    }

    void markAsActive(boolean bl) {
        if (bl == this.watched) {
            return;
        }
        this.watched = bl;
        if (bl) {
            this.mainLabel.setFont(this.mainLabel.getFont().deriveFont(1));
        } else {
            this.mainLabel.setFont(this.mainLabel.getFont().deriveFont(0));
        }
        if (this.mainLabel.isVisible()) {
            this.mainLabel.repaint();
        }
    }

    void clearProgressBarOSX() {
        if (this.bar != null) {
            this.bar.getUI().uninstallUI(this.bar);
        }
    }

    private void showMenu(MouseEvent mouseEvent) {
        if (!this.isShowing()) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setName("progresspopup");
        jPopupMenu.add(new ViewAction());
        jPopupMenu.add(new WatchAction());
        jPopupMenu.add(new CancelAction(true));
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    private class CustomLayout
    implements LayoutManager {
        private CustomLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 3 + ListComponent.this.mainHeight + 3 + ListComponent.this.dynaHeight + 2;
            return new Dimension(600, n);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getWidth();
            int n2 = container.getHeight();
            int n3 = n - 18;
            if (ListComponent.this.closeButton != null) {
                ListComponent.this.closeButton.setBounds(n3, 3, 18, ListComponent.this.mainHeight);
            }
            int n4 = n3 - 200;
            int n5 = 3;
            int n6 = ListComponent.this.mainHeight;
            if (UIManager.getLookAndFeel().getID().startsWith("FlatLaf")) {
                n6 = ((ListComponent)ListComponent.this).bar.getPreferredSize().height;
                n5 += (ListComponent.this.mainHeight - n6) / 2;
            }
            ListComponent.this.bar.setBounds(n4, n5, n3 - n4, n6);
            ListComponent.this.mainLabel.setBounds(2, 3, n4 - 2, ListComponent.this.mainHeight);
            ListComponent.this.dynaLabel.setBounds(2, ListComponent.this.mainHeight + 3 + 3, n - 2, ListComponent.this.dynaHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    private class WatchAction
    extends AbstractAction {
        public WatchAction() {
            this.putValue("Name", NbBundle.getMessage(ListComponent.class, (String)"ListComponent.Watch"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 0));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ListComponent.this.handle != null) {
                ListComponent.this.handle.requestExplicitSelection();
            }
        }
    }

    private class ViewAction
    extends AbstractAction {
        public ViewAction() {
            this.putValue("Name", NbBundle.getMessage(ListComponent.class, (String)"StatusLineComponent.View"));
            this.setEnabled(ListComponent.this.handle == null ? false : ListComponent.this.handle.isAllowView());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ListComponent.this.handle != null) {
                ListComponent.this.handle.requestView();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction(boolean bl) {
            if (bl) {
                this.putValue("Name", NbBundle.getMessage(ListComponent.class, (String)"StatusLineComponent.Cancel"));
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            } else {
                Object object = UIManager.get("nb.progress.cancel.icon");
                if (object == null) {
                    object = ImageUtilities.loadImage((String)"org/netbeans/progress/module/resources/buton.png");
                }
                this.putValue("SmallIcon", ListComponent.iconOrImage2icon(object));
            }
            this.setEnabled(ListComponent.this.handle == null ? false : ListComponent.this.handle.isAllowCancel());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ListComponent.this.handle.getState() == 1) {
                String string = NbBundle.getMessage(ListComponent.class, (String)"Cancel_Question", (Object)ListComponent.this.handle.getDisplayName());
                String string2 = NbBundle.getMessage(ListComponent.class, (String)"Cancel_Question_Title");
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, string2, 0, 3, null, null);
                Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
                if (object == NotifyDescriptor.YES_OPTION) {
                    ListComponent.this.handle.requestCancel();
                }
            }
        }
    }

    private class MListener
    extends MouseAdapter {
        private MListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == ListComponent.this.bar) {
                ListComponent.this.handle.requestExplicitSelection();
            }
            if (mouseEvent.getClickCount() > 1 && (mouseEvent.getSource() == ListComponent.this.mainLabel || mouseEvent.getSource() == ListComponent.this.dynaLabel)) {
                ListComponent.this.handle.requestView();
            }
            if (mouseEvent.getButton() != 1) {
                ListComponent.this.showMenu(mouseEvent);
            } else {
                ListComponent.this.requestFocus();
            }
        }
    }
}

