/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.query;

import ca.sqlpower.query.AbstractItem;
import ca.sqlpower.query.Container;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.TableContainer;
import ca.sqlpower.sqlobject.SQLObject;

public class SQLObjectItem
extends AbstractItem {
    private SQLObject sqlObject;
    private String alias;
    private String where;

    public SQLObjectItem(SQLObject object) {
        this.sqlObject = object;
        this.alias = "";
        this.where = "";
        this.setSelected(null);
    }

    public SQLObjectItem(String name, String uuid) {
        super(uuid);
        this.sqlObject = null;
        super.setName(name);
        this.alias = "";
        this.where = "";
        this.setSelected(null);
    }

    @Override
    public String getName() {
        if (this.sqlObject == null) {
            return super.getName();
        }
        return this.sqlObject.getName();
    }

    @Override
    public void setName(String name) {
        throw new IllegalStateException("Cannot set the name of a SQL object retrieved from the database through a query.");
    }

    public void setItem(SQLObject object) {
        this.sqlObject = object;
    }

    @Override
    public Object getItem() {
        if (this.sqlObject == null) {
            ((TableContainer)this.getParent()).loadTableByQualifiedName();
        }
        return this.sqlObject;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        String oldAlias = this.alias;
        if (alias.equals(oldAlias)) {
            return;
        }
        this.alias = alias;
        this.firePropertyChange("alias", oldAlias, alias);
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public void setWhere(String where) {
        String oldWhere = this.where;
        if (where.equals(oldWhere)) {
            return;
        }
        this.where = where;
        this.firePropertyChange("where", oldWhere, where);
    }

    @Override
    public Container getContainer() {
        return this.getParent();
    }

    public boolean equals(Object obj) {
        return obj instanceof SQLObjectItem && ((SQLObjectItem)obj).getUUID().equals(this.getUUID());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getUUID().hashCode();
        return result;
    }

    @Override
    public Item createCopy() {
        SQLObjectItem copy = new SQLObjectItem(this.sqlObject);
        copy.setAlias(this.getAlias());
        copy.setColumnWidth(this.getColumnWidth());
        copy.setGroupBy(this.getGroupBy());
        copy.setHaving(this.getHaving());
        copy.setOrderBy(this.getOrderBy());
        copy.setOrderByOrdering(this.getOrderByOrdering());
        copy.setSelected(this.getSelected());
        copy.setWhere(this.getWhere());
        return copy;
    }
}

