/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pkg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.pkg.JarPan;
import org.pentaho.di.pkg.KettleDependencies;
import org.pentaho.di.trans.TransMeta;

public class JarfileGenerator {
    private static LogWriter log = LogWriter.getInstance();
    public static final String TRANSFORMATION_FILENAME = "transformation.xml";

    public static final void generateJarFile(TransMeta transMeta) {
        KettleDependencies deps = new KettleDependencies(transMeta);
        File kar = new File("kar");
        if (kar.exists()) {
            log.logBasic("Jar generator", "Removing directory: " + kar.getPath(), new Object[0]);
            JarfileGenerator.deleteDirectory(kar);
        }
        kar.mkdir();
        String filename = "kettle-engine-3.0.jar";
        if (!Const.isEmpty((String)transMeta.getFilename())) {
            filename = Const.replace((String)transMeta.getFilename(), (String)" ", (String)"_").toLowerCase() + ".kar";
        }
        File karFile = new File(filename);
        try {
            String strManifest = "";
            strManifest = strManifest + "Manifest-Version: 1.0" + Const.CR;
            strManifest = strManifest + "Created-By: Kettle version 3.2.2" + Const.CR;
            strManifest = strManifest + Attributes.Name.MAIN_CLASS.toString() + ": " + JarPan.class.getName() + Const.CR;
            File manifestFile = new File(kar.getPath() + "/" + "manifest.mf");
            FileOutputStream fos = new FileOutputStream(manifestFile);
            fos.write(strManifest.getBytes());
            fos.close();
            log.logBasic("Jar generator", "Wrote manifest file: " + manifestFile.getPath(), new Object[0]);
            String strTrans = XMLHandler.getXMLHeader((String)"UTF-8") + transMeta.getXML();
            File transFile = new File(kar.getPath() + "/" + TRANSFORMATION_FILENAME);
            fos = new FileOutputStream(transFile);
            fos.write(strTrans.getBytes("UTF-8"));
            fos.close();
            log.logBasic("Jar generator", "Wrote transformation file: " + transFile.getPath(), new Object[0]);
            JarfileGenerator.executeJarCommand(kar, karFile, new File("manifest.mf"), new File(TRANSFORMATION_FILENAME), deps.getLibraryFiles());
        }
        catch (Exception e) {
            log.logError(JarfileGenerator.class.getName(), "Error zipping files into archive [" + karFile.getPath() + "] : " + e.toString(), new Object[0]);
            log.logError(JarfileGenerator.class.getName(), Const.getStackTracker((Throwable)e), new Object[0]);
        }
    }

    private static final void executeJarCommand(File karDirectory, File karFile, File manifestFile, File transFile, String[] libs) throws IOException, InterruptedException {
        for (int i = 0; i < libs.length; ++i) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("jar");
            commands.add("xf");
            commands.add("../" + libs[i]);
            String[] cmd = commands.toArray(new String[commands.size()]);
            JarfileGenerator.executeCommand(cmd, karDirectory);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("jar");
        commands.add("cf");
        commands.add(karFile.getPath());
        commands.add("-m");
        commands.add(manifestFile.getPath());
        commands.add(transFile.getPath());
        commands.add("build_version.txt");
        commands.add("log4j.xml");
        String[] directories = JarfileGenerator.getSubdirectories(karDirectory);
        for (int i = 0; i < directories.length; ++i) {
            if (directories[i].toUpperCase().equals("META-INF")) continue;
            commands.add(directories[i]);
        }
        String[] cmd = commands.toArray(new String[commands.size()]);
        JarfileGenerator.executeCommand(cmd, karDirectory);
    }

    private static void executeCommand(String[] cmd, File directory) throws IOException, InterruptedException {
        String command = "";
        for (int i = 0; i < cmd.length; ++i) {
            command = command + " " + cmd[i];
        }
        log.logBasic("Jar generator", "Executing command : " + command, new Object[0]);
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(cmd, EnvUtil.getEnvironmentVariablesForRuntimeExec(), directory);
        StreamLogger errorLogger = new StreamLogger(proc.getErrorStream(), "Jar generator (stderr)");
        StreamLogger outputLogger = new StreamLogger(proc.getInputStream(), "Jar generator (stdout)");
        new Thread((Runnable)errorLogger).start();
        new Thread((Runnable)outputLogger).start();
        proc.waitFor();
        log.logDetailed("Jar generator", "command [" + cmd[0] + "] has finished", new Object[0]);
        if (proc.exitValue() != 0) {
            log.logDetailed("Jar generator", "Exit status of jar command was " + proc.exitValue(), new Object[0]);
        }
        try {
            proc.getErrorStream().close();
            proc.getInputStream().close();
        }
        catch (IOException e) {
            log.logDetailed("Jar generator", "Warning: Error closing streams: " + e.getMessage(), new Object[0]);
        }
    }

    private static void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                JarfileGenerator.deleteDirectory(files[i]);
            }
            files[i].delete();
        }
        dir.delete();
    }

    private static String[] getSubdirectories(File dir) {
        ArrayList<String> directories = new ArrayList<String>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            directories.add(files[i].getName());
        }
        return directories.toArray(new String[directories.size()]);
    }
}

