/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.type;

import org.olap4j.OlapException;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.type.CubeType;
import org.olap4j.type.DimensionType;
import org.olap4j.type.HierarchyType;
import org.olap4j.type.LevelType;
import org.olap4j.type.MemberType;
import org.olap4j.type.SetType;
import org.olap4j.type.TupleType;
import org.olap4j.type.Type;

public class TypeUtil {
    private static Type stripSetType(Type type) {
        while (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        return type;
    }

    private static Type toMemberOrTupleType(Type type) throws OlapException {
        if ((type = TypeUtil.stripSetType(type)) instanceof TupleType) {
            return (TupleType)type;
        }
        return TypeUtil.toMemberType(type);
    }

    static MemberType toMemberType(Type type) throws OlapException {
        if ((type = TypeUtil.stripSetType(type)) instanceof MemberType) {
            return (MemberType)type;
        }
        if (type instanceof DimensionType || type instanceof HierarchyType || type instanceof LevelType) {
            return MemberType.forType(type);
        }
        return null;
    }

    static boolean isUnionCompatible(Type type1, Type type2) throws OlapException {
        if (type1 instanceof TupleType) {
            return type2 instanceof TupleType && ((TupleType)type1).isUnionCompatibleWith((TupleType)type2);
        }
        MemberType memberType1 = TypeUtil.toMemberType(type1);
        if (memberType1 == null) {
            return false;
        }
        MemberType memberType2 = TypeUtil.toMemberType(type2);
        if (memberType2 == null) {
            return false;
        }
        Hierarchy hierarchy1 = memberType1.getHierarchy();
        Hierarchy hierarchy2 = memberType2.getHierarchy();
        return TypeUtil.equal(hierarchy1, hierarchy2);
    }

    private static boolean equal(Hierarchy hierarchy1, Hierarchy hierarchy2) {
        return hierarchy1 == null || hierarchy2 == null || hierarchy2.getUniqueName().equals(hierarchy1.getUniqueName());
    }

    public static boolean canEvaluate(Type type) {
        return !(type instanceof SetType) && !(type instanceof CubeType) && !(type instanceof LevelType);
    }

    public static boolean isSet(Type type) {
        return type instanceof SetType;
    }

    private static boolean couldBeMember(Type type) {
        return type instanceof MemberType || type instanceof HierarchyType || type instanceof DimensionType;
    }

    static boolean equal(Object o, Object p) {
        return o == null ? p == null : p != null && o.equals(p);
    }
}

