/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.checkin;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracklink.checkin.LinkCheckMap;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxColumnInfo
extends ColumnInfo<ArtifactInfo, Boolean> {
    private final LinkCheckMap myMap;

    public CheckBoxColumnInfo(String name, LinkCheckMap map) {
        super(name);
        this.myMap = map;
    }

    public Boolean valueOf(ArtifactInfo info) {
        return this.myMap.isSelected(info);
    }

    public Class getColumnClass() {
        return Boolean.class;
    }

    public Comparator<ArtifactInfo> getComparator() {
        return new Comparator<ArtifactInfo>(){

            @Override
            public int compare(ArtifactInfo o1, ArtifactInfo o2) {
                return CheckBoxColumnInfo.this.valueOf(o1).compareTo(CheckBoxColumnInfo.this.valueOf(o2));
            }
        };
    }

    public boolean isCellEditable(ArtifactInfo o) {
        return true;
    }

    public TableCellRenderer getRenderer(ArtifactInfo info) {
        return new BooleanRenderer(info);
    }

    public TableCellEditor getEditor(ArtifactInfo item) {
        return new BooleanEditor(item);
    }

    private class BooleanEditor
    extends DefaultCellEditor {
        private ArtifactInfo myItem;

        public BooleanEditor(ArtifactInfo item) {
            super(new JCheckBox());
            this.myItem = item;
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
        }

        public boolean stopCellEditing() {
            super.stopCellEditing();
            CheckBoxColumnInfo.this.myMap.setSelected(this.myItem, ((JCheckBox)this.getComponent()).isSelected());
            return true;
        }
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private ArtifactInfo myInfo;

        public BooleanRenderer(ArtifactInfo info) {
            this.myInfo = info;
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(CheckBoxColumnInfo.this.myMap.isSelected(this.myInfo));
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }
}

