/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.parser;

import gov.nist.core.ParserCore;
import gov.nist.javax.sdp.SessionDescriptionImpl;
import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.parser.Lexer;
import gov.nist.javax.sdp.parser.ParserFactory;
import gov.nist.javax.sdp.parser.SDPParser;
import java.text.ParseException;
import java.util.Vector;

public class SDPAnnounceParser
extends ParserCore {
    protected Lexer lexer;
    protected Vector sdpMessage;

    public SDPAnnounceParser(Vector sdpMessage) {
        this.sdpMessage = sdpMessage;
    }

    public SDPAnnounceParser(String message) {
        int start2 = 0;
        String line = null;
        if (message == null) {
            return;
        }
        this.sdpMessage = new Vector();
        String sdpAnnounce = message.trim() + "\r\n";
        while (start2 < sdpAnnounce.length()) {
            int lfPos = sdpAnnounce.indexOf("\n", start2);
            int crPos = sdpAnnounce.indexOf("\r", start2);
            if (lfPos >= 0 && crPos < 0) {
                line = sdpAnnounce.substring(start2, lfPos);
                start2 = lfPos + 1;
            } else if (lfPos < 0 && crPos >= 0) {
                line = sdpAnnounce.substring(start2, crPos);
                start2 = crPos + 1;
            } else if (lfPos >= 0 && crPos >= 0) {
                if (lfPos > crPos) {
                    line = sdpAnnounce.substring(start2, crPos);
                    start2 = lfPos == crPos + 1 ? lfPos + 1 : crPos + 1;
                } else {
                    line = sdpAnnounce.substring(start2, lfPos);
                    start2 = crPos == lfPos + 1 ? crPos + 1 : lfPos + 1;
                }
            } else if (lfPos < 0 && crPos < 0) break;
            this.sdpMessage.addElement(line);
        }
    }

    public SessionDescriptionImpl parse() throws ParseException {
        SessionDescriptionImpl retval = new SessionDescriptionImpl();
        for (int i = 0; i < this.sdpMessage.size(); ++i) {
            String field = (String)this.sdpMessage.elementAt(i);
            SDPParser sdpParser = ParserFactory.createParser(field);
            SDPField sdpField = null;
            if (sdpParser != null) {
                sdpField = sdpParser.parse();
            }
            retval.addField(sdpField);
        }
        return retval;
    }
}

