/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.HostPort;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageProcessor;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.NIOHandler;
import gov.nist.javax.sip.stack.NioTcpMessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class NioTcpMessageProcessor
extends ConnectionOrientedMessageProcessor {
    protected Selector selector;
    private static StackLogger logger = CommonLogger.getLogger(NioTcpMessageProcessor.class);
    protected Thread selectorThread;
    protected NIOHandler nioHandler;
    protected ServerSocketChannel channel;
    private final List<ChangeRequest> changeRequests = new LinkedList<ChangeRequest>();
    private final Map<SocketChannel, List<ByteBuffer>> pendingData = new WeakHashMap<SocketChannel, List<ByteBuffer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketChannel initiateConnection(InetSocketAddress address, InetAddress myAddress, int timeout2) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        if (myAddress != null) {
            socketChannel.socket().bind(new InetSocketAddress(myAddress, 0));
        }
        socketChannel.configureBlocking(true);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Init connect " + address);
        }
        socketChannel.socket().connect(address, timeout2);
        socketChannel.configureBlocking(false);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Blocking set to false now " + address);
        }
        List<ChangeRequest> list = this.changeRequests;
        synchronized (list) {
            this.changeRequests.add(new ChangeRequest(socketChannel, 1, 1));
        }
        this.selector.wakeup();
        return socketChannel;
    }

    public SocketChannel blockingConnect(InetSocketAddress address, InetAddress localAddress, int timeout2) throws IOException {
        return this.initiateConnection(address, localAddress, timeout2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SocketChannel socket, byte[] data) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Sending data " + data.length + " bytes on socket " + socket);
        }
        List<ChangeRequest> list = this.changeRequests;
        synchronized (list) {
            this.changeRequests.add(new ChangeRequest(socket, 2, 4));
            Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
            synchronized (map) {
                List<ByteBuffer> queue = this.pendingData.get(socket);
                if (queue == null) {
                    queue = new ArrayList<ByteBuffer>();
                    this.pendingData.put(socket, queue);
                }
                queue.add(ByteBuffer.wrap(data));
            }
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Waking up selector thread");
        }
        this.selector.wakeup();
    }

    public NioTcpMessageChannel createMessageChannel(NioTcpMessageProcessor nioTcpMessageProcessor, SocketChannel client) throws IOException {
        return NioTcpMessageChannel.create(this, client);
    }

    public NioTcpMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port2) {
        super(ipAddress, port2, "TCP", sipStack);
        this.nioHandler = new NIOHandler(sipStack, this);
    }

    ConnectionOrientedMessageChannel constructMessageChannel(InetAddress targetHost, int port2) throws IOException {
        return new NioTcpMessageChannel(targetHost, port2, this.sipStack, this);
    }

    private synchronized MessageChannel createMessageChannel(String key, InetAddress targetHost, int port2) throws IOException {
        ConnectionOrientedMessageChannel retval = (ConnectionOrientedMessageChannel)this.messageChannels.get(key);
        if (retval == null) {
            retval = this.constructMessageChannel(targetHost, port2);
            this.messageChannels.put(key, retval);
            retval.isCached = true;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("key " + key);
                logger.logDebug("Creating " + retval);
            }
            this.selector.wakeup();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("NioTcpMessageProcessor::createMessageChannel: " + targetHostPort);
        }
        MessageChannel retval = null;
        try {
            String key = MessageChannel.getKey(targetHostPort, this.transport);
            retval = (MessageChannel)this.messageChannels.get(key);
            if (retval == null) {
                retval = this.createMessageChannel(key, targetHostPort.getInetAddress(), targetHostPort.getPort());
            }
        }
        finally {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("MessageChannel::createMessageChannel - exit " + retval);
            }
        }
        return retval;
    }

    @Override
    public MessageChannel createMessageChannel(InetAddress targetHost, int port2) throws IOException {
        String key = MessageChannel.getKey(targetHost, port2, this.transport);
        MessageChannel retval = (MessageChannel)this.messageChannels.get(key);
        if (retval == null) {
            retval = this.createMessageChannel(key, targetHost, port2);
        }
        return retval;
    }

    @Override
    protected synchronized void remove(ConnectionOrientedMessageChannel messageChannel) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug(Thread.currentThread() + " removing " + ((NioTcpMessageChannel)messageChannel).getSocketChannel() + " from processor " + this.getIpAddress() + ":" + this.getPort() + "/" + this.getTransport());
        }
        this.pendingData.remove(((NioTcpMessageChannel)messageChannel).getSocketChannel());
        super.remove(messageChannel);
    }

    @Override
    public int getDefaultTargetPort() {
        return 5060;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public void start() throws IOException {
        this.selector = Selector.open();
        this.channel = ServerSocketChannel.open();
        this.channel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(super.getIpAddress(), super.getPort());
        this.channel.socket().bind(isa);
        this.channel.register(this.selector, 16);
        this.selectorThread = new Thread(this.createProcessorTask());
        this.selectorThread.start();
        this.selectorThread.setName("NioSelector-" + this.getTransport() + '-' + this.getIpAddress().getHostAddress() + '/' + this.getPort());
    }

    protected ProcessorTask createProcessorTask() {
        return new ProcessorTask();
    }

    @Override
    public void stop() {
        try {
            if (this.selector.isOpen()) {
                this.selector.close();
            }
            this.nioHandler.stop();
        }
        catch (Exception ex) {
            logger.logError("Problem closing channel ", ex);
        }
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            logger.logError("Problem closing channel ", ex);
        }
    }

    class ProcessorTask
    implements Runnable {
        public void read(SelectionKey selectionKey) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            NioTcpMessageChannel nioTcpMessageChannel = NioTcpMessageChannel.getMessageChannel(socketChannel);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Got something on nioTcpMessageChannel " + nioTcpMessageChannel + " socket " + socketChannel);
            }
            if (nioTcpMessageChannel == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dead socketChannel" + socketChannel + " socket " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort());
                }
                selectionKey.cancel();
                NioTcpMessageProcessor.this.pendingData.remove(socketChannel);
                return;
            }
            nioTcpMessageChannel.readChannel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(SelectionKey selectionKey) {
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            NioTcpMessageChannel nioTcpMessageChannel = NioTcpMessageChannel.getMessageChannel(socketChannel);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Need to write something on nioTcpMessageChannel " + nioTcpMessageChannel + " socket " + socketChannel);
            }
            if (nioTcpMessageChannel == null) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Dead socketChannel" + socketChannel + " socket " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort());
                }
                selectionKey.cancel();
                NioTcpMessageProcessor.this.pendingData.remove(socketChannel);
                return;
            }
            Map map = NioTcpMessageProcessor.this.pendingData;
            synchronized (map) {
                List queue = (List)NioTcpMessageProcessor.this.pendingData.get(socketChannel);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Queued items for writing " + queue.size());
                }
                while (!queue.isEmpty()) {
                    ByteBuffer buf = (ByteBuffer)queue.get(0);
                    try {
                        socketChannel.write(buf);
                    }
                    catch (IOException e) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Dead socketChannel" + socketChannel + " socket " + socketChannel.socket().getInetAddress() + ":" + socketChannel.socket().getPort() + " : error message " + e.getMessage());
                        }
                        nioTcpMessageChannel.close();
                        queue.remove(0);
                        NioTcpMessageProcessor.this.pendingData.remove(socketChannel);
                        return;
                    }
                    int remain = buf.remaining();
                    if (remain > 0) {
                        if (!logger.isLoggingEnabled(32)) break;
                        logger.logDebug("Socket buffer filled and more is remaining" + queue.size() + " remain = " + remain);
                        break;
                    }
                    queue.remove(0);
                }
                if (queue.isEmpty()) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("We wrote away all data. Setting READ interest. Queue is emtpy now size =" + queue.size());
                    }
                    selectionKey.interestOps(1);
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Done writing");
            }
        }

        public void connect(SelectionKey selectionKey) throws IOException {
            throw new IOException("We should use blocking connect, we must never reach here");
        }

        public void accept(SelectionKey selectionKey) throws IOException {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
            SocketChannel client = serverSocketChannel.accept();
            client.configureBlocking(false);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("got a new connection! " + client);
            }
            NioTcpMessageProcessor.this.createMessageChannel(NioTcpMessageProcessor.this, client);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Adding to selector " + client);
            }
            client.register(NioTcpMessageProcessor.this.selector, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block19: while (true) {
                block40: {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Selector thread cycle begin...");
                    }
                    List list = NioTcpMessageProcessor.this.changeRequests;
                    synchronized (list) {
                        for (ChangeRequest change : NioTcpMessageProcessor.this.changeRequests) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("ChangeRequest " + change + " selector = " + NioTcpMessageProcessor.this.selector);
                            }
                            try {
                                switch (change.type) {
                                    case 2: {
                                        SelectionKey key = change.socket.keyFor(NioTcpMessageProcessor.this.selector);
                                        if (key == null || !key.isValid()) break;
                                        key.interestOps(change.ops);
                                        if (!logger.isLoggingEnabled(32)) break;
                                        logger.logDebug("Change opts " + change + " selector = " + NioTcpMessageProcessor.this.selector + " key = " + key + " blocking=" + change.socket.isBlocking());
                                        break;
                                    }
                                    case 1: {
                                        try {
                                            if (logger.isLoggingEnabled(32)) {
                                                logger.logDebug("NIO register " + change + " selector = " + NioTcpMessageProcessor.this.selector + " blocking=" + change.socket.isBlocking());
                                            }
                                            change.socket.register(NioTcpMessageProcessor.this.selector, change.ops);
                                            break;
                                        }
                                        catch (ClosedChannelException e) {
                                            logger.logWarning("Socket closed before register ops " + change.socket);
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.logError("Problem setting changes", e);
                            }
                        }
                        NioTcpMessageProcessor.this.changeRequests.clear();
                    }
                    try {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("Before select");
                        }
                        if (!NioTcpMessageProcessor.this.selector.isOpen()) {
                            if (logger.isLoggingEnabled(16)) {
                                logger.logInfo("Selector is closed ");
                            }
                            return;
                        }
                        NioTcpMessageProcessor.this.selector.select();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("After select");
                        }
                    }
                    catch (IOException e) {
                        logger.logError("problem in select", e);
                        break;
                    }
                    catch (CancelledKeyException cke) {
                        if (!logger.isLoggingEnabled(16)) break block40;
                        logger.logInfo("Looks like remote side closed a connection");
                    }
                }
                try {
                    if (NioTcpMessageProcessor.this.selector.selectedKeys() == null) {
                        if (!logger.isLoggingEnabled(32)) continue;
                        logger.logDebug("null selectedKeys ");
                        continue;
                    }
                    Iterator<SelectionKey> it = NioTcpMessageProcessor.this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!it.hasNext()) continue block19;
                        SelectionKey selectionKey = it.next();
                        try {
                            it.remove();
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("We got selkey " + selectionKey);
                            }
                            if (!selectionKey.isValid()) {
                                if (!logger.isLoggingEnabled(32)) continue;
                                logger.logDebug("Invalid key found " + selectionKey);
                                continue;
                            }
                            if (selectionKey.isAcceptable()) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("Accept " + selectionKey);
                                }
                                this.accept(selectionKey);
                                continue;
                            }
                            if (selectionKey.isReadable()) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("Read " + selectionKey);
                                }
                                this.read(selectionKey);
                                continue;
                            }
                            if (selectionKey.isWritable()) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("Write " + selectionKey);
                                }
                                this.write(selectionKey);
                                continue;
                            }
                            if (!selectionKey.isConnectable()) continue;
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Connect " + selectionKey);
                            }
                            this.connect(selectionKey);
                        }
                        catch (Exception e) {
                            logger.logError("Problem processing selection key event", e);
                        }
                    }
                }
                catch (ClosedSelectorException ex) {
                    if (logger.isLoggingEnabled(16)) {
                        logger.logInfo("Selector is closed");
                    }
                    return;
                }
                catch (Exception ex) {
                    logger.logError("Problem in the selector loop", ex);
                    continue;
                }
                break;
            }
        }
    }

    public static class ChangeRequest {
        public static final int REGISTER = 1;
        public static final int CHANGEOPS = 2;
        public SocketChannel socket;
        public int type;
        public int ops;

        public ChangeRequest(SocketChannel socket, int type, int ops) {
            this.socket = socket;
            this.type = type;
            this.ops = ops;
        }

        public String toString() {
            return this.socket + " type = " + this.type + " ops = " + this.ops;
        }
    }
}

