/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.EventHandler;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.RtxPayloadType;
import org.jitsi.nlj.format.VideoPayloadType;
import org.jitsi.nlj.rtp.PaddingVideoPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.PacketCache;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001c\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010#\u001a\u00020 J\u0018\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020 H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010#\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender;", "Lorg/jitsi/nlj/EventHandler;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "packetCache", "Lorg/jitsi/nlj/util/PacketCache;", "rtxDataSender", "Lorg/jitsi/nlj/PacketHandler;", "garbageDataSender", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/PacketCache;Lorg/jitsi/nlj/PacketHandler;Lorg/jitsi/nlj/PacketHandler;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "logger", "rtxSupported", "", "videoPayloadTypes", "", "Lorg/jitsi/nlj/format/VideoPayloadType;", "localVideoSsrc", "", "Ljava/lang/Long;", "numProbingBytesSentRtx", "numProbingBytesSentDummyData", "sendProbing", "", "mediaSsrcs", "", "numBytes", "sendRedundantDataOverRtx", "mediaSsrc", "currDummyTimestamp", "currDummySeqNum", "sendDummyData", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nProbingDataSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProbingDataSender.kt\norg/jitsi/nlj/transform/node/outgoing/ProbingDataSender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,202:1\n1863#2,2:203\n1863#2:209\n1864#2:214\n63#3,4:205\n63#3,4:210\n*S KotlinDebug\n*F\n+ 1 ProbingDataSender.kt\norg/jitsi/nlj/transform/node/outgoing/ProbingDataSender\n*L\n137#1:203,2\n75#1:209\n75#1:214\n179#1:205,4\n78#1:210,4\n*E\n"})
public final class ProbingDataSender
implements EventHandler,
NodeStatsProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PacketCache packetCache;
    @NotNull
    private final PacketHandler rtxDataSender;
    @NotNull
    private final PacketHandler garbageDataSender;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final TimeSeriesLogger timeSeriesLogger;
    @NotNull
    private final Logger logger;
    private boolean rtxSupported;
    @NotNull
    private final Set<VideoPayloadType> videoPayloadTypes;
    @Nullable
    private Long localVideoSsrc;
    private long numProbingBytesSentRtx;
    private long numProbingBytesSentDummyData;
    private long currDummyTimestamp;
    private int currDummySeqNum;
    @NotNull
    private static final Random random = new Random();

    public ProbingDataSender(@NotNull PacketCache packetCache, @NotNull PacketHandler rtxDataSender, @NotNull PacketHandler garbageDataSender, @NotNull DiagnosticContext diagnosticContext, @NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(packetCache, "packetCache");
        Intrinsics.checkNotNullParameter(rtxDataSender, "rtxDataSender");
        Intrinsics.checkNotNullParameter(garbageDataSender, "garbageDataSender");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.packetCache = packetCache;
        this.rtxDataSender = rtxDataSender;
        this.garbageDataSender = garbageDataSender;
        this.diagnosticContext = diagnosticContext;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, "newKeySet(...)");
        this.videoPayloadTypes = keySetView;
        streamInformationStore.onRtpPayloadTypesChanged(arg_0 -> ProbingDataSender._init_$lambda$2(this, arg_0));
        this.currDummyTimestamp = random.nextLong() & 0xFFFFFFFFL;
        this.currDummySeqNum = random.nextInt(65535);
    }

    public final int sendProbing(@NotNull Collection<Long> mediaSsrcs, int numBytes) {
        Intrinsics.checkNotNullParameter(mediaSsrcs, "mediaSsrcs");
        int totalBytesSent = 0;
        if (this.rtxSupported) {
            Iterator<Long> iterator2 = mediaSsrcs.iterator();
            while (iterator2.hasNext()) {
                long mediaSsrc = ((Number)iterator2.next()).longValue();
                if (totalBytesSent >= numBytes) break;
                int rtxBytesSent = this.sendRedundantDataOverRtx(mediaSsrc, numBytes - totalBytesSent);
                this.numProbingBytesSentRtx += (long)rtxBytesSent;
                totalBytesSent += rtxBytesSent;
                if (!this.timeSeriesLogger.isTraceEnabled()) continue;
                this.timeSeriesLogger.trace(this.diagnosticContext.makeTimeSeriesPoint("rtx_probing_bytes").addField("ssrc", mediaSsrc).addField("bytes", rtxBytesSent));
            }
        }
        if (totalBytesSent < numBytes) {
            int dummyBytesSent = this.sendDummyData(numBytes - totalBytesSent);
            this.numProbingBytesSentDummyData += (long)dummyBytesSent;
            totalBytesSent += dummyBytesSent;
            if (this.timeSeriesLogger.isTraceEnabled()) {
                this.timeSeriesLogger.trace(this.diagnosticContext.makeTimeSeriesPoint("dummy_probing_bytes").addField("bytes", dummyBytesSent));
            }
        }
        return totalBytesSent;
    }

    private final int sendRedundantDataOverRtx(long mediaSsrc, int numBytes) {
        int bytesSent = 0;
        Iterable $this$forEach$iv = this.packetCache.getMany(mediaSsrc, numBytes);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpPacket it = (RtpPacket)element$iv;
            boolean bl = false;
            bytesSent += it.length;
            this.rtxDataSender.processPacket(new PacketInfo(it, 0, null, 6, null));
        }
        return bytesSent;
    }

    private final int sendDummyData(int numBytes) {
        int remainingBytes;
        int packetLength;
        int bytesSent;
        VideoPayloadType videoPayloadType = (VideoPayloadType)CollectionsKt.firstOrNull((Iterable)this.videoPayloadTypes);
        if (videoPayloadType == null) {
            return bytesSent;
        }
        VideoPayloadType pt = videoPayloadType;
        Long l = this.localVideoSsrc;
        if (l == null) {
            return bytesSent;
        }
        long senderSsrc = l;
        for (bytesSent = 0; bytesSent < numBytes && (remainingBytes = numBytes - bytesSent) >= 12; bytesSent += packetLength) {
            int paddingSize = RangesKt.coerceAtMost(remainingBytes - 12, 255);
            packetLength = 12 + paddingSize;
            PaddingVideoPacket paddingPacket = PaddingVideoPacket.Companion.create(packetLength);
            paddingPacket.setPayloadType(UnsignedKt.toPositiveInt(pt.getPt()));
            paddingPacket.setSsrc(senderSsrc);
            paddingPacket.setTimestamp(this.currDummyTimestamp);
            paddingPacket.setSequenceNumber(this.currDummySeqNum);
            this.garbageDataSender.processPacket(new PacketInfo(paddingPacket, 0, null, 6, null));
            int n = this.currDummySeqNum;
            this.currDummySeqNum = n + 1;
        }
        this.currDummyTimestamp += (long)3000;
        return bytesSent;
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetLocalSsrcEvent && MediaType.VIDEO == ((SetLocalSsrcEvent)event).getMediaType()) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Setting video ssrc to " + ((SetLocalSsrcEvent)event).getSsrc());
            }
            this.localVideoSsrc = ((SetLocalSsrcEvent)event).getSsrc();
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u245 = nodeStatsBlock = new NodeStatsBlock("Probing data sender");
        boolean bl = false;
        $this$getNodeStats_u24lambda_u245.addNumber("num_bytes_of_probing_data_sent_as_rtx", this.numProbingBytesSentRtx);
        $this$getNodeStats_u24lambda_u245.addNumber("num_bytes_of_probing_data_sent_as_dummy", this.numProbingBytesSentDummyData);
        $this$getNodeStats_u24lambda_u245.addBoolean("rtx_supported", this.rtxSupported);
        $this$getNodeStats_u24lambda_u245.addString("local_video_ssrc", String.valueOf(this.localVideoSsrc));
        $this$getNodeStats_u24lambda_u245.addString("curr_dummy_timestamp", String.valueOf(this.currDummyTimestamp));
        $this$getNodeStats_u24lambda_u245.addString("curr_dummy_seq_num", String.valueOf(this.currDummySeqNum));
        $this$getNodeStats_u24lambda_u245.addString("video_payload_types", this.videoPayloadTypes.toString());
        return nodeStatsBlock;
    }

    private static final Unit _init_$lambda$2(ProbingDataSender this$0, Map currentRtpPayloadTypes) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(currentRtpPayloadTypes, "currentRtpPayloadTypes");
        if (currentRtpPayloadTypes.isEmpty()) {
            this$0.videoPayloadTypes.clear();
            this$0.rtxSupported = false;
        } else {
            Iterable $this$forEach$iv = currentRtpPayloadTypes.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadType pt = (PayloadType)element$iv;
                boolean bl = false;
                if (!this$0.rtxSupported && pt instanceof RtxPayloadType) {
                    this$0.rtxSupported = true;
                    Logger $this$cdebug$iv = this$0.logger;
                    boolean $i$f$cdebug = false;
                    if ($this$cdebug$iv.isDebugEnabled()) {
                        Logger logger = $this$cdebug$iv;
                        boolean bl2 = false;
                        logger.debug("RTX payload type signaled, enabling RTX probing");
                    }
                }
                if (!(pt instanceof VideoPayloadType)) continue;
                this$0.videoPayloadTypes.add((VideoPayloadType)pt);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/ProbingDataSender$Companion;", "", "<init>", "()V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Random getRandom() {
            return random;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

