/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import javax.xml.namespace.QName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;

public class Transport
extends AbstractPacketExtension {
    public static final String ELEMENT = "transport";
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final QName QNAME = new QName("jitsi:colibri2", "transport");
    public static final String ICE_CONTROLLING_ATTR_NAME = "ice-controlling";
    public static final boolean ICE_CONTROLLING_DEFAULT = false;
    public static final String USE_UNIQUE_PORT_ATTR_NAME = "use-unique-port";
    public static final boolean USE_UNIQUE_PORT_DEFAULT = false;

    public Transport() {
        super(NAMESPACE, ELEMENT);
    }

    private Transport(Builder b) {
        super(NAMESPACE, ELEMENT);
        if (b.iceControlling) {
            this.setAttribute(ICE_CONTROLLING_ATTR_NAME, b.iceControlling);
        }
        if (b.useUniquePort) {
            this.setAttribute(USE_UNIQUE_PORT_ATTR_NAME, b.useUniquePort);
        }
        if (b.iceUdpExtension != null) {
            this.addChildExtension(b.iceUdpExtension);
        }
        if (b.sctp != null) {
            this.addChildExtension(b.sctp);
        }
    }

    protected Transport(String namespace, String elementName) {
        super(namespace, elementName);
    }

    public boolean getIceControlling() {
        String iceControlling = this.getAttributeAsString(ICE_CONTROLLING_ATTR_NAME);
        return iceControlling == null ? false : Boolean.parseBoolean(iceControlling);
    }

    public boolean getUseUniquePort() {
        String use = this.getAttributeAsString(USE_UNIQUE_PORT_ATTR_NAME);
        return use == null ? false : Boolean.parseBoolean(use);
    }

    @Nullable
    public IceUdpTransportPacketExtension getIceUdpTransport() {
        return this.getChildExtension(IceUdpTransportPacketExtension.class);
    }

    @Nullable
    public Sctp getSctp() {
        return this.getChildExtension(Sctp.class);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static Builder getBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean useUniquePort = false;
        private boolean iceControlling = false;
        private IceUdpTransportPacketExtension iceUdpExtension;
        private Sctp sctp;

        public Builder setIceUdpExtension(IceUdpTransportPacketExtension iceUdpExtension) {
            this.iceUdpExtension = iceUdpExtension;
            return this;
        }

        public Builder setUseUniquePort(boolean useUniquePort) {
            this.useUniquePort = useUniquePort;
            return this;
        }

        public Builder setIceControlling(boolean i) {
            this.iceControlling = i;
            return this;
        }

        public Builder setSctp(Sctp sctp) {
            this.sctp = sctp;
            return this;
        }

        private Builder() {
        }

        @Contract(value=" -> new")
        @NotNull
        public Transport build() {
            return new Transport(this);
        }
    }
}

