/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.namednumber.LlcControlModifierFunction;
import org.pcap4j.util.ByteArrays;

public final class LlcControlUnnumbered
implements LlcPacket.LlcControl {
    private static final long serialVersionUID = 8688698899763120721L;
    private final LlcControlModifierFunction modifierFunction;
    private final boolean pfBit;

    public static LlcControlUnnumbered newInstance(byte value2) throws IllegalRawDataException {
        return new LlcControlUnnumbered(value2);
    }

    private LlcControlUnnumbered(byte value2) throws IllegalRawDataException {
        if ((value2 & 3) != 3) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("Both the lsb and the second lsb of the value must be 1. value: ").append(ByteArrays.toHexString(value2, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.modifierFunction = LlcControlModifierFunction.getInstance((byte)(value2 >> 2 & 0x3B));
        this.pfBit = (value2 & 0x10) != 0;
    }

    private LlcControlUnnumbered(Builder builder2) {
        if (builder2 == null || builder2.modifierFunction == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.modifierFunction: ").append(builder2.modifierFunction);
            throw new NullPointerException(sb.toString());
        }
        this.modifierFunction = builder2.modifierFunction;
        this.pfBit = builder2.pfBit;
    }

    public LlcControlModifierFunction getModifierFunction() {
        return this.modifierFunction;
    }

    public boolean getPfBit() {
        return this.pfBit;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[]{(byte)(3 | (Byte)this.modifierFunction.value() << 2)};
        if (this.pfBit) {
            data[0] = (byte)(data[0] | 0x10);
        }
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[modifier function: ").append(this.modifierFunction).append("] [P/F bit: ").append(this.pfBit ? 1 : 0).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.modifierFunction.hashCode();
        result = 31 * result + (this.pfBit ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LlcControlUnnumbered other = (LlcControlUnnumbered)obj;
        return this.modifierFunction.equals(other.modifierFunction) && this.pfBit == other.pfBit;
    }

    public static final class Builder {
        private LlcControlModifierFunction modifierFunction;
        private boolean pfBit;

        public Builder() {
        }

        private Builder(LlcControlUnnumbered ctrl) {
            this.modifierFunction = ctrl.modifierFunction;
            this.pfBit = ctrl.pfBit;
        }

        public Builder modifierFunction(LlcControlModifierFunction modifierFunction) {
            this.modifierFunction = modifierFunction;
            return this;
        }

        public Builder pfBit(boolean pfBit) {
            this.pfBit = pfBit;
            return this;
        }

        public LlcControlUnnumbered build() {
            return new LlcControlUnnumbered(this);
        }
    }
}

