/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcap4j.util.ByteArrays;

public class LinkLayerAddress
implements Serializable {
    private static final long serialVersionUID = -2832879271594305200L;
    protected static final Pattern HEX_SEPARATOR_PATTERN = Pattern.compile("([^0-9a-fA-F])");
    private final byte[] address;

    protected LinkLayerAddress(byte[] address) {
        this.address = address;
    }

    public static LinkLayerAddress getByAddress(byte[] address) {
        return new LinkLayerAddress(ByteArrays.clone(address));
    }

    public static LinkLayerAddress getByName(String name) {
        Matcher m4 = HEX_SEPARATOR_PATTERN.matcher(name);
        m4.find();
        return LinkLayerAddress.getByName(name, m4.group(1));
    }

    public static LinkLayerAddress getByName(String name, String separator) {
        return LinkLayerAddress.getByAddress(ByteArrays.parseByteArray(name, separator));
    }

    public byte[] getAddress() {
        return ByteArrays.clone(this.address);
    }

    public int length() {
        return this.address.length;
    }

    public String toString() {
        return ByteArrays.toHexString(this.address, ":");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinkLayerAddress)) {
            return false;
        }
        return Arrays.equals(((LinkLayerAddress)obj).getAddress(), this.address);
    }

    public int hashCode() {
        return Arrays.hashCode(this.address);
    }
}

