/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectNature;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaProjectGenerator {
    private static final String[] rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects", "project-license"};
    private static final String[] viewElementsOrder = new String[]{"items", "context-menu"};
    private static final String[] folderElementsOrder = new String[]{"source-folder", "build-folder", "build-file"};
    private static final String[] viewItemElementsOrder = new String[]{"source-folder", "source-file"};

    public static List<SourceFolder> getSourceFolders(AntProjectHelper helper, String type) {
        ArrayList<SourceFolder> list = new ArrayList<SourceFolder>();
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Element foldersEl = XMLUtil.findElement((Element)data, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersEl == null) {
            return list;
        }
        for (Element sourceFolderEl : XMLUtil.findSubElements((Element)foldersEl)) {
            if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
            SourceFolder sf = new SourceFolder();
            Element el = XMLUtil.findElement((Element)sourceFolderEl, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (el != null) {
                sf.label = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.type = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.location = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.includes = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.excludes = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"encoding", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.encoding = XMLUtil.findText((Node)el);
            }
            if (type != null && !type.equals(sf.type)) continue;
            if (sf.label == null || sf.label.length() == 0) {
                throw new IllegalArgumentException("label element is empty or not specified. " + helper.getProjectDirectory());
            }
            if (sf.location == null || sf.location.length() == 0) {
                throw new IllegalArgumentException("location element is empty or not specified. " + helper.getProjectDirectory());
            }
            list.add(sf);
        }
        return list;
    }

    public static void putSourceFolders(AntProjectHelper helper, List<SourceFolder> sources, String type) {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Document doc = data.getOwnerDocument();
        Element foldersEl = XMLUtil.findElement((Element)data, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersEl == null) {
            foldersEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folders");
            XMLUtil.appendChildElement((Element)data, (Element)foldersEl, (String[])rootElementsOrder);
        } else {
            for (Element sourceFolderEl : XMLUtil.findSubElements((Element)foldersEl)) {
                String typeElValue;
                if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
                if (type == null) {
                    foldersEl.removeChild(sourceFolderEl);
                    continue;
                }
                Element typeEl = XMLUtil.findElement((Element)sourceFolderEl, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
                if (typeEl == null || !type.equals(typeElValue = XMLUtil.findText((Node)typeEl))) continue;
                foldersEl.removeChild(sourceFolderEl);
            }
        }
        for (SourceFolder sf : sources) {
            Element sourceFolderEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-folder");
            if (sf.label == null || sf.label.length() <= 0) {
                throw new IllegalArgumentException("label cannot be empty. " + helper.getProjectDirectory());
            }
            Element el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
            el.appendChild(doc.createTextNode(sf.label));
            sourceFolderEl.appendChild(el);
            if (sf.type != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "type");
                el.appendChild(doc.createTextNode(sf.type));
                sourceFolderEl.appendChild(el);
            }
            if (sf.location == null || sf.location.length() <= 0) {
                throw new IllegalArgumentException("location cannot be empty. " + helper.getProjectDirectory());
            }
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            el.appendChild(doc.createTextNode(sf.location));
            sourceFolderEl.appendChild(el);
            if (sf.includes != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "includes");
                el.appendChild(doc.createTextNode(sf.includes));
                sourceFolderEl.appendChild(el);
            }
            if (sf.excludes != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "excludes");
                el.appendChild(doc.createTextNode(sf.excludes));
                sourceFolderEl.appendChild(el);
            }
            if (sf.encoding != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "encoding");
                el.appendChild(doc.createTextNode(sf.encoding));
                sourceFolderEl.appendChild(el);
            }
            XMLUtil.appendChildElement((Element)foldersEl, (Element)sourceFolderEl, (String[])folderElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)helper, (Element)data);
    }

    public static List<SourceFolder> getSourceViews(AntProjectHelper helper, String style) {
        ArrayList<SourceFolder> list = new ArrayList<SourceFolder>();
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Element viewEl = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            return list;
        }
        Element itemsEl = XMLUtil.findElement((Element)viewEl, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (itemsEl == null) {
            return list;
        }
        for (Element sourceFolderEl : XMLUtil.findSubElements((Element)itemsEl)) {
            if (!sourceFolderEl.getLocalName().equals("source-folder")) continue;
            SourceFolder sf = new SourceFolder();
            sf.style = sourceFolderEl.getAttribute("style");
            assert (sf.style != null && sf.style.length() > 0) : "Bad style attr on <source-folder> in " + helper;
            Element el = XMLUtil.findElement((Element)sourceFolderEl, (String)"label", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (el != null) {
                sf.label = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.location = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"includes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.includes = XMLUtil.findText((Node)el);
            }
            if ((el = XMLUtil.findElement((Element)sourceFolderEl, (String)"excludes", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                sf.excludes = XMLUtil.findText((Node)el);
            }
            if (style != null && !style.equals(sf.style)) continue;
            list.add(sf);
        }
        return list;
    }

    public static void putSourceViews(AntProjectHelper helper, List<SourceFolder> sources, String style) {
        Element itemsEl;
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Document doc = data.getOwnerDocument();
        Element viewEl = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            XMLUtil.appendChildElement((Element)data, (Element)viewEl, (String[])rootElementsOrder);
        }
        if ((itemsEl = XMLUtil.findElement((Element)viewEl, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) {
            itemsEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "items");
            XMLUtil.appendChildElement((Element)viewEl, (Element)itemsEl, (String[])viewElementsOrder);
        }
        List sourceViews = XMLUtil.findSubElements((Element)itemsEl);
        for (Element sourceViewEl : sourceViews) {
            if (!sourceViewEl.getLocalName().equals("source-folder")) continue;
            String sourceStyle = sourceViewEl.getAttribute("style");
            if (style != null && !style.equals(sourceStyle)) continue;
            itemsEl.removeChild(sourceViewEl);
        }
        for (SourceFolder sf : sources) {
            Element el;
            if (sf.style == null || sf.style.length() == 0) continue;
            Element sourceFolderEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-folder");
            sourceFolderEl.setAttribute("style", sf.style);
            if (sf.label != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
                el.appendChild(doc.createTextNode(sf.label));
                sourceFolderEl.appendChild(el);
            }
            if (sf.location != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
                el.appendChild(doc.createTextNode(sf.location));
                sourceFolderEl.appendChild(el);
            }
            if (sf.includes != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "includes");
                el.appendChild(doc.createTextNode(sf.includes));
                sourceFolderEl.appendChild(el);
            }
            if (sf.excludes != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "excludes");
                el.appendChild(doc.createTextNode(sf.excludes));
                sourceFolderEl.appendChild(el);
            }
            XMLUtil.appendChildElement((Element)itemsEl, (Element)sourceFolderEl, (String[])viewItemElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)helper, (Element)data);
    }

    public static Element getJavaCompilationUnits(AuxiliaryConfiguration aux) {
        for (String ns : JavaProjectNature.JAVA_NAMESPACES) {
            Element data = aux.getConfigurationFragment("java-data", ns, true);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static List<JavaCompilationUnit> getJavaCompilationUnits(AntProjectHelper helper, AuxiliaryConfiguration aux) {
        ArrayList<JavaCompilationUnit> list = new ArrayList<JavaCompilationUnit>();
        Element data = JavaProjectGenerator.getJavaCompilationUnits(aux);
        if (data == null) {
            return list;
        }
        for (Element cuEl : XMLUtil.findSubElements((Element)data)) {
            JavaCompilationUnit cu = new JavaCompilationUnit();
            ArrayList<String> outputs = new ArrayList<String>();
            ArrayList<String> javadoc = new ArrayList<String>();
            ArrayList<JavaCompilationUnit.CP> cps = new ArrayList<JavaCompilationUnit.CP>();
            ArrayList<String> packageRoots = new ArrayList<String>();
            for (Element el : XMLUtil.findSubElements((Element)cuEl)) {
                if (el.getLocalName().equals("package-root")) {
                    packageRoots.add(XMLUtil.findText((Node)el));
                    continue;
                }
                if (el.getLocalName().equals("classpath")) {
                    JavaCompilationUnit.CP cp = new JavaCompilationUnit.CP();
                    cp.classpath = XMLUtil.findText((Node)el);
                    cp.mode = el.getAttribute("mode");
                    if (cp.mode == null || cp.classpath == null) continue;
                    cps.add(cp);
                    continue;
                }
                if (el.getLocalName().equals("built-to")) {
                    outputs.add(XMLUtil.findText((Node)el));
                    continue;
                }
                if (el.getLocalName().equals("javadoc-built-to")) {
                    javadoc.add(XMLUtil.findText((Node)el));
                    continue;
                }
                if (el.getLocalName().equals("source-level")) {
                    cu.sourceLevel = XMLUtil.findText((Node)el);
                    continue;
                }
                if (el.getLocalName().equals("unit-tests")) {
                    cu.isTests = true;
                    continue;
                }
                if (!"annotation-processing".equals(el.getLocalName()) || !JavaProjectNature.namespaceAtLeast(el.getNamespaceURI(), "http://www.netbeans.org/ns/freeform-project-java/3")) continue;
                cu.annotationPorocessing = new JavaCompilationUnit.AnnotationProcessing();
                cu.annotationPorocessing.trigger = EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
                cu.annotationPorocessing.processors = new ArrayList<String>();
                cu.annotationPorocessing.processorParams = new LinkedHashMap<String, String>();
                for (Element apEl : XMLUtil.findSubElements((Element)el)) {
                    String localName = apEl.getLocalName();
                    if ("scan-trigger".equals(localName)) {
                        cu.annotationPorocessing.trigger.add(AnnotationProcessingQuery.Trigger.ON_SCAN);
                        continue;
                    }
                    if ("editor-trigger".equals(localName)) {
                        cu.annotationPorocessing.trigger.add(AnnotationProcessingQuery.Trigger.IN_EDITOR);
                        continue;
                    }
                    if ("source-output".equals(localName)) {
                        cu.annotationPorocessing.sourceOutput = XMLUtil.findText((Node)apEl);
                        continue;
                    }
                    if ("processor-path".equals(localName)) {
                        cu.annotationPorocessing.processorPath = XMLUtil.findText((Node)apEl);
                        continue;
                    }
                    if ("processor".equals(localName)) {
                        cu.annotationPorocessing.processors.add(XMLUtil.findText((Node)apEl));
                        continue;
                    }
                    if (!"processor-option".equals(localName)) continue;
                    Element keyEl = XMLUtil.findElement((Element)apEl, (String)"key", (String)el.getNamespaceURI());
                    Element valueEl = XMLUtil.findElement((Element)apEl, (String)"value", (String)el.getNamespaceURI());
                    if (keyEl == null || valueEl == null) continue;
                    String key = XMLUtil.findText((Node)keyEl);
                    String value = XMLUtil.findText((Node)valueEl);
                    if (key == null) continue;
                    cu.annotationPorocessing.processorParams.put(key, value);
                }
            }
            cu.output = outputs.size() > 0 ? outputs : null;
            cu.javadoc = javadoc.size() > 0 ? javadoc : null;
            cu.classpath = cps.size() > 0 ? cps : null;
            cu.packageRoots = packageRoots.size() > 0 ? packageRoots : null;
            list.add(cu);
        }
        return list;
    }

    public static void putJavaCompilationUnits(AntProjectHelper helper, AuxiliaryConfiguration aux, List<JavaCompilationUnit> compUnits) {
        String namespace;
        int requiredVersion = 1;
        for (JavaCompilationUnit unit : compUnits) {
            requiredVersion = Math.max(requiredVersion, JavaProjectGenerator.minimalNS(unit));
        }
        switch (requiredVersion) {
            case 5: {
                namespace = "http://www.netbeans.org/ns/freeform-project-java/5";
                break;
            }
            case 4: {
                namespace = "http://www.netbeans.org/ns/freeform-project-java/4";
                break;
            }
            case 3: {
                namespace = "http://www.netbeans.org/ns/freeform-project-java/3";
                break;
            }
            case 2: {
                namespace = "http://www.netbeans.org/ns/freeform-project-java/2";
                break;
            }
            default: {
                namespace = "http://www.netbeans.org/ns/freeform-project-java/1";
            }
        }
        Element data = JavaProjectGenerator.getJavaCompilationUnits(aux);
        if (data == null || !JavaProjectNature.namespaceAtLeast(data.getNamespaceURI(), namespace)) {
            if (data != null) {
                aux.removeConfigurationFragment("java-data", data.getNamespaceURI(), true);
            }
            data = Util.getPrimaryConfigurationData((AntProjectHelper)helper).getOwnerDocument().createElementNS(namespace, "java-data");
        }
        Document doc = data.getOwnerDocument();
        for (Element cuEl : XMLUtil.findSubElements((Element)data)) {
            data.removeChild(cuEl);
        }
        for (JavaCompilationUnit cu : compUnits) {
            Element el;
            Element cuEl = doc.createElementNS(data.getNamespaceURI(), "compilation-unit");
            data.appendChild(cuEl);
            if (cu.packageRoots != null) {
                for (String string : cu.packageRoots) {
                    el = doc.createElementNS(data.getNamespaceURI(), "package-root");
                    el.appendChild(doc.createTextNode(string));
                    cuEl.appendChild(el);
                }
            }
            if (cu.isTests) {
                assert (JavaProjectNature.namespaceAtLeast(namespace, "http://www.netbeans.org/ns/freeform-project-java/2"));
                cuEl.appendChild(doc.createElementNS(data.getNamespaceURI(), "unit-tests"));
            }
            if (cu.classpath != null) {
                for (JavaCompilationUnit.CP cP : cu.classpath) {
                    el = doc.createElementNS(data.getNamespaceURI(), "classpath");
                    el.appendChild(doc.createTextNode(cP.classpath));
                    el.setAttribute("mode", cP.mode);
                    cuEl.appendChild(el);
                }
            }
            if (cu.output != null) {
                for (String string : cu.output) {
                    el = doc.createElementNS(data.getNamespaceURI(), "built-to");
                    el.appendChild(doc.createTextNode(string));
                    cuEl.appendChild(el);
                }
            }
            if (cu.javadoc != null) {
                for (String string : cu.javadoc) {
                    assert (JavaProjectNature.namespaceAtLeast(namespace, "http://www.netbeans.org/ns/freeform-project-java/2"));
                    el = doc.createElementNS(data.getNamespaceURI(), "javadoc-built-to");
                    el.appendChild(doc.createTextNode(string));
                    cuEl.appendChild(el);
                }
            }
            if (cu.sourceLevel != null) {
                el = doc.createElementNS(data.getNamespaceURI(), "source-level");
                el.appendChild(doc.createTextNode(cu.sourceLevel));
                cuEl.appendChild(el);
            }
            if (cu.annotationPorocessing == null) continue;
            el = doc.createElementNS(data.getNamespaceURI(), "annotation-processing");
            if (cu.annotationPorocessing.trigger.contains(AnnotationProcessingQuery.Trigger.ON_SCAN)) {
                el.appendChild(doc.createElementNS(data.getNamespaceURI(), "scan-trigger"));
            }
            if (cu.annotationPorocessing.trigger.contains(AnnotationProcessingQuery.Trigger.IN_EDITOR)) {
                el.appendChild(doc.createElementNS(data.getNamespaceURI(), "editor-trigger"));
            }
            if (cu.annotationPorocessing.sourceOutput != null) {
                Element soElm = doc.createElementNS(data.getNamespaceURI(), "source-output");
                soElm.appendChild(doc.createTextNode(cu.annotationPorocessing.sourceOutput));
                el.appendChild(soElm);
            }
            if (cu.annotationPorocessing.processorPath != null) {
                Element ppElm = doc.createElementNS(data.getNamespaceURI(), "processor-path");
                ppElm.appendChild(doc.createTextNode(cu.annotationPorocessing.processorPath));
                el.appendChild(ppElm);
            }
            for (String string : cu.annotationPorocessing.processors) {
                Element pElm = doc.createElementNS(data.getNamespaceURI(), "processor");
                pElm.appendChild(doc.createTextNode(string));
                el.appendChild(pElm);
            }
            for (Map.Entry entry : cu.annotationPorocessing.processorParams.entrySet()) {
                Element poElm = doc.createElementNS(data.getNamespaceURI(), "processor-option");
                Element keyElm = doc.createElementNS(data.getNamespaceURI(), "key");
                Element valueElm = doc.createElementNS(data.getNamespaceURI(), "value");
                keyElm.appendChild(doc.createTextNode((String)entry.getKey()));
                if (entry.getValue() != null) {
                    valueElm.appendChild(doc.createTextNode((String)entry.getValue()));
                }
                poElm.appendChild(keyElm);
                poElm.appendChild(valueElm);
                el.appendChild(poElm);
            }
            cuEl.appendChild(el);
        }
        aux.putConfigurationFragment(data, true);
    }

    public static List<Export> guessExports(PropertyEvaluator evaluator, File baseFolder, List<TargetMapping> targetMappings, List<JavaCompilationUnit> javaCompilationUnits) {
        ArrayList<Export> exports = new ArrayList<Export>();
        String targetName = null;
        String scriptName = null;
        for (TargetMapping tm : targetMappings) {
            if (!tm.name.equals("build")) continue;
            if (tm.targets.size() == 1) {
                targetName = tm.targets.get(0);
                scriptName = tm.script;
                continue;
            }
            return new ArrayList<Export>();
        }
        if (targetName == null) {
            return new ArrayList<Export>();
        }
        for (JavaCompilationUnit cu : javaCompilationUnits) {
            if (cu.output == null) continue;
            for (String output : cu.output) {
                Export e;
                String output2 = evaluator.evaluate(output);
                if (output2.endsWith(".jar")) {
                    e = new Export();
                    e.type = "jar";
                    e.location = output;
                    e.script = scriptName;
                    e.buildTarget = targetName;
                    exports.add(e);
                    continue;
                }
                if (!JavaProjectGenerator.isFolder(evaluator, baseFolder, output2)) continue;
                e = new Export();
                e.type = "folder";
                e.location = output;
                e.script = scriptName;
                e.buildTarget = targetName;
                exports.add(e);
            }
        }
        return exports;
    }

    public static void putExports(AntProjectHelper helper, List<Export> exports) {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Document doc = data.getOwnerDocument();
        for (Element exportEl : XMLUtil.findSubElements((Element)data)) {
            if (!exportEl.getLocalName().equals("export")) continue;
            data.removeChild(exportEl);
        }
        for (Export export : exports) {
            Element exportEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "export");
            Element el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "type");
            el.appendChild(doc.createTextNode(export.type));
            exportEl.appendChild(el);
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            el.appendChild(doc.createTextNode(export.location));
            exportEl.appendChild(el);
            if (export.script != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
                el.appendChild(doc.createTextNode(export.script));
                exportEl.appendChild(el);
            }
            el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "build-target");
            el.appendChild(doc.createTextNode(export.buildTarget));
            exportEl.appendChild(el);
            if (export.cleanTarget != null) {
                el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "clean-target");
                el.appendChild(doc.createTextNode(export.cleanTarget));
                exportEl.appendChild(el);
            }
            XMLUtil.appendChildElement((Element)data, (Element)exportEl, (String[])rootElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)helper, (Element)data);
    }

    public static List<String> guessSubprojects(PropertyEvaluator evaluator, List<JavaCompilationUnit> javaCompilationUnits, File projectBase, File freeformBase) {
        HashSet<String> subprojs = new HashSet<String>();
        for (JavaCompilationUnit cu : javaCompilationUnits) {
            if (cu.classpath == null) continue;
            for (JavaCompilationUnit.CP cp : cu.classpath) {
                String classpath;
                if (!"compile".equals(cp.mode) || (classpath = evaluator.evaluate(cp.classpath)) == null) continue;
                for (String s : PropertyUtils.tokenizePath((String)classpath)) {
                    File file = FileUtil.normalizeFile((File)new File(s));
                    AntArtifact aa = AntArtifactQuery.findArtifactFromFile((File)file);
                    if (aa == null) continue;
                    File proj = FileUtil.toFile((FileObject)aa.getProject().getProjectDirectory());
                    String p = Util.relativizeLocation((File)projectBase, (File)freeformBase, (File)proj);
                    subprojs.add(p);
                }
            }
        }
        return new ArrayList<String>(subprojs);
    }

    public static void putSubprojects(AntProjectHelper helper, List<String> subprojects) {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Document doc = data.getOwnerDocument();
        Element subproject = XMLUtil.findElement((Element)data, (String)"subprojects", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (subproject != null) {
            data.removeChild(subproject);
        }
        subproject = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "subprojects");
        XMLUtil.appendChildElement((Element)data, (Element)subproject, (String[])rootElementsOrder);
        for (String proj : subprojects) {
            Element projEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "project");
            projEl.appendChild(doc.createTextNode(proj));
            subproject.appendChild(projEl);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)helper, (Element)data);
    }

    public static List<String> guessBuildFolders(PropertyEvaluator evaluator, List<JavaCompilationUnit> javaCompilationUnits, File projectBase, File freeformBase) {
        ArrayList<String> buildFolders = new ArrayList<String>();
        for (JavaCompilationUnit cu : javaCompilationUnits) {
            if (cu.output == null) continue;
            for (String output : cu.output) {
                File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)freeformBase, (String)output);
                if (!f.isDirectory()) continue;
                String absOutput = f.getAbsolutePath();
                if (!absOutput.endsWith(File.separator)) {
                    absOutput = absOutput + File.separatorChar;
                }
                if (absOutput.startsWith(projectBase.getAbsolutePath() + File.separatorChar) || absOutput.startsWith(freeformBase.getAbsolutePath() + File.separatorChar)) continue;
                boolean add = true;
                Iterator it = buildFolders.iterator();
                while (it.hasNext()) {
                    String path = (String)it.next();
                    if (!path.endsWith(File.separator)) {
                        path = path + File.separatorChar;
                    }
                    if (path.equals(absOutput)) {
                        add = false;
                        break;
                    }
                    if (absOutput.startsWith(path)) {
                        add = false;
                        break;
                    }
                    if (!path.startsWith(absOutput)) continue;
                    it.remove();
                }
                if (!add) continue;
                buildFolders.add(output);
            }
        }
        return buildFolders;
    }

    public static void putBuildFolders(AntProjectHelper helper, List<String> buildFolders) {
        JavaProjectGenerator.putBuildElement(helper, buildFolders, "build-folder");
    }

    private static void putBuildElement(AntProjectHelper helper, List<String> buildFolders, String elemName) {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Document doc = data.getOwnerDocument();
        Element foldersEl = XMLUtil.findElement((Element)data, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (foldersEl == null) {
            foldersEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folders");
            XMLUtil.appendChildElement((Element)data, (Element)foldersEl, (String[])rootElementsOrder);
        } else {
            List folders = XMLUtil.findSubElements((Element)foldersEl);
            for (Element buildFolderEl : folders) {
                if (!buildFolderEl.getLocalName().equals(elemName)) continue;
                foldersEl.removeChild(buildFolderEl);
            }
        }
        for (String location : buildFolders) {
            Element buildFolderEl;
            buildFolderEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", elemName);
            Element locationEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
            locationEl.appendChild(doc.createTextNode(location));
            buildFolderEl.appendChild(locationEl);
            XMLUtil.appendChildElement((Element)foldersEl, (Element)buildFolderEl, (String[])folderElementsOrder);
        }
        Util.putPrimaryConfigurationData((AntProjectHelper)helper, (Element)data);
    }

    public static List<String> getBuildFiles(PropertyEvaluator evaluator, List<JavaCompilationUnit> compUnits, File projectBase, File freeformBase) {
        ArrayList<String> buildFiles = new ArrayList<String>();
        for (JavaCompilationUnit cu : compUnits) {
            if (cu.output == null) continue;
            for (String output : cu.output) {
                String absOutput;
                File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)freeformBase, (String)output);
                try {
                    if (f.exists() && !FileUtil.isArchiveFile((URL)Utilities.toURI((File)f).toURL())) {
                        continue;
                    }
                }
                catch (MalformedURLException murle) {
                    Exceptions.printStackTrace((Throwable)murle);
                }
                if ((absOutput = f.getAbsolutePath()).startsWith(projectBase.getAbsolutePath() + File.separatorChar) || absOutput.startsWith(freeformBase.getAbsolutePath() + File.separatorChar)) continue;
                boolean add = true;
                for (String path : buildFiles) {
                    if (!path.equals(absOutput)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                buildFiles.add(output);
            }
        }
        return buildFiles;
    }

    public static void putBuildFiles(AntProjectHelper helper, List<String> buildFiles) {
        JavaProjectGenerator.putBuildElement(helper, buildFiles, "build-file");
    }

    public static List<TargetMapping> getTargetMappings(AntProjectHelper helper) {
        ArrayList<TargetMapping> list = new ArrayList<TargetMapping>();
        Element genldata = Util.getPrimaryConfigurationData((AntProjectHelper)helper);
        Element actionsEl = XMLUtil.findElement((Element)genldata, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (actionsEl == null) {
            return list;
        }
        for (Element actionEl : XMLUtil.findSubElements((Element)actionsEl)) {
            TargetMapping tm = new TargetMapping();
            tm.name = actionEl.getAttribute("name");
            ArrayList<String> targetNames = new ArrayList<String>();
            EditableProperties props = new EditableProperties(false);
            for (Element subEl : XMLUtil.findSubElements((Element)actionEl)) {
                if (subEl.getLocalName().equals("target")) {
                    targetNames.add(XMLUtil.findText((Node)subEl));
                    continue;
                }
                if (subEl.getLocalName().equals("script")) {
                    tm.script = XMLUtil.findText((Node)subEl);
                    continue;
                }
                if (subEl.getLocalName().equals("context")) {
                    TargetMapping.Context ctx = new TargetMapping.Context();
                    for (Element contextSubEl : XMLUtil.findSubElements((Element)subEl)) {
                        Element sepFilesEl;
                        if (contextSubEl.getLocalName().equals("property")) {
                            ctx.property = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("format")) {
                            ctx.format = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("folder")) {
                            ctx.folder = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("pattern")) {
                            ctx.pattern = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (!contextSubEl.getLocalName().equals("arity") || (sepFilesEl = XMLUtil.findElement((Element)contextSubEl, (String)"separated-files", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                        ctx.separator = XMLUtil.findText((Node)sepFilesEl);
                    }
                    tm.context = ctx;
                }
                if (!subEl.getLocalName().equals("property")) continue;
                JavaProjectGenerator.readProperty(subEl, props);
            }
            tm.targets = targetNames;
            if (props.keySet().size() > 0) {
                tm.properties = props;
            }
            list.add(tm);
        }
        return list;
    }

    static boolean isFolder(PropertyEvaluator eval, File baseFolder, String folder) {
        File f = Util.resolveFile((PropertyEvaluator)eval, (File)baseFolder, (String)folder);
        if (f != null && f.isDirectory()) {
            return true;
        }
        int dotIndex = folder.lastIndexOf(46);
        int slashIndex = folder.lastIndexOf(47);
        return dotIndex == -1 || dotIndex < slashIndex;
    }

    private static void readProperty(Element propertyElement, EditableProperties props) {
        String key = propertyElement.getAttribute("name");
        String value = XMLUtil.findText((Node)propertyElement);
        props.setProperty(key, value);
    }

    private static int minimalNS(JavaCompilationUnit unit) {
        int min = 1;
        if (unit.isTests || unit.javadoc != null && !unit.javadoc.isEmpty()) {
            min = 2;
        }
        if (unit.annotationPorocessing != null) {
            min = 3;
        }
        if (unit.sourceLevel != null) {
            SpecificationVersion JAVA_6 = new SpecificationVersion("1.6");
            SpecificationVersion JAVA_7 = new SpecificationVersion("1.7");
            SpecificationVersion JAVA_8 = new SpecificationVersion("1.8");
            SpecificationVersion JAVA_9 = new SpecificationVersion("9");
            SpecificationVersion current = new SpecificationVersion(unit.sourceLevel);
            if (JAVA_6.equals((Object)current) || JAVA_7.equals((Object)current)) {
                min = 3;
            } else if (JAVA_8.equals((Object)current)) {
                min = 4;
            } else if (JAVA_9.compareTo(current) <= 0) {
                min = 5;
            }
        }
        return min;
    }

    public static final class SourceFolder {
        public String label;
        public String type;
        public String location;
        public String style;
        public String includes;
        public String excludes;
        public String encoding;

        public String toString() {
            return "FPG.SF[label=" + this.label + ",type=" + this.type + ",location=" + this.location + ",style=" + this.style + ",includes=" + this.includes + ",excludes=" + this.excludes + ",encoding=" + this.encoding + "]";
        }
    }

    public static final class JavaCompilationUnit {
        public List<String> packageRoots;
        public List<CP> classpath;
        public List<String> output;
        public List<String> javadoc;
        public String sourceLevel;
        public boolean isTests;
        public AnnotationProcessing annotationPorocessing;

        public String toString() {
            return "FPG.JCU[packageRoots=" + this.packageRoots + ", classpath=" + this.classpath + ", output=" + this.output + ", javadoc=" + this.javadoc + ", sourceLevel=" + this.sourceLevel + ",isTests=" + this.isTests + "]";
        }

        public static final class AnnotationProcessing {
            public Set<AnnotationProcessingQuery.Trigger> trigger;
            public String sourceOutput;
            public String processorPath;
            public List<String> processors;
            public Map<String, String> processorParams;

            public String toString() {
                return String.format("Processors run: %s, source output %s, processor path: %s, processors: %s, processor options: %s", this.trigger, this.sourceOutput, this.processorPath, this.processors, this.processorParams);
            }
        }

        public static final class CP {
            public String classpath;
            public String mode;

            public String toString() {
                return "FPG.JCU.CP:[classpath=" + this.classpath + ", mode=" + this.mode + ", this=" + super.toString() + "]";
            }
        }
    }

    public static final class TargetMapping {
        public String script;
        public List<String> targets;
        public String name;
        public EditableProperties properties;
        public Context context;

        public static final class Context {
            public String property;
            public String format;
            public String folder;
            public String pattern;
            public String separator;
        }
    }

    public static final class Export {
        public String type;
        public String location;
        public String script;
        public String buildTarget;
        public String cleanTarget;
    }
}

