/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.htmlxml;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spellchecker.bindings.htmlxml.AbstractTokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class XmlTokenList
extends AbstractTokenList {
    private boolean hidden = false;

    public XmlTokenList(BaseDocument doc) {
        super(doc);
    }

    @Override
    public void setStartOffset(int offset) {
        super.setStartOffset(offset);
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/XML");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    @Override
    protected int[] findNextSpellSpan() throws BadLocationException {
        TokenHierarchy h = TokenHierarchy.get((Document)this.doc);
        TokenSequence ts = h.tokenSequence();
        if (ts == null || this.hidden) {
            return new int[]{-1, -1};
        }
        ts.move(this.nextSearchOffset);
        while (ts.moveNext()) {
            TokenId id = ts.token().id();
            if (id != XMLTokenId.BLOCK_COMMENT && id != XMLTokenId.TEXT) continue;
            return new int[]{ts.offset(), ts.offset() + ts.token().length()};
        }
        return new int[]{-1, -1};
    }
}

