/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.migration.archiver.deserializer;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.ArrayListStack;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.BaseSpecificXMLDeserializer;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.NewInstanceHelper;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XMLGraphDeserializer
extends BaseSpecificXMLDeserializer
implements Serializable {
    public static final int XGD_END = 99;
    public static final int XGD_NEED_ATTRIBUTE = 1;
    public static final int XGD_NEED_END_ATTR = 2;
    public static final int XGD_NEED_END_NULLVALUE = 4;
    public static final int XGD_NEED_END_OBJECT = 5;
    public static final int XGD_NEED_END_PARAM = 10;
    public static final int XGD_NEED_END_ROW = 3;
    public static final int XGD_NEED_END_ROW_ELEMENT = 14;
    public static final int XGD_NEED_OBJECT = 7;
    public static final int XGD_NEED_PARAM = 9;
    public static final int XGD_NEED_ROW = 6;
    public static final int XGD_NEED_ROW_ELEMENT = 13;
    public static final int XGD_NEED_ROW_TAG = 12;
    public static final int XGD_NEED_STRING = 11;
    public static final int XGD_NEED_VALUE = 8;
    private HashMap ObjectHash;
    private ArrayListStack AttrNameStack;
    ArrayListStack RowTypeStack;
    private ArrayListStack RowCountStack;
    private HashMap hashedClasses = new HashMap();

    public XMLGraphDeserializer(ClassLoader cl) {
        super(cl);
        this.AttrNameStack = new ArrayListStack();
        this.ObjectHash = new HashMap(20);
        this.RowTypeStack = new ArrayListStack();
        this.RowCountStack = new ArrayListStack();
    }

    public XMLGraphDeserializer() {
        this(null);
    }

    private Field findField(Object lCurrentObj, final String lCurrentField) {
        Field lField = null;
        Class<?> lClass = lCurrentObj.getClass();
        HashMap<String, Field> hashedFields = (HashMap<String, Field>)this.hashedClasses.get(lClass);
        if (hashedFields == null) {
            hashedFields = new HashMap<String, Field>();
            this.hashedClasses.put(lClass, hashedFields);
        } else {
            lField = (Field)hashedFields.get(lCurrentField);
        }
        while (lClass != null && lField == null) {
            final Class<?> tmpClass = lClass;
            lField = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Field tmpField = tmpClass.getDeclaredField(lCurrentField);
                        if (tmpField != null) {
                            tmpField.setAccessible(true);
                        }
                        return tmpField;
                    }
                    catch (NoSuchFieldException ex) {
                        return null;
                    }
                }
            });
            if (lField != null) {
                hashedFields.put(lCurrentField, lField);
                break;
            }
            lClass = lClass.getSuperclass();
        }
        return lField;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.State = 99;
    }

    @Override
    public void endElement(String name) throws SAXException {
        int lInitialState = this.State;
        try {
            if (name.equals("ARRAY")) {
                this.popRowCount();
            }
            if (!name.equals("_.ALIAS")) {
                switch (this.State) {
                    case 1: {
                        this.validateTag(name, "OBJECT", true);
                        this.popState();
                        break;
                    }
                    case 2: {
                        String lFieldName = this.topAttrName();
                        this.validateTag(this.unescapeName(name), lFieldName, true);
                        Object lObj = this.popObject();
                        this.setCurrentAttribute(lObj);
                        this.popAttrName();
                        this.popState();
                        break;
                    }
                    case 10: {
                        this.validateTag(name, "PARAM", true);
                        break;
                    }
                    case 3: {
                        this.validateTag(name, "ROW", true);
                        this.popState();
                        Object lRow = this.popObject();
                        Object lArrayRef = this.topObject();
                        if (lArrayRef instanceof Collection) {
                            Collection lArray = (Collection)lArrayRef;
                            lArray.add(lRow);
                            break;
                        }
                        if (!lArrayRef.getClass().isArray()) break;
                        int lRowNo = this.currentRowCount();
                        Array.set(lArrayRef, lRowNo, lRow);
                        this.incrementRowCount();
                        break;
                    }
                    case 4: {
                        this.validateTag(name, "NULLVALUE", true);
                        this.popState();
                        break;
                    }
                    case 5: {
                        this.validateTag(name, "OBJECT", true);
                        this.popState();
                        break;
                    }
                    case 9: {
                        this.popState();
                        break;
                    }
                    case 6: {
                        this.validateTag(name, "ARRAY", true);
                        this.popState();
                        this.popRowType();
                        break;
                    }
                    case 8: {
                        this.popState();
                        String lValue = null;
                        String lSource = this.getCharacters();
                        int lLength = lSource.length();
                        if (lLength != 0 || lLength != 1) {
                            lValue = lSource;
                        }
                        switch (this.State) {
                            case 3: {
                                this.validateTag(name, "ROW", true);
                                Collection lArray2 = (Collection)this.topObject();
                                Object lRow2 = null;
                                Class lRowType = this.topRowType();
                                if (lRowType == String.class) {
                                    String lNewString = lValue;
                                    lArray2.add(lNewString);
                                } else {
                                    lArray2.add(lRow2);
                                }
                                this.popState();
                                break;
                            }
                            case 2: {
                                this.validateTag(this.unescapeName(name), this.topAttrName(), true);
                                this.setCurrentAttribute(lValue);
                                this.popAttrName();
                                this.popState();
                                break;
                            }
                            case 10: {
                                this.popState();
                                this.pushState(9);
                            }
                        }
                        break;
                    }
                    case 11: {
                        this.popState();
                        break;
                    }
                    case 14: {
                        this.State = 13;
                        break;
                    }
                    case 13: {
                        this.State = 12;
                        break;
                    }
                    case 12: {
                        this.popState();
                        break;
                    }
                    case 7: {
                        this.unexpectedTag(name, "OBJECT", false);
                    }
                }
            }
            super.endElement(name);
        }
        catch (SAXException lError) {
            lError.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.endElement");
            System.out.println("Tag being process is " + name + " initial state was " + lInitialState);
            this.DumpStatus();
            throw lError;
        }
        catch (RuntimeException lError) {
            lError.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.endElement");
            System.out.println("Tag being process is " + name + " initial state was " + lInitialState);
            this.DumpStatus();
            throw lError;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.State = 99;
        this.pushState(7);
    }

    @Override
    public void startElement(String name, AttributeList atts) throws SAXException {
        int lInitialState = this.State;
        try {
            if (name.equals("ARRAY")) {
                this.pushRowCount();
            }
            if (name.equals("_.ALIAS")) {
                String lName = atts.getValue("NAME");
                String lAlias = atts.getValue("ALIAS");
                this.addActiveAlias(lName, lAlias);
            } else {
                switch (this.State) {
                    case 1: {
                        this.readAttributeHeader(name, atts);
                        break;
                    }
                    case 12: {
                        this.State = 13;
                        break;
                    }
                    case 13: {
                        this.State = 14;
                        break;
                    }
                    case 6: {
                        this.validateTag(name, "ROW", false);
                        if (this.checkSimpleRow(name, atts)) {
                            this.pushState(3);
                            break;
                        }
                        this.pushState(3);
                        this.pushState(8);
                        break;
                    }
                    case 7: {
                        this.validateTag(name, "OBJECT", false);
                        this.readObjectHeader(name, atts, false);
                        break;
                    }
                    case 9: {
                        this.popState();
                        this.pushState(10);
                        this.pushState(8);
                        break;
                    }
                    case 8: {
                        if (!(name.equals("OBJECT") || name.equals("ARRAY") || name.equals("NULLVALUE"))) {
                            this.unexpectedTag(name, "OBJECT, ARRAY, NULLVALUE", false);
                        }
                        this.readValue(name, atts);
                        break;
                    }
                    case 2: {
                        this.unexpectedTag(name, this.topAttrName(), true);
                        break;
                    }
                    case 10: {
                        this.unexpectedTag(name, "/PARAM", false);
                        break;
                    }
                    case 3: {
                        this.unexpectedTag(name, "/ROW", false);
                        break;
                    }
                    case 4: {
                        this.unexpectedTag(name, "/NULLVALUE", false);
                        break;
                    }
                    case 5: {
                        this.unexpectedTag(name, "/OBJECT", false);
                    }
                }
            }
            super.startElement(name, atts);
        }
        catch (SAXException lError) {
            lError.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.startElement");
            System.out.println("Tag being process is " + name + " initial state was " + lInitialState);
            System.out.println("Attribute list is :");
            for (int i = 0; i < atts.getLength(); ++i) {
                System.out.println("Attribute " + atts.getName(i) + " Type " + atts.getType(i) + " value " + atts.getValue(i));
            }
            this.DumpStatus();
            throw lError;
        }
        catch (RuntimeException lError) {
            lError.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.startElement");
            System.out.println("Tag being process is " + name + " initial state was " + lInitialState);
            System.out.println("Attribute list is :");
            for (int i = 0; i < atts.getLength(); ++i) {
                System.out.println("Attribute " + atts.getName(i) + " Type " + atts.getType(i) + " value " + atts.getValue(i));
            }
            this.DumpStatus();
            throw lError;
        }
    }

    @Override
    public Class findClass(String name) throws ClassNotFoundException {
        return super.findClass(this.lookupAlias(name));
    }

    public String popAttrName() {
        return (String)this.AttrNameStack.pop();
    }

    public void processObjectReference(String refName) throws SAXException {
        Object lObj = this.ObjectHash.get(refName);
        if (lObj == null) {
            String message = "Object " + refName + " could not be found";
            SAXException objError = new SAXException(message);
            throw objError;
        }
        this.pushObject(lObj);
    }

    public void pushAttrName(String name) {
        this.AttrNameStack.push(name);
    }

    public void readAttributeHeader(String name, AttributeList atts) {
        if (name == "_.METHOD" || name == "_.CALLBACK") {
            this.pushAttrName(atts.getValue("NAME"));
            this.pushAttrName(name);
            this.pushState(9);
            this.ParameterArray.clear();
        } else {
            this.pushAttrName(this.unescapeName(name));
            this.pushState(2);
            this.pushState(8);
        }
    }

    public void readObjectHeader(String name, AttributeList atts, boolean refOK) throws SAXException {
        String lRefName;
        boolean lFirstObj = this.ObjectStack.size() == 0;
        Object lObj = null;
        String lIDName = null;
        if (refOK && (lRefName = atts.getValue("REFERENCE")) != null) {
            this.processObjectReference(lRefName);
            this.State = 5;
            return;
        }
        lIDName = atts.getValue("ID");
        if (lFirstObj || !this.useExistingAttribute(atts, this.topAttrName(), lObj)) {
            String lClassName = atts.getValue("CLASS");
            if (lClassName == null) {
                lObj = null;
            } else {
                Class lClass = null;
                try {
                    lClass = this.findClass(lClassName);
                    lObj = WrapperClassHelper.isWrapperClass(lClass) ? new WrapperClassHelper(lClass, lIDName) : lClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                    String message = "Illegal Access to class " + lClass.getName();
                    SAXException useError = new SAXException(message);
                    throw useError;
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                    lObj = NewInstanceHelper.newInstance(lClassName, this.topObject());
                    if (lObj == null) {
                        e2.printStackTrace();
                        String message = "Instantiation exception of class " + lClass.getName();
                        SAXException useError = new SAXException(message);
                        throw useError;
                    }
                }
                catch (ClassNotFoundException e3) {
                    e3.printStackTrace();
                    String message = "Class " + lClass.getName() + " could not be found";
                    SAXException useError = new SAXException(message);
                    throw useError;
                }
            }
        }
        this.pushObject(lObj);
        if (lIDName != null) {
            this.ObjectHash.put(lIDName, lObj);
        }
        if (lFirstObj) {
            this.MasterDeserializer.setInitialObject(lObj);
        }
        this.State = lObj == null ? Integer.valueOf(5) : Integer.valueOf(1);
    }

    public String topAttrName() {
        return (String)this.AttrNameStack.peek();
    }

    public void readValue(String name, AttributeList atts) throws SAXException {
        boolean lFirstObj;
        boolean bl = lFirstObj = this.ObjectStack.size() == 0;
        if (name.equals("OBJECT")) {
            this.readObjectHeader(name, atts, true);
        } else if (name.equals("ARRAY")) {
            Object lObj = null;
            Class lRowClassType = null;
            Object lArray = null;
            String lArrayType = atts.getValue("CLASS");
            int lArraySize = Integer.parseInt(atts.getValue("SIZE"));
            String lRowTypeName = atts.getValue("ROWCLASS");
            if (!lArrayType.equals("PRIMITIVE")) {
                try {
                    Class lArrayTypeClass = this.findClass(lArrayType);
                    lArray = lArrayTypeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                    String message = "Class " + lArrayType + " could not be found, either it has the wrong name or cannot be found in lookup table";
                    SAXException classError = new SAXException(message);
                    throw classError;
                }
                catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                    String message = "Illegal Access exception whilst trying to init new instance of " + lArrayType;
                    SAXException accessError = new SAXException(message);
                    throw accessError;
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException e3) {
                    e3.printStackTrace();
                    String message = "Instantiation exception whilst trying to init new instance of " + lArrayType;
                    SAXException initError = new SAXException(message);
                    throw initError;
                }
            }
            if (!lFirstObj && this.useExistingAttribute(atts, this.topAttrName(), lObj)) {
                lArray = lObj;
            }
            if (lRowTypeName != null && !lRowTypeName.equals("")) {
                try {
                    lRowClassType = this.findClass(lRowTypeName);
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                    String message = "Class " + lRowTypeName + " could not be found, either it has the wrong name or cannot be found in lookup table";
                    SAXException classError = new SAXException(message);
                    throw classError;
                }
            } else {
                lRowClassType = Object.class;
            }
            if (lArrayType.equals("PRIMITIVE")) {
                lArray = Array.newInstance(lRowClassType, lArraySize);
            }
            this.pushRowType(lRowClassType);
            this.pushObject(lArray);
            this.State = 6;
        } else if (name.equals("NULLVALUE")) {
            Object lCurrentObj = null;
            Field lField = null;
            try {
                lCurrentObj = this.topObject();
                lField = this.findField(lCurrentObj, this.topAttrName());
                if (lField == null) {
                    this.pushObject(new Object());
                } else {
                    this.pushObject(lField.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                this.State = 4;
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                e1.printStackTrace();
                String message = "Could not init instance of " + lField.getType().getName();
                SAXException initError = new SAXException(message);
                throw initError;
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
                String message = "Illegal access of field " + this.topAttrName();
                SAXException illegalError = new SAXException(message);
                throw illegalError;
            }
        }
    }

    public void pushRowType(Class type) {
        this.RowTypeStack.push(type);
    }

    public Class popRowType() {
        return (Class)this.RowTypeStack.pop();
    }

    public void setCurrentAttribute(Object value) throws SAXException {
        Object lCurrentObj = this.topObject();
        String lCurrentField = this.topAttrName();
        if (lCurrentObj instanceof WrapperClassHelper) {
            WrapperClassHelper helper = (WrapperClassHelper)lCurrentObj;
            lCurrentObj = helper.valueOf((String)value);
            this.popObject();
            this.pushObject(lCurrentObj);
            String id = helper.getId();
            if (id != null) {
                this.ObjectHash.put(id, lCurrentObj);
            }
            return;
        }
        Field lField = null;
        try {
            lField = this.findField(lCurrentObj, lCurrentField);
            if (lField == null) {
                return;
            }
            Class<?> lFieldClass = lField.getType();
            if (lFieldClass.isPrimitive() && value instanceof String) {
                if (lFieldClass == Integer.TYPE) {
                    lField.setInt(lCurrentObj, Integer.parseInt((String)value));
                } else if (lFieldClass == Short.TYPE) {
                    lField.setShort(lCurrentObj, Short.parseShort((String)value));
                } else if (lFieldClass == Long.TYPE) {
                    lField.setLong(lCurrentObj, Long.parseLong((String)value));
                } else if (lFieldClass == Byte.TYPE) {
                    lField.setByte(lCurrentObj, Byte.parseByte((String)value));
                } else if (lFieldClass == Double.TYPE) {
                    lField.setDouble(lCurrentObj, Double.parseDouble((String)value));
                } else if (lFieldClass == Float.TYPE) {
                    lField.setFloat(lCurrentObj, Float.parseFloat((String)value));
                } else if (lFieldClass == Boolean.TYPE) {
                    lField.setBoolean(lCurrentObj, Boolean.valueOf((String)value));
                } else if (lFieldClass == Character.TYPE) {
                    lField.setChar(lCurrentObj, ((String)value).charAt(0));
                }
            } else if (lFieldClass.isArray() && value instanceof ArrayList) {
                Class<?> lArrayType = lFieldClass.getComponentType();
                ArrayList lList = (ArrayList)value;
                Object lArray = Array.newInstance(lArrayType, lList.size());
                for (int i = 0; i < lList.size(); ++i) {
                    Array.set(lArray, i, lList.get(i));
                }
                lField.set(lCurrentObj, lArray);
            } else {
                lField.set(lCurrentObj, value);
            }
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            String message = "Illegal access of field " + lCurrentField;
            SAXException accessError = new SAXException(message);
            throw accessError;
        }
        catch (SecurityException e3) {
            e3.printStackTrace();
            String message = "Security Exception accessing fields of" + lCurrentObj.getClass().getName();
            SAXException accessError = new SAXException(message);
            throw accessError;
        }
        catch (RuntimeException e4) {
            e4.printStackTrace();
            throw e4;
        }
    }

    public Class topRowType() {
        return (Class)this.RowTypeStack.peek();
    }

    private boolean checkSimpleRow(String name, AttributeList atts) throws SAXException {
        boolean isSimple = false;
        String lRowType = atts.getValue("ROWCLASS");
        String lRowValue = atts.getValue("VALUE");
        if (lRowType != null && !lRowType.equals("")) {
            isSimple = true;
            if (lRowType.equals("java.lang.String")) {
                this.pushObject(lRowValue);
            } else if (lRowType.equals("java.lang.StringBuffer")) {
                this.pushObject(new StringBuffer(lRowValue));
            } else if (lRowType.equals("int") || lRowType.equals("java.lang.Integer")) {
                this.pushObject(Integer.valueOf(lRowValue));
            } else if (lRowType.equals("short") || lRowType.equals("java.lang.Short")) {
                this.pushObject(Short.valueOf(lRowValue));
            } else if (lRowType.equals("long") || lRowType.equals("java.lang.Long")) {
                this.pushObject(Long.valueOf(lRowValue));
            } else if (lRowType.equals("float") || lRowType.equals("java.lang.Float")) {
                this.pushObject(Float.valueOf(lRowValue));
            } else if (lRowType.equals("double") || lRowType.equals("java.lang.Double")) {
                this.pushObject(Double.valueOf(lRowValue));
            } else if (lRowType.equals("boolean") || lRowType.equals("java.lang.Boolean")) {
                this.pushObject(Boolean.valueOf(lRowValue));
            } else if (lRowType.equals("char") || lRowType.equals("java.lang.Character")) {
                this.pushObject(Character.valueOf(lRowValue.charAt(0)));
            } else {
                System.out.println("Found and unknown type in a row");
                this.pushObject(null);
            }
        }
        return isSimple;
    }

    @Override
    public void DumpStatus() {
        super.DumpStatus();
        System.out.println("Dump Status from class XMLGraphSerializer");
        System.out.println("Row Type stack " + this.RowTypeStack);
        System.out.println("Row Counter stack " + this.RowCountStack);
        System.out.println("Object hash table " + this.ObjectHash);
        System.out.println("Dump Status from class XMLGraphSerializer - END");
    }

    private void pushRowCount() {
        this.RowCountStack.push(0);
    }

    private void popRowCount() {
        this.RowCountStack.pop();
    }

    private int currentRowCount() {
        Integer lInt = (Integer)this.RowCountStack.peek();
        return lInt;
    }

    private void incrementRowCount() {
        Integer lRowCount;
        Integer n = lRowCount = (Integer)this.RowCountStack.pop();
        lRowCount = lRowCount + 1;
        this.RowCountStack.push(lRowCount);
    }

    private static class WrapperClassHelper {
        private static final Map converters = new HashMap(8);
        private Class wrapperClass;
        private String id;

        public WrapperClassHelper(Class wrapperClass, String id) {
            this.wrapperClass = wrapperClass;
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Object valueOf(String s) {
            Converter conv = (Converter)converters.get(this.wrapperClass);
            return conv != null ? conv.valueOf(s) : null;
        }

        public static boolean isWrapperClass(Class clazz) {
            return converters.containsKey(clazz);
        }

        static {
            converters.put(Boolean.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Boolean.valueOf(s);
                }
            });
            converters.put(Byte.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Byte.valueOf(s);
                }
            });
            converters.put(Short.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Short.valueOf(s);
                }
            });
            converters.put(Character.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Character.valueOf(s.charAt(0));
                }
            });
            converters.put(Integer.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Integer.valueOf(s);
                }
            });
            converters.put(Long.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Long.valueOf(s);
                }
            });
            converters.put(Float.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Float.valueOf(s);
                }
            });
            converters.put(Double.class, new Converter(){

                @Override
                public Object valueOf(String s) {
                    return Double.valueOf(s);
                }
            });
        }

        private static interface Converter {
            public Object valueOf(String var1);
        }
    }
}

