/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.AnchorShapeFactory;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.AddTableDlg;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.CondNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.JoinNode;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QBGraphScene;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QBNodeComponent;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTable;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInternalFrame;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.And;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ExpressionList;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Or;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class QueryBuilderGraphFrame
extends JPanel
implements ActionListener,
TableModelListener,
ItemListener,
KeyListener,
DropTargetListener,
PopupMenuProvider {
    private static final boolean DEBUG = false;
    private boolean _disableQBGF = false;
    private QueryBuilder _queryBuilder;
    private DropTarget _dropTarget;
    private JDesktopPane _desktopPane = null;
    private QBGFJPanel _canvas = null;
    private QueryBuilderInputTable _queryBuilderInputTable;
    private DefaultTableModel _inputTableModel;
    private JEditorPane _sqlTextArea;
    private DefaultTableModel _resultTableModel;
    private QBGraphScene _scene;
    private JScrollPane _desktopScrollPane;
    private JViewport viewport;
    private FrameSelectionListener _fsl = null;
    private ComponentListener _cl = null;
    private JPopupMenu _backgroundPopup;
    private JPopupMenu _tableTitlePopup;
    private AddTableDlg _addTableDlg = null;
    boolean _firstTableInserted = false;
    private QBNodeComponent _selectedNode;
    private static final int initX = 40;
    private static final int initY = 40;
    private static final int offsetX = 20;
    private int offsetY = 20;
    private static final int MAX_TABLES_IN_A_ROW = 5;
    private Random randomVal = new Random();
    private JMenuItem runQueryMenuItem;
    private JMenuItem groupByMenuItem;
    private boolean _checkTableColumnValidity = false;
    private boolean _inputTableAddCriteria = false;
    Point _gLocation;

    public QueryBuilderGraphFrame(QueryBuilder queryBuilder, QueryBuilderInputTable queryBuilderInputTable, JEditorPane sqlTextArea, DefaultTableModel resultTableModel) {
        super(new BorderLayout());
        Log.getLogger().entering("QueryBuilderGraphFrame", "constructor");
        this._queryBuilder = queryBuilder;
        this._queryBuilderInputTable = queryBuilderInputTable;
        this._inputTableModel = (DefaultTableModel)this._queryBuilderInputTable.getModel();
        this._sqlTextArea = sqlTextArea;
        this._resultTableModel = resultTableModel;
        this._inputTableModel.addTableModelListener(this);
        this._fsl = new FrameSelectionListener();
        this._cl = new CompListener();
        this._backgroundPopup = this.createBackgroundPopup();
        this._tableTitlePopup = this.createTableTitlePopup();
        this.setVisible(true);
    }

    void initScene(QBGraphScene scene, JComponent sceneView) {
        this._scene = scene;
        this._dropTarget = new DropTarget(sceneView, 3, this);
    }

    void setDropTarget(Component comp) {
        this._dropTarget = new DropTarget(comp, 3, this);
    }

    void setScene(QBGraphScene qbgScene) {
        this._scene = qbgScene;
    }

    void getCanvasFocus() {
        this._canvas.requestFocus(true);
    }

    void setQBGFEnabled(boolean value) {
        boolean bl = this._disableQBGF = !value;
        if (this._disableQBGF) {
            int frameWidth = (int)this.getSize().getWidth();
            int n = (int)this.getSize().getHeight();
        }
    }

    void resizeDesktop() {
    }

    void setActivatedNode(QueryBuilderInternalFrame currentSelectedFrame) {
        if (currentSelectedFrame != null) {
            TableNode tn = currentSelectedFrame.getNode();
            this._queryBuilder.setActivatedNodes(new Node[]{tn});
        } else {
            this._queryBuilder.setActivatedNodes(new Node[0]);
        }
        this._queryBuilder.activateActions();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this._checkTableColumnValidity = true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this._checkTableColumnValidity = true;
        if (e.isShiftDown()) {
            int code = e.getKeyCode();
            switch (code) {
                case 121: {
                    this._backgroundPopup.show(e.getComponent(), e.getComponent().getX(), e.getComponent().getY());
                }
            }
        }
        this._queryBuilder.handleKeyPress(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this._checkTableColumnValidity = true;
    }

    public void setTableColumnValidity(boolean value) {
        this._checkTableColumnValidity = value;
    }

    public boolean checkTableColumnValidity() {
        return this._checkTableColumnValidity && this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().queryChanged();
    }

    JPopupMenu createBackgroundPopup() {
        JPopupMenu backgroundPopup = new JPopupMenu();
        this.runQueryMenuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"RUN_QUERY"));
        this.runQueryMenuItem.addActionListener(this);
        backgroundPopup.add(this.runQueryMenuItem);
        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"Add_Table"));
        menuItem.addActionListener(this);
        backgroundPopup.add(menuItem);
        this.groupByMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"GROUP_BY"));
        this.groupByMenuItem.addItemListener(this);
        backgroundPopup.add(this.groupByMenuItem);
        return backgroundPopup;
    }

    JPopupMenu createTableTitlePopup() {
        JPopupMenu tableTitlePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"REMOVE_FROM_QUERY"));
        menuItem.addActionListener(this);
        tableTitlePopup.add(menuItem);
        return tableTitlePopup;
    }

    public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
        QBNodeComponent qbNC;
        if (widget instanceof QBGraphScene) {
            return this._backgroundPopup;
        }
        this._selectedNode = qbNC = (QBNodeComponent)this._scene.findObject(widget);
        return this._tableTitlePopup;
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this._disableQBGF) {
            return;
        }
        if (!this._queryBuilder._updateModel) {
            return;
        }
        Log.getLogger().finest("Entering QBGF.tableChanged, source: " + e.getSource());
        if (e.getSource() instanceof QueryBuilderTableModel) {
            this.tableModelChanged(e);
        } else if (e.getSource() instanceof QueryBuilderInputTableModel) {
            this.inputTableModelChanged(e);
        }
    }

    private void tableModelChanged(TableModelEvent e) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "tableModelChanged");
        int row = e.getFirstRow();
        int column = e.getColumn();
        QueryBuilderTableModel model = (QueryBuilderTableModel)e.getSource();
        String tableSpec = model.getTableSpec();
        String columnName = (String)model.getValueAt(row, column + 2);
        Object value = model.getValueAt(row, column);
        if (value == Boolean.TRUE) {
            if (this._queryBuilder._updateModel) {
                this._queryBuilder.getQueryModel().addColumn(tableSpec, columnName);
                this._queryBuilderInputTable.selectColumn(tableSpec, columnName, Boolean.TRUE);
            }
        } else if (value == Boolean.FALSE) {
            if (this._queryBuilder._updateModel) {
                this._queryBuilder.getQueryModel().removeColumn(tableSpec, columnName);
            }
            this._queryBuilderInputTable.selectColumn(tableSpec, columnName, Boolean.FALSE);
        }
        if (this._queryBuilder._updateText) {
            this._queryBuilder.generateText();
        }
    }

    private void inputTableModelChanged(TableModelEvent e) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "inputTableModelChanged");
        if (this._inputTableAddCriteria) {
            return;
        }
        int column = e.getColumn();
        int row = e.getFirstRow();
        QueryBuilderInputTableModel model = (QueryBuilderInputTableModel)e.getSource();
        if (column != -1) {
            String result;
            String columnName = (String)model.getValueAt(row, 0);
            String tableSpec = (String)model.getValueAt(row, 2);
            if (column == 1) {
                result = ((String)model.getValueAt(row, 1)).trim();
                if (result == null || result.length() == 0) {
                    this._queryBuilder.getQueryModel().removeDerivedColName(tableSpec, columnName);
                } else {
                    this._queryBuilder.getQueryModel().setDerivedColName(tableSpec, columnName, result);
                }
            }
            if (column == 3) {
                Boolean value = (Boolean)model.getValueAt(row, column);
                QBNodeComponent node = this.findGraphNode(tableSpec);
                QueryBuilderTableModel qbtm = node.getQueryBuilderTableModel();
                qbtm.selectColumn(columnName, value);
                return;
            }
            if (column == 6) {
                result = ((String)model.getValueAt(row, 6)).trim();
                if (result != null && result.length() == 0) {
                    this._inputTableAddCriteria = true;
                    model.setValueAt("", row, 7);
                    this._inputTableAddCriteria = false;
                    this._queryBuilder.getQueryModel().removeCriteria(tableSpec, columnName, 1);
                } else {
                    if (result.trim().equals("*****")) {
                        return;
                    }
                    Predicate pred = this.checkCriteria(tableSpec, columnName, result);
                    if (pred == null) {
                        this._queryBuilderInputTable.getModel().setValueAt("", row, column);
                        return;
                    }
                    int criteriaCount = this._queryBuilder.getQueryModel().getCriteriaCount();
                    String order = (String)model.getValueAt(row, 7);
                    if (order != null && order.trim().length() != 0 && order.trim().equals("*")) {
                        return;
                    }
                    int orderNum = order == null || order.trim().length() == 0 ? criteriaCount + 1 : Integer.parseInt(order);
                    this._inputTableAddCriteria = true;
                    model.setValueAt(Integer.valueOf(orderNum).toString(), row, 7);
                    this._inputTableAddCriteria = false;
                    if (orderNum < criteriaCount + 1) {
                        this._queryBuilder.getQueryModel().replaceCriteria(tableSpec, columnName, pred, orderNum);
                    } else {
                        this._queryBuilder.getQueryModel().addCriteria(tableSpec, columnName, pred);
                    }
                }
                this._queryBuilderInputTable.clearSelection();
                this._inputTableAddCriteria = true;
                this._queryBuilderInputTable.generateTableWhere(this._queryBuilder.getQueryModel());
                this._inputTableAddCriteria = false;
            } else if (column == 7) {
                String criteria = ((String)model.getValueAt(row, 6)).trim();
                String order = (String)model.getValueAt(row, column);
                if (order != null && order.trim().length() != 0 && order.trim().equals("*")) {
                    return;
                }
                this._queryBuilder.getQueryModel().removeCriteria(tableSpec, columnName, 1);
                if (order == null || order.trim().length() == 0) {
                    this._inputTableAddCriteria = true;
                    model.setValueAt("", row, 6);
                    this._inputTableAddCriteria = false;
                } else {
                    int orderNum = Integer.parseInt(order);
                    Predicate pred = this.checkCriteria(tableSpec, columnName, criteria);
                    if (pred == null) {
                        this._queryBuilderInputTable.getModel().setValueAt("", row, column);
                        return;
                    }
                    if (criteria.trim().length() != 0) {
                        this._queryBuilder.getQueryModel().addCriteria(tableSpec, columnName, pred, orderNum);
                    }
                }
                this._queryBuilderInputTable.clearSelection();
                this._inputTableAddCriteria = true;
                this._queryBuilderInputTable.generateTableWhere(this._queryBuilder.getQueryModel());
                this._inputTableAddCriteria = false;
            }
            if (this._queryBuilder._updateText) {
                this._queryBuilder.generateText();
            }
        }
    }

    private Predicate checkCriteria(String tableSpec, String columnName, String result) {
        String op = null;
        String val = null;
        if (result.startsWith(">=")) {
            op = ">=";
            val = result.substring(2).trim();
        } else if (result.startsWith("<=")) {
            op = "<=";
            val = result.substring(2).trim();
        } else if (result.startsWith("<>")) {
            op = "<>";
            val = result.substring(2).trim();
        } else if (result.startsWith(">")) {
            op = ">";
            val = result.substring(1).trim();
        } else if (result.startsWith("<")) {
            op = "<";
            val = result.substring(1).trim();
        } else if (result.startsWith("=")) {
            op = "=";
            val = result.substring(1).trim();
        } else if (result.toUpperCase().startsWith("LIKE")) {
            op = " LIKE ";
            val = result.substring(5).trim();
        } else if (result.toUpperCase().startsWith("IN")) {
            op = " IN ";
            val = result.substring(3).trim();
        }
        if (op == null || op.trim().length() == 0 || val == null || val.trim().length() == 0) {
            String msg = NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"CRITERIA_ERROR");
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            this._queryBuilderInputTable.clearSelection();
            return null;
        }
        Column col1 = SQLQueryFactory.createColumn(tableSpec, columnName);
        Predicate pred = SQLQueryFactory.createPredicate((Value)col1, val, op);
        return pred;
    }

    public void setCurrentSelectedFrameTitle(String title) {
        if ((QueryBuilderInternalFrame)this._desktopPane.getSelectedFrame() != null) {
            ((QueryBuilderInternalFrame)this._desktopPane.getSelectedFrame()).setTitle(title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTableInteractively(String fullTableName) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertTableInteractively", fullTableName);
        if (this._queryBuilder.getQueryModel() == null || this._queryBuilder.getQueryModel().genText() == null) {
            String query = "select * from " + fullTableName;
            this._queryBuilder.populate(query, false);
            this._queryBuilder.setSqlCommand(query);
            return;
        }
        QueryBuilder.showBusyCursor(true);
        this._queryBuilder._updateText = false;
        try {
            String tabName;
            String schemaName = null;
            String[] res = fullTableName.split("\\.");
            if (res.length > 1) {
                schemaName = res[0];
                tabName = res[1];
            } else {
                tabName = fullTableName;
            }
            String tableName = new String(tabName);
            String corrName = this._queryBuilder.getQueryModel().genUniqueName(fullTableName);
            Table tbl = corrName == null ? SQLQueryFactory.createTable(tableName, null, schemaName) : SQLQueryFactory.createTable(tableName, corrName, schemaName);
            JoinTable joinTable = SQLQueryFactory.createJoinTable(tbl);
            ArrayList<String> columnNames = new ArrayList<String>();
            columnNames.add("*");
            this._queryBuilder.getQueryModel().insertTable(joinTable);
            QBNodeComponent qbNC = this.insertTable(joinTable, columnNames);
            List edges = this.insertFKEdges(qbNC, fullTableName);
            this._queryBuilder.getQueryModel().addRelationships(joinTable, edges);
            this._firstTableInserted = true;
        }
        finally {
            this._queryBuilder._updateText = true;
            QueryBuilder.showBusyCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertTableFromModel(JoinTable joinTable, List columnNames) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertTableFromModel", joinTable.getTableSpec());
        boolean updateText = this._queryBuilder._updateText;
        this._queryBuilder._updateText = false;
        try {
            QBNodeComponent qbNC = this.insertTable(joinTable, columnNames);
            if (qbNC == null) {
                return;
            }
            this.insertJoinEdges(joinTable);
            this._firstTableInserted = true;
        }
        finally {
            this._queryBuilder._updateText = updateText;
        }
    }

    QBNodeComponent insertTable(JoinTable joinTable, List columnNames) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertTable", new Object[]{joinTable, columnNames});
        String joinTableName = joinTable.getFullTableName();
        QBNodeComponent qbNC = this.createNode(joinTable, columnNames);
        this.refresh();
        return qbNC;
    }

    QBNodeComponent createNode(JoinTable joinTable, List selectColumnNames) {
        int i;
        List<String> dbColumnNames;
        String fullTableName = joinTable.getFullTableName();
        String[] table = fullTableName.split("\\.");
        String tableName = table.length > 1 ? table[1] : table[0];
        String corrName = joinTable.getCorrName();
        String tableSpec = corrName != null ? corrName : fullTableName;
        Log.getLogger().finest("Entering QBGF.createNode, fullTableName: " + fullTableName + " corrName: " + corrName);
        try {
            String newS = this._queryBuilder.checkFullTableName(fullTableName);
            if (newS != null & !fullTableName.equals(newS)) {
                fullTableName = newS;
                Log.getLogger().finest("  fullTableName corrected to " + fullTableName);
            }
        }
        catch (SQLException se) {
            Log.getLogger().finest("  fullTableName " + se.getMessage());
        }
        String[] columnNames = new String[]{"", "", ""};
        try {
            dbColumnNames = this._queryBuilder.getColumnNames(fullTableName);
        }
        catch (SQLException sqle) {
            dbColumnNames = new ArrayList<String>();
        }
        Object[][] dbData = new Object[dbColumnNames.size()][3];
        Iterator<String> iterator = dbColumnNames.iterator();
        ArrayList primaryKeys = null;
        ArrayList foreignKeyCols = null;
        try {
            primaryKeys = this._queryBuilder.getPrimaryKeys(fullTableName);
            foreignKeyCols = this._queryBuilder.getImportedKeyColumns(fullTableName);
        }
        catch (SQLException sqle) {
            Log.getLogger().warning("QueryBuilderGraphFrame:  cannot get info " + sqle.getLocalizedMessage());
            primaryKeys = new ArrayList();
            foreignKeyCols = new ArrayList();
        }
        for (i = 0; iterator.hasNext() && i < dbColumnNames.size(); ++i) {
            String columnName = new String(iterator.next().toString());
            dbData[i][0] = selectColumnNames.contains("*") || selectColumnNames.contains(columnName) ? Boolean.TRUE : Boolean.FALSE;
            dbData[i][1] = primaryKeys.contains(columnName.trim()) ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/visualeditor/resources/primaryKey.gif", (boolean)false) : (foreignKeyCols.contains(columnName.trim()) ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/db/sql/visualeditor/resources/foreignKey.gif", (boolean)false) : null);
            dbData[i][2] = columnName;
            this._queryBuilderInputTable.addRow(tableSpec, columnName);
            this._queryBuilderInputTable.selectColumn(tableSpec, columnName, (Boolean)dbData[i][0]);
        }
        QueryBuilderTableModel qbtModel = new QueryBuilderTableModel(fullTableName, corrName, columnNames, dbData);
        qbtModel.addTableModelListener(this);
        for (i = 0; i < qbtModel.getRowCount(); ++i) {
            qbtModel.setValueAt(dbData[i][0], i, 0);
        }
        String title = corrName == null ? tableName : corrName + ": " + tableName;
        Widget widget = this._scene.addNode(title, qbtModel);
        widget.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        QBNodeComponent qbNC = this.findComponent(widget);
        widget.setPreferredLocation(this.getNextGraphLocation(qbNC.getPreferredSize()));
        this._scene.validate();
        return qbNC;
    }

    Point getNextGraphLocation(Dimension size) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "getNextGraphLocation", new Object[]{size.getWidth(), size.getHeight()});
        if (!this._firstTableInserted) {
            this._gLocation = new Point(40, 40);
        } else {
            this._gLocation = new Point((int)(this._gLocation.getX() + size.getWidth() + 20.0 + (double)this.randomVal.nextInt((int)size.getWidth() / 2)), (int)(this._gLocation.getY() + (double)this.offsetY + (double)this.randomVal.nextInt((int)size.getHeight() / 2)));
            this.offsetY *= -1;
            if (this._gLocation.getX() > (double)((int)size.getWidth() * 5)) {
                this._gLocation = new Point(40, (int)this._gLocation.getY() + (int)size.getHeight() + 2 * this.offsetY);
            }
        }
        return this._gLocation;
    }

    QBNodeComponent findComponent(Widget widget) {
        List widgets = widget.getChildren();
        for (Widget w : widgets) {
            if (!(w instanceof ComponentWidget)) continue;
            return (QBNodeComponent)((ComponentWidget)w).getComponent();
        }
        return null;
    }

    private List insertFKEdges(QBNodeComponent newNode, String newFullTableName) {
        ArrayList foreignKeys;
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertFKEdges", new Object[]{newNode, newFullTableName});
        try {
            foreignKeys = this._queryBuilder.getForeignKeys(newFullTableName);
        }
        catch (SQLException sqle) {
            foreignKeys = new ArrayList();
        }
        ArrayList<String[]> foreignKeysUsed = new ArrayList<String[]>();
        Collection nodes = this._scene.getNodes();
        for (Object oldNode : nodes) {
            String oldFullTableName;
            String[] fk;
            if (!(oldNode instanceof QBNodeComponent) || (fk = this._queryBuilder.findForeignKey(oldFullTableName = ((QBNodeComponent)oldNode).getFullTableName(), newFullTableName, foreignKeys)) == null) continue;
            String oldTableSpec = ((QBNodeComponent)oldNode).getTableSpec();
            String newTableSpec = newNode.getTableSpec();
            if (fk[0].equals(fk[2])) {
                fk[0] = oldTableSpec;
                fk[2] = newTableSpec;
            }
            this.insertGraphEdge((QBNodeComponent)oldNode, newNode, oldFullTableName, newFullTableName, oldTableSpec, newTableSpec, null, null, fk, "INNER");
            foreignKeysUsed.add(fk);
        }
        return foreignKeysUsed;
    }

    void insertJoinEdges(JoinTable joinTable) {
        Expression cond;
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertJoinEdges", joinTable);
        String joinType = joinTable.getJoinType();
        if (joinType != null && !joinType.equals("CROSS") && (cond = joinTable.getExpression()) instanceof Predicate) {
            Predicate pred = (Predicate)cond;
            this.insertJoinEdge(pred, joinType);
        }
    }

    void insertJoinEdge(Predicate pred, String joinType) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "insertJoinEdge", new Object[]{pred, joinType});
        Value val1 = pred.getVal1();
        Value val2 = pred.getVal2();
        if (val1 instanceof Column && val2 instanceof Column) {
            Column col1 = (Column)val1;
            String tableSpec1 = col1.getTableSpec();
            String fullTableName1 = this._queryBuilder.getQueryModel().getFullTableName(tableSpec1);
            String colName1 = col1.getColumnName();
            QBNodeComponent node1 = this.findGraphNode(tableSpec1);
            Column col2 = (Column)val2;
            String tableSpec2 = col2.getTableSpec();
            String fullTableName2 = this._queryBuilder.getQueryModel().getFullTableName(tableSpec2);
            String colName2 = col2.getColumnName();
            QBNodeComponent node2 = this.findGraphNode(tableSpec2);
            String[] fk = null;
            try {
                fk = this._queryBuilder.findForeignKey(fullTableName1, colName1, fullTableName2, colName2);
            }
            catch (SQLException sqle) {
                Log.getLogger().warning("QBGF:  findforeignKey " + sqle.getLocalizedMessage());
            }
            this.insertGraphEdge(node1, node2, fullTableName1, fullTableName2, tableSpec1, tableSpec2, colName1, colName2, fk, joinType);
        }
    }

    void insertGraphEdge(QBNodeComponent node1, QBNodeComponent node2, String fullTableName1, String fullTableName2, String tableSpec1, String tableSpec2, String colName1, String colName2, String[] fk, String joinType) {
        System.out.println("Entering insertGraphEdge, tableSpec1: " + tableSpec1 + "  tableSpec2: " + tableSpec2);
        AbstractNode an = colName1 == null ? (fullTableName1.equalsIgnoreCase(fk[0]) ? this.createPropertyNode(tableSpec1, fk[1], tableSpec2, fk[3], joinType, this._queryBuilder) : this.createPropertyNode(tableSpec2, fk[1], tableSpec1, fk[3], joinType, this._queryBuilder)) : this.createPropertyNode(tableSpec1, colName1, tableSpec2, colName2, joinType, this._queryBuilder);
        Widget widget = this._scene.addEdge(an);
        this._scene.setEdgeSource(an, node1);
        this._scene.setEdgeTarget(an, node2);
        ConnectionWidget connWidget = (ConnectionWidget)widget;
        connWidget.getActions().addAction(this._scene.createSelectAction());
        AnchorShape triangle = AnchorShapeFactory.createTriangleAnchorShape((int)18, (boolean)true, (boolean)false, (int)17);
        connWidget.setStroke((Stroke)new BasicStroke(1.5f, 2, 1));
        if (fk != null) {
            if (fk[0].equalsIgnoreCase(fullTableName1)) {
                connWidget.setTargetAnchorShape(triangle);
            } else {
                connWidget.setSourceAnchorShape(triangle);
            }
        }
        this._queryBuilder.setActivatedNodes(new Node[]{an});
        this._scene.validate();
    }

    AbstractNode createPropertyNode(String tableSpec1, String fk1, String tableSpec2, String fk3, String joinType, QueryBuilder _queryBuilder) {
        if (joinType == null || joinType.equals("")) {
            return new CondNode(tableSpec1, fk1, tableSpec2, fk3, _queryBuilder);
        }
        return new JoinNode(tableSpec1, fk1, tableSpec2, fk3, joinType, _queryBuilder);
    }

    void removeTable(QBNodeComponent selectedNode) {
        String tableSpec = selectedNode.getTableSpec();
        Log.getLogger().entering("QueryBuilderGraphFrame", "removeTable", tableSpec);
        Collection edges = this._scene.findNodeEdges(selectedNode, true, true);
        for (Object edge : edges) {
            this._scene.removeEdge(edge);
        }
        this._scene.removeNode(selectedNode);
        this._queryBuilderInputTable.removeRows(tableSpec);
        this._queryBuilder.getQueryModel().removeTable(tableSpec);
        this._queryBuilder.generate();
        this.setGroupBy(this._queryBuilder.getQueryModel().hasGroupBy());
    }

    void generateGraph(QueryModel query) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "generateGraph");
        if (this._disableQBGF) {
            return;
        }
        this._queryBuilder._updateModel = false;
        try {
            this.generateGraphFrom(query);
            this.generateGraphWhere(query);
            this.generateGraphOrderBy(query);
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._queryBuilder._updateModel = true;
        }
    }

    private void generateGraphFrom(QueryModel query) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "generateGraphFrom");
        List tables = query.getFrom().getTableList();
        for (int i = 0; i < tables.size(); ++i) {
            JoinTable joinTable = (JoinTable)tables.get(i);
            String tableSpec = joinTable.getTableSpec();
            String fullTableName = joinTable.getFullTableName();
            ArrayList columnNames = new ArrayList();
            query.getColumnNames(tableSpec, columnNames);
            this.insertTableFromModel(joinTable, columnNames);
        }
    }

    private boolean whereHasDuplicateColumns(List whereColumns, Predicate expr) {
        ArrayList columns = new ArrayList();
        expr.getReferencedColumns(columns);
        for (int i = 0; i < columns.size(); ++i) {
            Column c = (Column)columns.get(i);
            int found = 0;
            for (int j = 0; j < whereColumns.size(); ++j) {
                if (((Column)whereColumns.get(j)).equals(c)) {
                    ++found;
                }
                if (found <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private void generateGraphWhere(QueryModel query) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "generateGraphWhere");
        this._inputTableAddCriteria = true;
        Where where = query.getWhere();
        if (where != null) {
            Expression expr = where.getExpression();
            ArrayList whereColumns = new ArrayList();
            where.getReferencedColumns(whereColumns);
            if (expr == null) {
                this._inputTableAddCriteria = false;
                return;
            }
            if (expr instanceof Predicate) {
                if (this.whereHasDuplicateColumns(whereColumns, (Predicate)expr)) {
                    this.insertPredicate((Predicate)expr, -1);
                } else {
                    this.insertPredicate((Predicate)expr, 0);
                }
            } else if (expr instanceof And) {
                this.insertAndOr(expr, whereColumns, 0);
            } else if (expr instanceof Or) {
                this.insertAndOr(expr, whereColumns, 0);
            }
        }
        this._inputTableAddCriteria = false;
    }

    private void insertAndOr(Expression expr, List whereColumns, int order) {
        ExpressionList exprList = (ExpressionList)expr;
        for (int i = 0; i < exprList.size(); ++i) {
            expr = exprList.getExpression(i);
            if (expr instanceof Predicate) {
                if (this.whereHasDuplicateColumns(whereColumns, (Predicate)expr)) {
                    this.insertPredicate((Predicate)expr, -1);
                    continue;
                }
                this.insertPredicate((Predicate)expr, order++);
                continue;
            }
            if (expr instanceof And) {
                this.insertAndOr(expr, whereColumns, order++);
                continue;
            }
            if (!(expr instanceof Or)) continue;
            this.insertAndOr(expr, whereColumns, order++);
        }
    }

    private void insertPredicate(Predicate pred, int order) {
        Value val1 = pred.getVal1();
        Value val2 = pred.getVal2();
        if (val1 instanceof Column && val2 instanceof Column) {
            this.insertJoinEdge(pred, "");
        } else {
            String marker = pred.getVal2().toString();
            Column col = (Column)val1;
            String tableSpec = col.getTableSpec();
            String columnName = col.getColumnName();
            String val = pred.getOp() + " " + marker;
            if (order == -1) {
                this._queryBuilderInputTable.addCriterion(tableSpec, columnName, "*****", "*");
            } else {
                String orderString = order == -1 ? "" : Integer.valueOf(order + 1).toString();
                this._queryBuilderInputTable.addCriterion(tableSpec, columnName, val, orderString);
            }
        }
    }

    private void generateGraphOrderBy(QueryModel query) {
        this._queryBuilderInputTable.generateTableOrderBy(query);
    }

    QBNodeComponent findGraphNode(String tableSpec) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "findGraphNode", tableSpec);
        Collection nodes = this._scene.getNodes();
        for (Object node : nodes) {
            if (!(node instanceof QBNodeComponent) || !((QBNodeComponent)node).getTableSpec().equals(tableSpec)) continue;
            return (QBNodeComponent)node;
        }
        return null;
    }

    public void addTable() {
        Log.getLogger().entering("QueryBuilderGraphFrame", "addTable");
        QueryBuilder.showBusyCursor(true);
        try {
            List<String> tableNames = this._queryBuilder.getAllTables();
            String[] tableStrings = new String[tableNames.size()];
            tableNames.toArray(tableStrings);
            this._addTableDlg = new AddTableDlg(tableStrings, true);
            if (this._addTableDlg.getReturnStatus() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object[] selectedTables = QueryBuilderGraphFrame.this._addTableDlg.getSelectedValues();
                        for (int i = 0; i < selectedTables.length; ++i) {
                            String finalVal = (String)selectedTables[i];
                            QueryBuilderGraphFrame.this.insertTableInteractively(finalVal);
                        }
                        QueryBuilderGraphFrame.this._queryBuilder.generateText();
                        QueryBuilderGraphFrame.this.runQueryMenuItem.setEnabled(true);
                        QueryBuilderGraphFrame.this.groupByMenuItem.setEnabled(true);
                        QueryBuilderGraphFrame.this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(true);
                        QueryBuilderGraphFrame.this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(true);
                    }
                });
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            QueryBuilder.showBusyCursor(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Log.getLogger().entering("QueryBuilderGraphFrame", "actionPerformed");
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"Add_Table"))) {
            this.addTable();
        } else if (source.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"RUN_QUERY"))) {
            this._queryBuilder.executeQuery(this._sqlTextArea.getText());
        } else if (source.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"REMOVE_FROM_QUERY"))) {
            this.removeTable();
        }
    }

    public void removeNode(TableNode node) {
    }

    public void removeNode(CondNode node) {
    }

    public void removeNode(JoinNode node) {
    }

    public void removeTable() {
        Log.getLogger().entering("QueryBuilderGraphFrame", "removeTable");
        QueryBuilder.showBusyCursor(true);
        this._queryBuilder._updateText = false;
        try {
            this.removeTable(this._selectedNode);
        }
        finally {
            this._queryBuilder._updateText = true;
        }
        if (this._sqlTextArea.getText() == null) {
            this.runQueryMenuItem.setEnabled(false);
            this.groupByMenuItem.setEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(false);
        } else if (this._sqlTextArea.getText().trim().length() == 0) {
            this.runQueryMenuItem.setEnabled(false);
            this.groupByMenuItem.setEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(false);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(false);
        } else {
            this.runQueryMenuItem.setEnabled(true);
            this.groupByMenuItem.setEnabled(true);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(true);
            this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(true);
        }
        QueryBuilder.showBusyCursor(false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals(NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"GROUP_BY"))) {
            if (e.getStateChange() == 1) {
                this._queryBuilder.getQueryModel().addGroupBy();
            } else {
                this._queryBuilder.getQueryModel().removeGroupBy();
            }
            this._queryBuilder.generateText();
        }
    }

    public void setGroupBy(boolean b) {
        this.groupByMenuItem.setSelected(b);
    }

    void redrawFrameWithMove(QueryBuilderInternalFrame frame) {
    }

    private void redrawFrame(QueryBuilderInternalFrame frame) {
    }

    void refresh() {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(3);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        if (this._disableQBGF) {
            return;
        }
        try {
            Transferable tr = e.getTransferable();
            DataFlavor[] dataFlavors = tr.getTransferDataFlavors();
            for (int i = 0; i < dataFlavors.length; ++i) {
                Object o = tr.getTransferData(dataFlavors[i]);
                if (!(o instanceof Node)) continue;
                e.acceptDrop(3);
                List<String> tableNamesArrayList = this._queryBuilder.getAllTables();
                String fullTableName = ((Node)o).getName();
                for (int j = 0; j < tableNamesArrayList.size(); ++j) {
                    String tableName = tableNamesArrayList.get(j);
                    String[] parts = tableName.split("\\.");
                    String justTableName = parts.length > 1 ? parts[1] : parts[0];
                    if (!justTableName.equals(fullTableName)) continue;
                    fullTableName = tableName;
                    break;
                }
                if (tableNamesArrayList.contains(fullTableName)) {
                    this.insertTableInteractively(fullTableName);
                    this._queryBuilder.generateText();
                    this.runQueryMenuItem.setEnabled(true);
                    this.groupByMenuItem.setEnabled(true);
                    this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setRunQueryMenuEnabled(true);
                    this._queryBuilder.getQueryBuilderPane().getQueryBuilderSqlTextArea().setParseQueryMenuEnabled(true);
                    this.refresh();
                    this.resizeDesktop();
                } else {
                    String msg = NbBundle.getMessage(QueryBuilderGraphFrame.class, (String)"DRAG_AND_DROP_FROM_CURRENT_DATASOURCE");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + ", " + this._queryBuilder.getConnectionInfo() + "\n\n"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
                e.dropComplete(true);
                return;
            }
            e.rejectDrop();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    class QBGFJPanel
    extends JPanel {
        QBGFJPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (QueryBuilderGraphFrame.this._queryBuilder.getParseErrorMessage() != null) {
                Graphics2D g2d = (Graphics2D)g;
                this.paintCenteredText(g2d);
            }
        }

        private void paintCenteredText(Graphics2D g) {
            int PADDING = 5;
            int LINESPACING = 3;
            String text = QueryBuilderGraphFrame.this._queryBuilder.getParseErrorMessage();
            int textLines = 1;
            int n = text.length();
            for (int i = 0; i < n; ++i) {
                if (text.charAt(i) != '\n') continue;
                ++textLines;
            }
            int width = QueryBuilderGraphFrame.this._desktopScrollPane.getViewport().getWidth();
            int height = QueryBuilderGraphFrame.this._desktopScrollPane.getViewport().getHeight();
            this.setSize(new Dimension(width, height));
            int center = height / 2;
            Font font = UIManager.getFont("Label.font");
            g.setFont(font);
            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            FontRenderContext frc = g.getFontRenderContext();
            int lineHeight = metrics.getHeight() + 3;
            int top = center - lineHeight * textLines / 2;
            int minx = width;
            int maxx = 0;
            int nextLine = 0;
            for (int line = 0; line < textLines; ++line) {
                int xw;
                String lineText;
                int lineEnd = text.indexOf(10, nextLine);
                if (lineEnd != -1) {
                    lineText = text.substring(nextLine, lineEnd);
                    nextLine = lineEnd + 1;
                } else {
                    lineText = text.substring(nextLine);
                }
                Rectangle2D bounds1 = font.getStringBounds(lineText, frc);
                int lx = (width - (int)bounds1.getWidth()) / 2;
                if (lx < minx) {
                    minx = lx;
                }
                if ((xw = lx + (int)bounds1.getWidth()) <= maxx) continue;
                maxx = xw;
            }
            Color background = null;
            background = this.getBackground();
            g.setColor(background);
            int miny = top;
            int maxy = top + textLines * lineHeight;
            g.fillRect(minx - 5, miny, maxx - minx + 10, maxy - miny + 10);
            g.setColor(Color.gray);
            nextLine = 0;
            int y = top + 10;
            y += metrics.getHeight() - metrics.getDescent();
            for (int line = 0; line < textLines; ++line) {
                String lineText;
                int lineEnd = text.indexOf(10, nextLine);
                if (lineEnd != -1) {
                    lineText = text.substring(nextLine, lineEnd);
                    nextLine = lineEnd + 1;
                } else {
                    lineText = text.substring(nextLine);
                }
                Rectangle2D bounds1 = font.getStringBounds(lineText, frc);
                int lx = (width - (int)bounds1.getWidth()) / 2;
                g.drawString(lineText, lx, y);
                y += lineHeight;
            }
        }
    }

    private class FrameSelectionListener
    extends InternalFrameAdapter {
        private FrameSelectionListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent ife) {
            Object source = ife.getSource();
            QueryBuilderInternalFrame currentSelectedFrame = (QueryBuilderInternalFrame)QueryBuilderGraphFrame.this._desktopPane.getSelectedFrame();
            QueryBuilderGraphFrame.this.setActivatedNode(currentSelectedFrame);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent ife) {
        }
    }

    private class CompListener
    extends ComponentAdapter {
        private CompListener() {
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            if (QueryBuilderGraphFrame.this._disableQBGF) {
                return;
            }
            QueryBuilderGraphFrame.this.refresh();
        }
    }

    public class PerfTimer {
        long _time;

        public PerfTimer() {
            this.resetTimer();
        }

        public void resetTimer() {
            this._time = System.currentTimeMillis();
        }

        public long elapsedTime() {
            return System.currentTimeMillis() - this._time;
        }

        public void print(String aString) {
            System.out.println(aString + ": " + this.elapsedTime() + " ms");
        }
    }

    private class ObjectSelectProvider
    implements SelectProvider {
        private ObjectSelectProvider() {
        }

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return false;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            Object object = QueryBuilderGraphFrame.this._scene.findObject(widget);
            if (object instanceof AbstractNode) {
                AbstractNode an = (AbstractNode)object;
                QueryBuilderGraphFrame.this._queryBuilder.setActivatedNodes(new Node[]{an});
                QueryBuilderGraphFrame.this._scene.userSelectionSuggested(Collections.singleton(object), invertSelection);
            }
        }
    }

    class TableTitlePopupListener
    extends MouseAdapter {
        TableTitlePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent().isEnabled()) {
                QueryBuilderGraphFrame.this._tableTitlePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

