/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.indexingbridge.IndexingBridge;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.openide.cookies.CloseCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public abstract class Group {
    private static final Logger LOG = Logger.getLogger(Group.class.getName());
    private static final Logger UILOG = Logger.getLogger("org.netbeans.ui.project.groups");
    protected static final Preferences NODE = NbPreferences.forModule(Group.class).node("groups");
    private static final String KEY_ACTIVE = "active";
    protected static final String KEY_NAME = "name";
    protected static final String KEY_KIND = "kind";
    protected static final String KEY_PATH = "path";
    protected static final String KEY_MAIN = "main";
    protected static final Preferences NONE_GROUP_NODE = NbPreferences.forModule(Group.class).node("nonegroup");
    protected static final String NONE_GROUP = "(none)";
    protected static final String noneGroupSanitizedId = "none_group";
    List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private static boolean projectsLoaded;
    private static final ThreadLocal<Boolean> switchingGroup;
    protected final String id;

    private static Group load(String id) {
        if (id == null) {
            return null;
        }
        String kind = NODE.node(id).get(KEY_KIND, null);
        if ("adHoc".equals(kind)) {
            return new AdHocGroup(id);
        }
        if ("subprojects".equals(kind)) {
            return new SubprojectsGroup(id);
        }
        if ("directory".equals(kind)) {
            return new DirectoryGroup(id);
        }
        LOG.log(Level.WARNING, "Cannot find project group kind for id={0}", id);
        return null;
    }

    public static SortedSet<Group> allGroups() {
        TreeSet<Group> groups = new TreeSet<Group>(Group.displayNameComparator());
        try {
            for (String groupId : NODE.childrenNames()) {
                LOG.log(Level.FINER, "Considering project group id={0}", groupId);
                Group g = Group.load(groupId);
                if (g == null) continue;
                groups.add(g);
            }
        }
        catch (BackingStoreException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
        return groups;
    }

    public static Group getActiveGroup() {
        return Group.load(NODE.get(KEY_ACTIVE, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveGroup(Group nue, boolean isNewGroup) {
        LOG.log(Level.FINE, "set active group: {0}", nue);
        Group old = Group.getActiveGroup();
        Preferences noneGroupPref = null;
        if (nue != null) {
            NODE.put(KEY_ACTIVE, nue.id);
        } else {
            noneGroupPref = NONE_GROUP_NODE.node(noneGroupSanitizedId);
            NODE.remove(KEY_ACTIVE);
        }
        if (old == null) {
            noneGroupPref = NONE_GROUP_NODE.node(noneGroupSanitizedId);
            noneGroupPref.put(KEY_NAME, NONE_GROUP);
            TreeSet<String> projectPaths = new TreeSet<String>();
            for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
                projectPaths.add(prj.getProjectDirectory().toURL().toExternalForm());
            }
            noneGroupPref.put(KEY_PATH, Group.joinPaths(projectPaths));
        }
        if (projectsLoaded) {
            switchingGroup.set(true);
            OpenProjectList.getDefault().fireProjectGroupChanging(old, Group.getActiveGroup());
            try {
                Group.open(nue, old != null ? old.getName() : null, isNewGroup, noneGroupPref);
            }
            finally {
                switchingGroup.set(false);
                OpenProjectList.getDefault().fireProjectGroupChanged(old, Group.getActiveGroup());
            }
        } else {
            OpenProjectListSettings settings = OpenProjectListSettings.getInstance();
            settings.setOpenProjectsURLsAsStrings(nue != null ? nue.projectPaths() : Group.getProjectPathsByPreferences(noneGroupPref));
            settings.setMainProjectURL(nue != null ? nue.prefs().get(KEY_MAIN, null) : null);
            WindowManager.getDefault().addWindowSystemListener(new WindowSystemListener(){

                public void beforeLoad(WindowSystemEvent event) {
                }

                public void afterLoad(WindowSystemEvent event) {
                    WindowManager wm = WindowManager.getDefault();
                    for (Mode mode : wm.getModes()) {
                        if (!wm.isEditorMode(mode)) continue;
                        for (TopComponent tc : wm.getOpenedTopComponents(mode)) {
                            DataObject dobj = (DataObject)tc.getLookup().lookup(DataObject.class);
                            if (dobj == null) continue;
                            tc.close();
                        }
                    }
                    String val = System.getProperty("group.supresses.lazy.loading");
                    if (val != null) {
                        System.setProperty("nb.core.windows.no.lazy.loading", val);
                    }
                    WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            OpenProjects.getDefault().getOpenProjects();
                            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                                @Override
                                public void run() {
                                    RequestProcessor.getDefault().post(new Runnable(){

                                        @Override
                                        public void run() {
                                            OpenProjectList.waitProjectsFullyOpen();
                                            for (Project p : OpenProjects.getDefault().getOpenProjects()) {
                                                ProjectUtilities.openProjectFiles(p, Group.getActiveGroup());
                                            }
                                        }
                                    });
                                }
                            });
                        }
                    });
                }

                public void beforeSave(WindowSystemEvent event) {
                }

                public void afterSave(WindowSystemEvent event) {
                }
            });
        }
        if (UILOG.isLoggable(Level.FINER)) {
            LogRecord rec = new LogRecord(Level.FINER, "Group.UI.setActiveGroup");
            rec.setParameters(new Object[]{nue != null ? nue.toString(true) : null});
            rec.setResourceBundle(NbBundle.getBundle(Group.class));
            rec.setLoggerName(UILOG.getName());
            UILOG.log(rec);
        }
    }

    public static void projectsLoaded() {
        projectsLoaded = true;
    }

    protected static String sanitizeNameAndUniquifyForId(String name) {
        HashSet<String> existing;
        String sanitizedId = name.replaceAll("[^a-zA-Z0-9_.-]+", "_");
        try {
            existing = new HashSet<String>(Arrays.asList(NODE.childrenNames()));
        }
        catch (BackingStoreException x) {
            Exceptions.printStackTrace((Throwable)x);
            return sanitizedId;
        }
        if (existing.contains(sanitizedId)) {
            int i = 2;
            while (true) {
                String candidate;
                if (!existing.contains(candidate = sanitizedId + "_" + i)) {
                    return candidate;
                }
                ++i;
            }
        }
        return sanitizedId;
    }

    public static void onShutdown(Set<Project> prjs) {
        Group active = Group.getActiveGroup();
        String oldGroupName = active != null ? active.getName() : null;
        LinkedHashSet<Project> stayOpened = new LinkedHashSet<Project>(prjs);
        Map<Project, Set<DataObject>> documents = Group.getOpenedDocuments(stayOpened, true);
        for (Project p : stayOpened) {
            Set<DataObject> oldDocuments = documents.get(p);
            Group.persistDocumentsInGroup(p, oldDocuments, oldGroupName);
        }
    }

    private static void persistDocumentsInGroup(Project p, Set<DataObject> get, String oldGroupName) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (get != null) {
            for (DataObject dob : get) {
                urls.add(dob.getPrimaryFile().toURL().toExternalForm());
            }
        }
        ProjectUtilities.storeProjectOpenFiles(p, new ArrayList<String>(urls), oldGroupName);
    }

    private static Map<Project, Set<DataObject>> getOpenedDocuments(final Set<Project> listOfProjects, boolean shutdown) {
        final LinkedHashMap<Project, Set<DataObject>> toRet = new LinkedHashMap<Project, Set<DataObject>>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WindowManager wm = WindowManager.getDefault();
                for (Mode mode : wm.getModes()) {
                    if (!wm.isEditorMode(mode)) continue;
                    for (TopComponent tc : wm.getOpenedTopComponents(mode)) {
                        FileObject fobj;
                        Project owner;
                        DataObject dobj = (DataObject)tc.getLookup().lookup(DataObject.class);
                        if (dobj == null || !listOfProjects.contains(owner = FileOwnerQuery.getOwner((FileObject)(fobj = dobj.getPrimaryFile())))) continue;
                        toRet.computeIfAbsent(owner, k -> new LinkedHashSet()).add(dobj);
                    }
                }
            }
        };
        if (!shutdown) {
            assert (!SwingUtilities.isEventDispatchThread());
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            runnable.run();
        }
        return toRet;
    }

    private static void closeDocuments(Set<DataObject> toCloseDocuments) {
        for (DataObject dobj : toCloseDocuments) {
            CloseCookie cook;
            if (dobj.isModified() || (cook = (CloseCookie)dobj.getLookup().lookup(CloseCookie.class)) == null) continue;
            cook.close();
        }
    }

    private static Set<DataObject> openDocumentsInGroup(Project p, Group g) {
        Set<FileObject> files = ProjectUtilities.openProjectFiles(p, g);
        HashSet<DataObject> dobjs = new HashSet<DataObject>();
        for (FileObject file : files) {
            try {
                DataObject dobj = DataObject.find((FileObject)file);
                if (dobj == null) continue;
                dobjs.add(dobj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
        return dobjs;
    }

    protected Group(String id) {
        this.id = id;
        assert (id.indexOf(47) == -1);
    }

    public Preferences prefs() {
        return NODE.node(this.id);
    }

    public String getName() {
        String n = this.getNameOrNull();
        if (n == null) {
            n = this.id;
        }
        return n;
    }

    protected String getNameOrNull() {
        return this.prefs().get(KEY_NAME, null);
    }

    public void setName(String n) {
        String oldGroupName = this.getNameOrNull();
        this.prefs().put(KEY_NAME, n);
        this.notifyListeners(this, "groupRename", oldGroupName, n);
        if (this.equals(Group.getActiveGroup())) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectTab.findDefault("projectTabLogical_tc").setGroup(Group.this);
                }
            });
        }
    }

    protected static Project projectForPath(String path) {
        if (path != null) {
            try {
                FileObject fo = URLMapper.findFileObject((URL)new URL(path));
                if (fo != null && fo.isFolder()) {
                    return ProjectManager.getDefault().findProject(fo);
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }

    public Set<Project> getProjects() {
        return this.getProjects(null, 0, 0);
    }

    private Set<Project> getProjects(ProgressHandle h, int start, int end) {
        if (h != null) {
            h.progress("", start);
        }
        HashSet<Project> projects = new HashSet<Project>();
        this.findProjects(projects, h, start, end);
        if (h != null) {
            h.progress("", end);
        }
        assert (!projects.contains(null)) : "Found null in " + projects + " from " + this;
        return projects;
    }

    protected abstract void findProjects(Set<Project> var1, ProgressHandle var2, int var3, int var4);

    protected List<String> projectPaths() {
        ArrayList<String> urls = new ArrayList<String>();
        for (Project p : this.getProjects()) {
            urls.add(p.getProjectDirectory().toURL().toString());
        }
        return urls;
    }

    protected static String progressMessage(Project p) {
        return Bundle.Group_progress_project(ProjectUtils.getInformation((Project)p).getDisplayName());
    }

    public Project getMainProject() {
        return Group.projectForPath(this.prefs().get(KEY_MAIN, null));
    }

    public void setMainProject(Project mainProject) throws IllegalArgumentException {
        assert (!SwingUtilities.isEventDispatchThread());
        LOG.log(Level.FINE, "updating main project for {0} to {1}", new Object[]{this.id, mainProject});
        URL f = null;
        if (mainProject != null && this.getProjects().contains(mainProject)) {
            f = mainProject.getProjectDirectory().toURL();
        }
        if (f != null) {
            this.prefs().put(KEY_MAIN, f.toExternalForm());
        } else {
            if (mainProject != null) {
                LOG.log(Level.WARNING, "...but not an open project or disk path not found");
            }
            this.prefs().remove(KEY_MAIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void open(final Group g, String oldGroupName, boolean isNewGroup, Preferences noneGroupPref) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectTab.findDefault("projectTabLogical_tc").setGroup(g);
            }
        });
        String handleLabel = g != null ? Bundle.Group_open_handle(g.getName()) : Bundle.Group_open_handle(NONE_GROUP);
        ProgressHandle h = ProgressHandle.createHandle((String)handleLabel);
        try {
            h.start(200);
            ProjectUtilities.WaitCursor.show();
            OpenProjectList opl = OpenProjectList.getDefault();
            HashSet<Project> oldOpen = new HashSet<Project>();
            for (Project open : opl.getOpenProjects()) {
                Project real = (Project)open.getLookup().lookup(Project.class);
                oldOpen.add(real != null ? real : open);
            }
            Set<Project> newOpen = g != null ? g.getProjects(h, 10, 100) : Group.getProjectsByPreferences(noneGroupPref, h, 10, 100);
            HashSet toClose = new HashSet(oldOpen);
            toClose.removeAll(newOpen);
            HashSet<Project> toOpen = new HashSet<Project>(newOpen);
            toOpen.removeAll(oldOpen);
            HashSet<Project> stayOpened = new HashSet<Project>(newOpen);
            stayOpened.retainAll(oldOpen);
            assert (!toClose.contains(null)) : toClose;
            assert (!toOpen.contains(null)) : toOpen;
            assert (toClose.isEmpty() || !new HashSet(toClose).removeAll(toOpen)) : "close and open contained the same item, issue #236211?" + Arrays.toString(toClose.toArray()) + ":::" + Arrays.toString(toOpen.toArray());
            IndexingBridge.Lock lock = IndexingBridge.getDefault().protectedMode();
            try {
                h.progress(Bundle.Group_progress_closing(toClose.size()), 110);
                opl.close(toClose.toArray(new Project[0]), false, oldGroupName);
                h.switchToIndeterminate();
                h.progress(Bundle.Group_progress_opening(toOpen.size()));
                opl.open(toOpen.toArray(new Project[0]), false, false, h, null);
                if (!isNewGroup) {
                    Map<Project, Set<DataObject>> documents = Group.getOpenedDocuments(stayOpened, false);
                    for (Project p : stayOpened) {
                        Set<DataObject> oldDocuments = documents.get(p);
                        Group.persistDocumentsInGroup(p, oldDocuments, oldGroupName);
                        Set<DataObject> newDocuments = Group.openDocumentsInGroup(p, g);
                        HashSet<DataObject> toCloseDocuments = new HashSet<DataObject>(oldDocuments != null ? oldDocuments : Collections.emptySet());
                        toCloseDocuments.removeAll(newDocuments);
                        Group.closeDocuments(toCloseDocuments);
                    }
                }
                if (g != null) {
                    opl.setMainProject(g.getMainProject());
                }
            }
            finally {
                lock.release();
            }
        }
        finally {
            ProjectUtilities.WaitCursor.hide();
            h.finish();
        }
    }

    protected void openProjectsEvent(String propertyName) {
        if (propertyName.equals("MainProject")) {
            this.setMainProject(OpenProjects.getDefault().getMainProject());
        }
    }

    public void destroy() {
        LOG.log(Level.FINE, "destroying: {0}", this.id);
        if (this.equals(Group.getActiveGroup())) {
            Group.setActiveGroup(null, false);
        }
        try {
            Preferences p = this.prefs();
            p.removeNode();
            assert (!p.nodeExists("")) : "failed to destroy " + this.id;
        }
        catch (BackingStoreException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    public abstract GroupEditPanel createPropertiesPanel();

    public static Comparator<Group> displayNameComparator() {
        return new Comparator<Group>(){
            Collator COLLATOR = Collator.getInstance();

            @Override
            public int compare(Group g1, Group g2) {
                return this.COLLATOR.compare(g1.getName(), g2.getName());
            }
        };
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Group && this.id.equals(((Group)obj).id);
    }

    public String toString() {
        return this.toString(false);
    }

    protected String toString(boolean scrubPersonalInfo) {
        return this.getClass().getName().replaceFirst("^.+\\.", "") + "[id=" + (String)(scrubPersonalInfo ? "#" + this.id.hashCode() : this.id) + ",|projects|=" + this.getProjects().size() + "]";
    }

    public boolean isPristine() {
        return this.getProjects().equals(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
    }

    protected static String joinPaths(Collection<String> paths) {
        StringBuilder b = new StringBuilder();
        for (String p : paths) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(p);
        }
        return b.toString();
    }

    private static Set<Project> getProjectsByPreferences(Preferences pref, ProgressHandle h, int start, int end) {
        if (h != null) {
            h.progress("", start);
        }
        HashSet<Project> projects = new HashSet<Project>();
        List<String> paths = Group.getProjectPathsByPreferences(pref);
        for (String path : paths) {
            Project p = Group.projectForPath(path);
            if (p == null) continue;
            if (h != null) {
                start += (end - start) / paths.size();
                h.progress(Group.progressMessage(p), start);
            }
            projects.add(p);
        }
        if (h != null) {
            h.progress("", end);
        }
        assert (!projects.contains(null)) : "Found null in " + projects + " from (none)";
        return projects;
    }

    protected static List<String> getProjectPathsByPreferences(Preferences p) {
        String paths = p.get(KEY_PATH, "");
        if (paths.length() > 0) {
            return Arrays.asList(paths.split(" "));
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(PropertyChangeListener newListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(PropertyChangeListener existingListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(existingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Object object, String property, String oldValue, String newValue) {
        ArrayList<PropertyChangeListener> changes = new ArrayList<PropertyChangeListener>();
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            changes.addAll(this.listeners);
        }
        for (PropertyChangeListener listener : changes) {
            listener.propertyChange(new PropertyChangeEvent(object, property, oldValue, newValue));
        }
    }

    static {
        switchingGroup = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        LOG.fine("initializing open projects listener");
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        Group g;
                        if (!projectsLoaded || switchingGroup.get().booleanValue()) {
                            return;
                        }
                        final String propertyName = evt.getPropertyName();
                        if (propertyName != null && (g = Group.getActiveGroup()) != null) {
                            LOG.log(Level.FINE, "received {0} on {1}", new Object[]{propertyName, g.id});
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    g.openProjectsEvent(propertyName);
                                }
                            });
                        }
                    }
                });
            }
        });
    }
}

