/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.netbeans.modules.web.monitor.data.Param;
import org.netbeans.modules.web.monitor.data.RequestData;

public class MonitorRequestWrapper
extends HttpServletRequestWrapper {
    private boolean replay = false;
    private String localMethod = null;
    private String localProtocol = null;
    private String localScheme = null;
    private String localRemoteAddr = null;
    private String localQueryString = null;
    private Param[] localHeaders = null;
    private Vector localCookies = null;
    private Map oldParams = null;
    private Map localParams = null;
    private Stack extraParamStack = null;
    public static final String JSESSIONID = "JSESSIONID";
    public static final String REPLACED = "netbeans.replay.session-replaced";
    private static final boolean debug = false;

    MonitorRequestWrapper(HttpServletRequest req) {
        super(req);
    }

    private HttpServletRequest getHRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public String getMethod() {
        if (this.replay) {
            return this.localMethod;
        }
        return this.getHRequest().getMethod();
    }

    public Map getParameterMap() {
        if (!this.replay) {
            return this.getRequest().getParameterMap();
        }
        if (this.extraParamStack == null || this.extraParamStack.empty()) {
            return this.localParams;
        }
        Map map = (Map)this.extraParamStack.peek();
        if (map.size() == 0) {
            return this.localParams;
        }
        Hashtable ht = new Hashtable();
        for (Object o : this.localParams.keySet()) {
            if (map.containsKey(o)) {
                String[] vals0 = (String[])this.localParams.get(o);
                String[] vals1 = (String[])map.get(o);
                String[] vals2 = new String[vals0.length + vals1.length];
                System.arraycopy(vals0, 0, vals2, 0, vals0.length);
                System.arraycopy(vals1, 0, vals2, vals0.length, vals1.length);
                ht.put(o, vals2);
                continue;
            }
            ht.put(o, this.localParams.get(o));
        }
        for (Object o : map.keySet()) {
            if (this.localParams.containsKey(o)) continue;
            ht.put(o, map.get(o));
        }
        return ht;
    }

    public String getParameter(String key) {
        if (!this.replay) {
            return this.getRequest().getParameter(key);
        }
        String[] values = (String[])this.getParameterMap().get(key);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (!this.replay) {
            return this.getRequest().getParameterNames();
        }
        return new Vector(this.getParameterMap().keySet()).elements();
    }

    public String[] getParameterValues(String name) {
        if (!this.replay) {
            return this.getRequest().getParameterValues(name);
        }
        return (String[])this.getParameterMap().get(name);
    }

    public String getQueryString() {
        if (!this.replay) {
            return this.getHRequest().getQueryString();
        }
        return this.localQueryString;
    }

    public String getProtocol() {
        if (!this.replay) {
            return this.getRequest().getProtocol();
        }
        return this.localProtocol;
    }

    public String getScheme() {
        if (this.replay) {
            return this.localScheme;
        }
        return this.getRequest().getScheme();
    }

    public String getHeader(String key) {
        if (this.replay) {
            int len = this.localHeaders.length;
            for (int i = 0; i < len; ++i) {
                if (!this.localHeaders[i].getName().equalsIgnoreCase(key)) continue;
                return this.localHeaders[i].getValue();
            }
            return null;
        }
        return this.getHRequest().getHeader(key);
    }

    public Enumeration getHeaderNames() {
        if (this.replay) {
            Vector<String> v = new Vector<String>();
            int len = this.localHeaders.length;
            for (int i = 0; i < len; ++i) {
                v.add(this.localHeaders[i].getName());
            }
            return v.elements();
        }
        return this.getHRequest().getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        if (this.replay) {
            Vector<String> v = new Vector<String>();
            int len = this.localHeaders.length;
            for (int i = 0; i < len; ++i) {
                if (!this.localHeaders[i].getName().equalsIgnoreCase(name)) continue;
                v.add(this.localHeaders[i].getValue());
            }
            return v.elements();
        }
        return this.getHRequest().getHeaders(name);
    }

    public int getIntHeader(String name) {
        int headerValue = -1;
        String value = this.getHeader(name);
        if (value != null) {
            headerValue = Integer.parseInt(value);
        }
        return headerValue;
    }

    public long getDateHeader(String name) {
        long dateValue = -1L;
        String value = this.getHeader(name);
        if (value != null) {
            int el = value.indexOf(59);
            if (el != -1) {
                value = value.substring(0, el);
            }
            try {
                dateValue = Date.parse(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dateValue == -1L) {
                throw new IllegalArgumentException();
            }
        }
        return dateValue;
    }

    public Cookie[] getCookies() {
        if (!this.replay) {
            return this.getHRequest().getCookies();
        }
        if (this.localCookies == null) {
            return new Cookie[0];
        }
        int numCookies = this.localCookies.size();
        Cookie[] cookieArray = new Cookie[numCookies];
        Enumeration e = this.localCookies.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            cookieArray[index] = (Cookie)e.nextElement();
            ++index;
        }
        return cookieArray;
    }

    public Enumeration getAttributeNames() {
        Enumeration e = this.getRequest().getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith("netbeans.monitor")) continue;
            v.add(name);
        }
        return v.elements();
    }

    public String getRemoteAddr() {
        return this.getRequest().getRemoteAddr();
    }

    public void populate(RequestData rd, boolean replaceSessionID) {
        String cookieStr;
        int i;
        int i2;
        this.replay = true;
        this.localMethod = rd.getAttributeValue("method");
        this.localProtocol = rd.getAttributeValue("protocol");
        this.localScheme = rd.getAttributeValue("scheme");
        this.localQueryString = rd.getAttributeValue("queryString");
        this.oldParams = this.getRequest().getParameterMap();
        if (this.localMethod.equals("GET")) {
            try {
                this.localParams = this.parseQueryString(this.localQueryString);
            }
            catch (Exception ex) {
                this.localParams = new Hashtable();
            }
        } else if (this.localMethod.equals("POST")) {
            try {
                this.localParams = this.parseQueryString(this.localQueryString);
            }
            catch (Exception ex) {
                this.localParams = new Hashtable();
            }
            Param[] params = rd.getParam();
            int numParams = params.length;
            for (i2 = 0; i2 < numParams; ++i2) {
                String name = params[i2].getAttributeValue("name");
                String[] values = null;
                if (this.localParams.containsKey(name)) {
                    values = (String[])this.localParams.get(name);
                    String[] newvals = new String[values.length + 1];
                    for (int j = 0; j < values.length; ++j) {
                        newvals[j] = values[j];
                    }
                    newvals[j] = params[i2].getAttributeValue("value");
                    this.localParams.put(name, newvals);
                    continue;
                }
                values = new String[]{params[i2].getAttributeValue("value")};
                this.localParams.put(name, values);
            }
        } else {
            this.localParams = this.localMethod.equals("PUT") ? new Hashtable() : new Hashtable();
        }
        StringBuffer cookieBuf = new StringBuffer();
        int numHeaders = rd.getHeaders().sizeParam();
        this.localHeaders = new Param[numHeaders];
        for (i2 = 0; i2 < numHeaders; ++i2) {
            this.localHeaders[i2] = rd.getHeaders().getParam(i2);
        }
        this.localCookies = new Vector();
        String idFromRequest = null;
        Param[] myCookies = rd.getCookiesAsParams();
        if (myCookies != null && myCookies.length > 0) {
            String ckname = null;
            String ckvalue = null;
            for (i = 0; i < myCookies.length; ++i) {
                ckname = myCookies[i].getAttributeValue("name");
                ckvalue = myCookies[i].getAttributeValue("value");
                if (ckname.equalsIgnoreCase(JSESSIONID)) {
                    idFromRequest = ckvalue;
                    continue;
                }
                this.localCookies.add(new Cookie(ckname, ckvalue));
                if (cookieBuf.length() > 0) {
                    cookieBuf.append("; ");
                }
                cookieBuf.append(ckname);
                cookieBuf.append("=");
                cookieBuf.append(ckvalue);
            }
        }
        boolean sessionReplaced = false;
        try {
            String value = (String)this.getHRequest().getAttribute(REPLACED);
            if (value.equals("true")) {
                sessionReplaced = true;
            }
        }
        catch (Exception value) {
            // empty catch block
        }
        if (sessionReplaced) {
            if (idFromRequest != null) {
                this.localCookies.add(new Cookie(JSESSIONID, idFromRequest));
                if (cookieBuf.length() > 0) {
                    cookieBuf.append("; ");
                }
                cookieBuf.append(JSESSIONID);
                cookieBuf.append("=");
                cookieBuf.append(idFromRequest);
            }
        } else {
            Cookie[] ck = this.getHRequest().getCookies();
            if (ck != null && ck.length > 0) {
                for (i = 0; i < ck.length; ++i) {
                    if (!ck[i].getName().equals(JSESSIONID)) continue;
                    this.localCookies.add(ck[i]);
                    if (cookieBuf.length() > 0) {
                        cookieBuf.append("; ");
                    }
                    cookieBuf.append(JSESSIONID);
                    cookieBuf.append("=");
                    cookieBuf.append(ck[i].getValue());
                }
            }
        }
        if ((cookieStr = cookieBuf.toString()).equals("")) {
            this.removeHeader("cookie");
        } else {
            this.setHeader("cookie", cookieBuf.toString());
        }
    }

    void pushExtraParameters() {
        if (!this.replay) {
            return;
        }
        Hashtable extraParams = new Hashtable();
        Map currentMap = this.getRequest().getParameterMap();
        for (Object o : currentMap.keySet()) {
            if (!this.oldParams.containsKey(o)) {
                extraParams.put(o, currentMap.get(o));
                continue;
            }
            if (this.oldParams.get(o).equals(currentMap.get(o))) continue;
            extraParams.put(o, currentMap.get(o));
        }
        if (this.extraParamStack == null) {
            this.extraParamStack = new Stack();
        }
        this.extraParamStack.push(extraParams);
    }

    void popExtraParameters() {
        if (!this.replay) {
            return;
        }
        if (this.extraParamStack == null || this.extraParamStack.empty()) {
            this.log("ERROR - MonitorRequestWrapper empty param stack!");
            return;
        }
        this.extraParamStack.pop();
    }

    private void setHeader(String headerName, String headerValue) {
        if (!this.replay) {
            this.log("setHeader() must only be used from replay");
            return;
        }
        boolean addedHeader = false;
        for (int i = 0; i < this.localHeaders.length; ++i) {
            if (!this.localHeaders[i].getName().equalsIgnoreCase(headerName)) continue;
            this.localHeaders[i].setValue(headerValue);
            addedHeader = true;
            break;
        }
        if (addedHeader) {
            return;
        }
        Param[] p = new Param[this.localHeaders.length + 1];
        for (int numHeaders = 0; numHeaders < this.localHeaders.length; ++numHeaders) {
            p[numHeaders] = this.localHeaders[numHeaders];
        }
        p[numHeaders] = new Param(headerName, headerValue);
        this.localHeaders = p;
    }

    private void removeHeader(String headerName) {
        if (!this.replay) {
            this.log("removeHeader() must only be used from replay");
            return;
        }
        Vector<Param> v = new Vector<Param>();
        for (int i = 0; i < this.localHeaders.length; ++i) {
            if (this.localHeaders[i].getName().equalsIgnoreCase(headerName)) continue;
            v.add(this.localHeaders[i]);
        }
        int size = v.size();
        this.localHeaders = new Param[size];
        for (int i = 0; i < size; ++i) {
            this.localHeaders[i] = (Param)((Object)v.elementAt(i));
        }
    }

    public String toString() {
        String value;
        String name;
        StringBuffer buf = new StringBuffer();
        buf.append("uri: ");
        buf.append(this.getRequestURI());
        buf.append("\n");
        buf.append("method: ");
        buf.append(this.getMethod());
        buf.append("\n");
        buf.append("QueryString: ");
        buf.append(this.getQueryString());
        buf.append("\n");
        buf.append("Parameters:\n");
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.getParameter(name);
            buf.append("\tName: ");
            buf.append(name);
            buf.append("\tValue: ");
            buf.append(value);
            buf.append("\n");
        }
        buf.append("Headers:\n");
        e = this.getHeaderNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = this.getHeader(name);
            buf.append("\tName: ");
            buf.append(name);
            buf.append("\tValue: ");
            buf.append(value);
            buf.append("\n");
        }
        return buf.toString();
    }

    private void log(String s) {
        System.out.println("MonitorRequestWrapper::" + s);
    }

    private Hashtable<String, String[]> parseQueryString(String queryString) {
        HashMap<String, ArrayList<String>> resultPrep = new HashMap<String, ArrayList<String>>();
        StringTokenizer st = new StringTokenizer(queryString, "&");
        while (st.hasMoreTokens()) {
            try {
                String val;
                String key;
                String pair = st.nextToken();
                int pos = pair.indexOf(61);
                if (pos >= 0) {
                    key = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
                    val = URLDecoder.decode(pair.substring(pos + 1, pair.length()), "UTF-8");
                } else {
                    key = URLDecoder.decode(pair, "UTF-8");
                    val = "";
                }
                ArrayList<String> valueList = (ArrayList<String>)resultPrep.get(key);
                if (valueList == null) {
                    valueList = new ArrayList<String>();
                    resultPrep.put(key, valueList);
                }
                valueList.add(val);
            }
            catch (UnsupportedEncodingException pair) {}
        }
        Hashtable<String, String[]> result = new Hashtable<String, String[]>();
        for (String key : resultPrep.keySet()) {
            result.put(key, (String[])((List)resultPrep.get(key)).toArray());
        }
        return result;
    }
}

