/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.internal.AbstractTemplateRptPathProvider;
import com.oracle.bmc.util.internal.Validate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentRptPathProvider
extends AbstractTemplateRptPathProvider {
    static final String OCI_RESOURCE_PRINCIPAL_RPT_PATH = "OCI_RESOURCE_PRINCIPAL_RPT_PATH";
    static final String OCI_RESOURCE_PRINCIPAL_RPT_ID = "OCI_RESOURCE_PRINCIPAL_RPT_ID";
    private final Map<String, String> replacements = Validate.notNull(EnvironmentRptPathProvider.buildReplacements(), "Environment variable 'OCI_RESOURCE_PRINCIPAL_RPT_ID' was not set", new Object[0]);

    public EnvironmentRptPathProvider() {
        super(EnvironmentRptPathProvider.getPathTemplate());
    }

    @Override
    protected Map<String, String> getReplacements() {
        return this.replacements;
    }

    protected static String getPathTemplate() {
        return System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_PATH);
    }

    protected static Map<String, String> buildReplacements() {
        String rpt_id = System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_ID);
        if (rpt_id != null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("id", rpt_id);
            return Collections.unmodifiableMap(replacements);
        }
        return null;
    }
}

