/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class SetAsCurrentThreadGutterAction
extends SystemAction
implements ContextAwareAction {
    public SetAsCurrentThreadGutterAction() {
        this.setEnabled(false);
    }

    public String getName() {
        return NbBundle.getMessage(SetAsCurrentThreadGutterAction.class, (String)"CTL_setAsCurrentThread");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent ev) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Collection annotationLookupProviders = actionContext.lookupAll(Lookup.Provider.class);
        ArrayList<JPDAThread> threads = new ArrayList<JPDAThread>(annotationLookupProviders.size());
        for (Lookup.Provider lp : annotationLookupProviders) {
            threads.addAll(lp.getLookup().lookupAll(JPDAThread.class));
        }
        if (threads.size() > 0) {
            return new ThreadAwareAction(threads);
        }
        return this;
    }

    private static class ThreadAwareAction
    implements Action,
    Presenter.Popup {
        private List<JPDAThread> threads;

        public ThreadAwareAction(List<JPDAThread> threads) {
            this.threads = threads;
        }

        private ThreadAwareAction(JPDAThread thread) {
            this.threads = Collections.singletonList(thread);
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return NbBundle.getMessage(SetAsCurrentThreadGutterAction.class, (String)"CTL_setAsCurrentThreadT", (Object)this.threads.get(0).getName());
            }
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.threads.get(0).makeCurrent();
        }

        public JMenuItem getPopupPresenter() {
            if (this.threads.size() == 1) {
                return new Actions.MenuItem((Action)this, false);
            }
            return new MultiThreadsMenu();
        }

        private class MultiThreadsMenu
        extends JMenuItem
        implements DynamicMenuContent {
            private MultiThreadsMenu() {
            }

            public JComponent[] getMenuPresenters() {
                JComponent[] cs = new JComponent[ThreadAwareAction.this.threads.size()];
                for (int i = 0; i < cs.length; ++i) {
                    cs[i] = new ThreadAwareAction(ThreadAwareAction.this.threads.get(i)).getPopupPresenter();
                }
                return cs;
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                return items;
            }
        }
    }
}

