/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeVolumeCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeVolumeCompartmentRequest
extends BmcRequest<ChangeVolumeCompartmentDetails> {
    private String volumeId;
    private ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails;
    private String opcRequestId;

    public String getVolumeId() {
        return this.volumeId;
    }

    public ChangeVolumeCompartmentDetails getChangeVolumeCompartmentDetails() {
        return this.changeVolumeCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ChangeVolumeCompartmentDetails getBody$() {
        return this.changeVolumeCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().volumeId(this.volumeId).changeVolumeCompartmentDetails(this.changeVolumeCompartmentDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeId=").append(String.valueOf(this.volumeId));
        sb.append(",changeVolumeCompartmentDetails=").append(String.valueOf((Object)this.changeVolumeCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeVolumeCompartmentRequest)) {
            return false;
        }
        ChangeVolumeCompartmentRequest other = (ChangeVolumeCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeId, other.volumeId) && Objects.equals((Object)this.changeVolumeCompartmentDetails, (Object)other.changeVolumeCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeId == null ? 43 : this.volumeId.hashCode());
        result = result * 59 + (this.changeVolumeCompartmentDetails == null ? 43 : this.changeVolumeCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeVolumeCompartmentRequest, ChangeVolumeCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeId = null;
        private ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails = null;
        private String opcRequestId = null;

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder changeVolumeCompartmentDetails(ChangeVolumeCompartmentDetails changeVolumeCompartmentDetails) {
            this.changeVolumeCompartmentDetails = changeVolumeCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeVolumeCompartmentRequest o) {
            this.volumeId(o.getVolumeId());
            this.changeVolumeCompartmentDetails(o.getChangeVolumeCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeVolumeCompartmentRequest build() {
            ChangeVolumeCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeVolumeCompartmentDetails body) {
            this.changeVolumeCompartmentDetails(body);
            return this;
        }

        public ChangeVolumeCompartmentRequest buildWithoutInvocationCallback() {
            ChangeVolumeCompartmentRequest request = new ChangeVolumeCompartmentRequest();
            request.volumeId = this.volumeId;
            request.changeVolumeCompartmentDetails = this.changeVolumeCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

