/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCaptureFilterRequest
extends BmcRequest<Void> {
    private String captureFilterId;
    private String opcRequestId;

    public String getCaptureFilterId() {
        return this.captureFilterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().captureFilterId(this.captureFilterId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",captureFilterId=").append(String.valueOf(this.captureFilterId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCaptureFilterRequest)) {
            return false;
        }
        GetCaptureFilterRequest other = (GetCaptureFilterRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.captureFilterId, other.captureFilterId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.captureFilterId == null ? 43 : this.captureFilterId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCaptureFilterRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String captureFilterId = null;
        private String opcRequestId = null;

        public Builder captureFilterId(String captureFilterId) {
            this.captureFilterId = captureFilterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCaptureFilterRequest o) {
            this.captureFilterId(o.getCaptureFilterId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCaptureFilterRequest build() {
            GetCaptureFilterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCaptureFilterRequest buildWithoutInvocationCallback() {
            GetCaptureFilterRequest request = new GetCaptureFilterRequest();
            request.captureFilterId = this.captureFilterId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

