/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.visual.HtmlSourceElementHandle;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.filesystems.FileObject;

public final class HtmlEditorSourceTask
extends ParserResultTask<HtmlParserResult> {
    private static final Logger LOGGER = Logger.getLogger(HtmlEditorSourceTask.class.getSimpleName());
    private static HtmlSourceElementHandle activeElement;

    public int getPriority() {
        return 500;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult result, SchedulerEvent event) {
        FileObject file = result.getSnapshot().getSource().getFileObject();
        if (file == null) {
            LOGGER.log(Level.FINE, "null file, exit");
            return;
        }
        if (!file.isValid()) {
            LOGGER.log(Level.FINE, "invalid file, exit");
            return;
        }
        if (event == null) {
            LOGGER.log(Level.FINE, "run() - NULL SchedulerEvent?!?!?!");
        } else {
            if (event instanceof CursorMovedSchedulerEvent) {
                this.setActiveElement(result, ((CursorMovedSchedulerEvent)event).getCaretOffset());
                return;
            }
            LOGGER.log(Level.FINE, "run() - !(event instanceof CursorMovedSchedulerEvent)");
        }
        activeElement = null;
    }

    private void setActiveElement(HtmlParserResult result, int caretOffset) {
        Node node;
        Snapshot snapshot = result.getSnapshot();
        FileObject file = snapshot.getSource().getFileObject();
        int embeddedCaretOffset = snapshot.getEmbeddedOffset(caretOffset);
        if (embeddedCaretOffset == -1) {
            return;
        }
        Element findBack = result.findByPhysicalRange(embeddedCaretOffset, false);
        if (findBack != null && (findBack.type() == ElementType.OPEN_TAG || findBack.type() == ElementType.CLOSE_TAG) && findBack.to() == embeddedCaretOffset) {
            --embeddedCaretOffset;
        }
        if ((node = result.findBySemanticRange(embeddedCaretOffset, true)) != null && node.type() == ElementType.OPEN_TAG) {
            activeElement = new HtmlSourceElementHandle((OpenTag)node, snapshot, file);
            return;
        }
        activeElement = null;
    }

    public static HtmlSourceElementHandle getElement() {
        return activeElement;
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new HtmlEditorSourceTask());
        }
    }
}

