/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import processing.app.Editor;
import processing.app.format.AutoFormat;
import processing.app.tools.Tool;

public class AutoFormatTool
implements Tool {
    private Editor editor;

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "Auto Format";
    }

    public void run() {
        String source = this.editor.getText();
        try {
            AutoFormat formatter = new AutoFormat();
            String formattedText = formatter.format(source);
            int selectionEnd = this.editor.getSelectionStop();
            if (formattedText.length() < selectionEnd - 1) {
                selectionEnd = formattedText.length() - 1;
            }
            if (formattedText.equals(source)) {
                this.editor.statusNotice("No changes necessary for Auto Format.");
            } else {
                this.editor.setText(formattedText);
                this.editor.setSelection(selectionEnd, selectionEnd);
                this.editor.getSketch().setModified(true);
                this.editor.statusNotice("Auto Format finished.");
            }
        }
        catch (Exception e) {
            this.editor.statusError(e);
        }
    }
}

