# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.infra.services.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ServiceEntries(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.infra.services.service_entries'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ServiceEntriesStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               service_id,
               service_entry_id,
               ):
        """
        Delete Service entry

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service_entry_id: :class:`str`
        :param service_entry_id: Service entry ID (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'service_id': service_id,
                            'service_entry_id': service_entry_id,
                            })

    def get(self,
            service_id,
            service_entry_id,
            ):
        """
        Service entry

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service_entry_id: :class:`str`
        :param service_entry_id: Service entry ID (required)
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.ServiceEntry
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.ServiceEntry`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'service_id': service_id,
                            'service_entry_id': service_entry_id,
                            })

    def list(self,
             service_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of Service entries for the given service

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.ServiceEntryListResult`
        :return: com.vmware.nsx_policy.model.ServiceEntryListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'service_id': service_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              service_id,
              service_entry_id,
              service_entry,
              ):
        """
        If a service entry with the service-entry-id is not already present,
        create a new service entry. If it already exists, patch the service
        entry.

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service_entry_id: :class:`str`
        :param service_entry_id: Service entry ID (required)
        :type  service_entry: :class:`vmware.vapi.struct.VapiStruct`
        :param service_entry: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.ServiceEntry`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'service_id': service_id,
                            'service_entry_id': service_entry_id,
                            'service_entry': service_entry,
                            })

    def update(self,
               service_id,
               service_entry_id,
               service_entry,
               ):
        """
        If a service entry with the service-entry-id is not already present,
        create a new service entry. If it already exists, update the service
        entry.

        :type  service_id: :class:`str`
        :param service_id: Service ID (required)
        :type  service_entry_id: :class:`str`
        :param service_entry_id: Service entry ID (required)
        :type  service_entry: :class:`vmware.vapi.struct.VapiStruct`
        :param service_entry: (required)
            The parameter must contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.ServiceEntry`.
        :rtype: :class:`vmware.vapi.struct.VapiStruct`
        :return: com.vmware.nsx_policy.model.ServiceEntry
            The return value will contain all the attributes defined in
            :class:`com.vmware.nsx_policy.model_client.ServiceEntry`.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'service_id': service_id,
                            'service_entry_id': service_entry_id,
                            'service_entry': service_entry,
                            })
class _ServiceEntriesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'service_id': type.StringType(),
            'service_entry_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/infra/services/{service-id}/service-entries/{service-entry-id}',
            path_variables={
                'service_id': 'service-id',
                'service_entry_id': 'service-entry-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'service_id': type.StringType(),
            'service_entry_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/services/{service-id}/service-entries/{service-entry-id}',
            path_variables={
                'service_id': 'service-id',
                'service_entry_id': 'service-entry-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'service_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/infra/services/{service-id}/service-entries',
            path_variables={
                'service_id': 'service-id',
            },
             header_parameters={
                           },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'service_id': type.StringType(),
            'service_entry_id': type.StringType(),
            'service_entry': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'ServiceEntry')]),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/infra/services/{service-id}/service-entries/{service-entry-id}',
            request_body_parameter='service_entry',
            path_variables={
                'service_id': 'service-id',
                'service_entry_id': 'service-entry-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'service_id': type.StringType(),
            'service_entry_id': type.StringType(),
            'service_entry': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'ServiceEntry')]),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/infra/services/{service-id}/service-entries/{service-entry-id}',
            request_body_parameter='service_entry',
            path_variables={
                'service_id': 'service-id',
                'service_entry_id': 'service-entry-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'ServiceEntry')]),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'ServiceEntryListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.DynamicStructType('vmware.vapi.dynamic_struct', {}, VapiStruct, [type.ReferenceType('com.vmware.nsx_policy.model_client', 'ServiceEntry')]),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.infra.services.service_entries',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ServiceEntries': ServiceEntries,
    }

