/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.shaded.org.xbill.DNS.DClass;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.Header;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.OPTRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.RRset;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.Resolver;
import org.apache.hadoop.shaded.org.xbill.DNS.SIGRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Section;
import org.apache.hadoop.shaded.org.xbill.DNS.TSIG;
import org.apache.hadoop.shaded.org.xbill.DNS.TSIGRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Type;
import org.apache.hadoop.shaded.org.xbill.DNS.Update;
import org.apache.hadoop.shaded.org.xbill.DNS.WireParseException;

public class Message
implements Cloneable {
    public static final int MAXLENGTH = 65535;
    private Header header;
    private List<Record>[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    private Resolver resolver;
    int tsigstart;
    int tsigState;
    int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static final Record[] emptyRecordArray = new Record[0];

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int id) {
        this(new Header(id));
    }

    public Message() {
        this(new Header());
    }

    public static Message newQuery(Record r) {
        Message m4 = new Message();
        m4.header.setOpcode(0);
        m4.header.setFlag(7);
        m4.addRecord(r, 0);
        return m4;
    }

    public static Message newUpdate(Name zone) {
        return new Update(zone);
    }

    Message(DNSInput in) throws IOException {
        block7: {
            this(new Header(in));
            boolean isUpdate = this.header.getOpcode() == 5;
            boolean truncated = this.header.getFlag(6);
            try {
                for (int i = 0; i < 4; ++i) {
                    int count = this.header.getCount(i);
                    if (count > 0) {
                        this.sections[i] = new ArrayList<Record>(count);
                    }
                    for (int j = 0; j < count; ++j) {
                        SIGRecord sig;
                        int pos = in.current();
                        Record rec = Record.fromWire(in, i, isUpdate);
                        this.sections[i].add(rec);
                        if (i != 3) continue;
                        if (rec.getType() == 250) {
                            this.tsigstart = pos;
                            if (j != count - 1) {
                                throw new WireParseException("TSIG is not the last record in the message");
                            }
                        }
                        if (rec.getType() != 24 || (sig = (SIGRecord)rec).getTypeCovered() != 0) continue;
                        this.sig0start = pos;
                    }
                }
            }
            catch (WireParseException e) {
                if (truncated) break block7;
                throw e;
            }
        }
        this.size = in.current();
    }

    public Message(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    public Message(ByteBuffer byteBuffer) throws IOException {
        this(new DNSInput(byteBuffer));
    }

    public void setHeader(Header h2) {
        this.header = h2;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record r, int section) {
        if (this.sections[section] == null) {
            this.sections[section] = new LinkedList<Record>();
        }
        this.header.incCount(section);
        this.sections[section].add(r);
    }

    public boolean removeRecord(Record r, int section) {
        if (this.sections[section] != null && this.sections[section].remove(r)) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int section) {
        this.sections[section] = null;
        this.header.setCount(section, 0);
    }

    public boolean findRecord(Record r, int section) {
        return this.sections[section] != null && this.sections[section].contains(r);
    }

    public boolean findRecord(Record r) {
        for (int i = 1; i <= 3; ++i) {
            if (this.sections[i] == null || !this.sections[i].contains(r)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type, int section) {
        if (this.sections[section] == null) {
            return false;
        }
        for (int i = 0; i < this.sections[section].size(); ++i) {
            Record r = this.sections[section].get(i);
            if (r.getType() != type || !name.equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public Record getQuestion() {
        List<Record> l = this.sections[0];
        if (l == null || l.size() == 0) {
            return null;
        }
        return l.get(0);
    }

    public TSIGRecord getTSIG() {
        int count = this.header.getCount(3);
        if (count == 0) {
            return null;
        }
        List<Record> l = this.sections[3];
        Record rec = l.get(count - 1);
        if (rec.type != 250) {
            return null;
        }
        return (TSIGRecord)rec;
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        for (Record record : this.getSection(3)) {
            if (!(record instanceof OPTRecord)) continue;
            return (OPTRecord)record;
        }
        return null;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode += opt.getExtendedRcode() << 4;
        }
        return rcode;
    }

    @Deprecated
    public Record[] getSectionArray(int section) {
        if (this.sections[section] == null) {
            return emptyRecordArray;
        }
        List<Record> l = this.sections[section];
        return l.toArray(new Record[0]);
    }

    public List<Record> getSection(int section) {
        if (this.sections[section] == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sections[section]);
    }

    private static boolean sameSet(Record r1, Record r2) {
        return r1.getRRsetType() == r2.getRRsetType() && r1.getDClass() == r2.getDClass() && r1.getName().equals(r2.getName());
    }

    public List<RRset> getSectionRRsets(int section) {
        if (this.sections[section] == null) {
            return Collections.emptyList();
        }
        LinkedList<RRset> sets = new LinkedList<RRset>();
        HashSet<Name> hash = new HashSet<Name>();
        for (Record rec : this.getSection(section)) {
            Name name = rec.getName();
            boolean newset = true;
            if (hash.contains(name)) {
                for (int j = sets.size() - 1; j >= 0; --j) {
                    RRset set = (RRset)sets.get(j);
                    if (set.getType() != rec.getRRsetType() || set.getDClass() != rec.getDClass() || !set.getName().equals(name)) continue;
                    set.addRR(rec);
                    newset = false;
                    break;
                }
            }
            if (!newset) continue;
            RRset set = new RRset(rec);
            sets.add(set);
            hash.add(name);
        }
        return sets;
    }

    void toWire(DNSOutput out) {
        this.header.toWire(out);
        Compression c = new Compression();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            for (Record rec : this.sections[i]) {
                rec.toWire(out, i, c);
            }
        }
    }

    private int sectionToWire(DNSOutput out, int section, Compression c, int maxLength) {
        int n = this.sections[section].size();
        int pos = out.current();
        int rendered = 0;
        int count = 0;
        Record lastrec = null;
        for (int i = 0; i < n; ++i) {
            Record rec = this.sections[section].get(i);
            if (section == 3 && rec instanceof OPTRecord) continue;
            if (lastrec != null && !Message.sameSet(rec, lastrec)) {
                pos = out.current();
                rendered = count;
            }
            lastrec = rec;
            rec.toWire(out, section, c);
            if (out.current() > maxLength) {
                out.jump(pos);
                return n - rendered;
            }
            ++count;
        }
        return n - count;
    }

    private void toWire(DNSOutput out, int maxLength) {
        if (maxLength < 12) {
            return;
        }
        int tempMaxLength = maxLength;
        if (this.tsigkey != null) {
            tempMaxLength -= this.tsigkey.recordLength();
        }
        OPTRecord opt = this.getOPT();
        byte[] optBytes = null;
        if (opt != null) {
            optBytes = opt.toWire(3);
            tempMaxLength -= optBytes.length;
        }
        int startpos = out.current();
        this.header.toWire(out);
        Compression c = new Compression();
        int flags = this.header.getFlagsByte();
        int additionalCount = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.sections[i] == null) continue;
            int skipped = this.sectionToWire(out, i, c, tempMaxLength);
            if (skipped != 0 && i != 3) {
                flags = Header.setFlag(flags, 6, true);
                out.writeU16At(this.header.getCount(i) - skipped, startpos + 4 + 2 * i);
                for (int j = i + 1; j < 3; ++j) {
                    out.writeU16At(0, startpos + 4 + 2 * j);
                }
                break;
            }
            if (i != 3) continue;
            additionalCount = this.header.getCount(i) - skipped;
        }
        if (optBytes != null) {
            out.writeByteArray(optBytes);
            ++additionalCount;
        }
        if (flags != this.header.getFlagsByte()) {
            out.writeU16At(flags, startpos + 2);
        }
        if (additionalCount != this.header.getCount(3)) {
            out.writeU16At(additionalCount, startpos + 10);
        }
        if (this.tsigkey != null) {
            TSIGRecord tsigrec = this.tsigkey.generate(this, out.toByteArray(), this.tsigerror, this.querytsig);
            tsigrec.toWire(out, 3, c);
            out.writeU16At(additionalCount + 1, startpos + 10);
        }
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        this.size = out.current();
        return out.toByteArray();
    }

    public byte[] toWire(int maxLength) {
        DNSOutput out = new DNSOutput();
        this.toWire(out, maxLength);
        this.size = out.current();
        return out.toByteArray();
    }

    public void setTSIG(TSIG key, int error, TSIGRecord querytsig) {
        this.tsigkey = key;
        this.tsigerror = error;
        this.querytsig = querytsig;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int i) {
        if (i > 3) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Record rec : this.getSection(i)) {
            if (i == 0) {
                sb.append(";;\t").append(rec.name);
                sb.append(", type = ").append(Type.string(rec.type));
                sb.append(", class = ").append(DClass.string(rec.dclass));
            } else {
                sb.append(rec);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(this.header.toStringWithRcode(this.getRcode())).append("\n");
        } else {
            sb.append(this.header).append("\n");
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append('\n');
        }
        for (int i = 0; i < 4; ++i) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; ").append(Section.longString(i)).append(":\n");
            } else {
                sb.append(";; ").append(Section.updString(i)).append(":\n");
            }
            sb.append(this.sectionToString(i)).append("\n");
        }
        sb.append(";; Message size: ").append(this.numBytes()).append(" bytes");
        return sb.toString();
    }

    public Message clone() {
        Message m4 = (Message)super.clone();
        m4.sections = new List[this.sections.length];
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            m4.sections[i] = new LinkedList<Record>(this.sections[i]);
        }
        m4.header = this.header.clone();
        if (this.querytsig != null) {
            m4.querytsig = (TSIGRecord)this.querytsig.cloneRecord();
        }
        return m4;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public Optional<Resolver> getResolver() {
        return Optional.ofNullable(this.resolver);
    }
}

