/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.collector;

import io.prometheus.client.Collector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetricSamples {
    private final Map<String, Collector.MetricFamilySamples> samplesByMetricName;
    private final Set<Collector.MetricFamilySamples.Sample> seenSamples;

    public MetricSamples(Map<String, Collector.MetricFamilySamples> input) {
        this.samplesByMetricName = input;
        this.seenSamples = new HashSet<Collector.MetricFamilySamples.Sample>();
        for (Collector.MetricFamilySamples metricFamilySamples : input.values()) {
            this.seenSamples.addAll(metricFamilySamples.samples);
        }
    }

    public MetricSamples() {
        this(new HashMap<String, Collector.MetricFamilySamples>());
    }

    public void addSamplesIfNotPresent(String metricName, Collector.MetricFamilySamples metricFamilySamples) {
        if (this.samplesByMetricName.putIfAbsent(metricName, metricFamilySamples) == null) {
            this.seenSamples.addAll(metricFamilySamples.samples);
        }
    }

    public void addSampleIfMetricExists(String metricName, Collector.MetricFamilySamples.Sample sample) {
        Collector.MetricFamilySamples sampleFamily = this.samplesByMetricName.get(metricName);
        if (sampleFamily == null) {
            return;
        }
        if (this.seenSamples.add(sample)) {
            sampleFamily.samples.add(sample);
        }
    }

    public void addAll(MetricSamples other) {
        for (Map.Entry<String, Collector.MetricFamilySamples> entry : other.samplesByMetricName.entrySet()) {
            String key = entry.getKey();
            if (this.samplesByMetricName.containsKey(key)) {
                for (Collector.MetricFamilySamples.Sample sample : entry.getValue().samples) {
                    this.addSampleIfMetricExists(key, sample);
                }
                continue;
            }
            this.samplesByMetricName.put(key, entry.getValue());
            this.seenSamples.addAll(entry.getValue().samples);
        }
    }

    public List<Collector.MetricFamilySamples> asList() {
        return this.samplesByMetricName.values().stream().filter(value -> !value.samples.isEmpty()).collect(Collectors.toList());
    }
}

