/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.URLPathname;

public class JavaClassLoader
extends URLClassLoader {
    private static JavaClassLoader persistentInstance;
    public static boolean checkPreCompiledClassLoader;
    private static Set<String> packages;
    public static final Symbol CLASSLOADER;
    private static final Primitive GET_DEFAULT_CLASSLOADER;
    private static final Primitive MAKE_CLASSLOADER;
    private static final Primitive DUMP_CLASSPATH;
    private static final Primitive GET_CURRENT_CLASSLOADER;
    private static final Primitive ADD_TO_CLASSPATH;

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> c;
        if (checkPreCompiledClassLoader && (c = this.findPrecompiledClassOrNull(name)) != null) {
            return c;
        }
        return this.loadClass(name, false);
    }

    public Class<?> findPrecompiledClassOrNull(String name) {
        for (ClassLoader ourCL = JavaClassLoader.class.getClassLoader(); ourCL != null; ourCL = ourCL.getParent()) {
            try {
                return Class.forName(name, true, ourCL);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public byte[] getFunctionClassBytes(String name) {
        Pathname pathname = Pathname.create(name.substring("org/armedbear/lisp/".length()) + "." + Lisp._COMPILE_FILE_CLASS_EXTENSION_.symbolValue().getStringValue());
        return Lisp.readFunctionBytes(pathname);
    }

    public byte[] getFunctionClassBytes(Class<?> functionClass) {
        String className = functionClass.getName();
        try {
            String ext = Lisp._COMPILE_FILE_CLASS_EXTENSION_.symbolValue().getStringValue();
            InputStream is = this.getResourceAsStream(className.replace('.', '/') + "." + ext);
            if (is != null) {
                byte[] imgDataBa = new byte[is.available()];
                DataInputStream dataIs = new DataInputStream(is);
                dataIs.readFully(imgDataBa);
                return imgDataBa;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getFunctionClassBytes(className);
    }

    public final byte[] getFunctionClassBytes(Function f) {
        byte[] b = this.getFunctionClassBytes(f.getClass());
        f.setClassBytes(b);
        return b;
    }

    public JavaClassLoader() {
        this(JavaClassLoader.class.getClassLoader());
    }

    public JavaClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public JavaClassLoader(JavaClassLoader parent) {
        super(new URL[0], (ClassLoader)parent);
    }

    public JavaClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
    }

    public static JavaClassLoader getPersistentInstance() {
        return JavaClassLoader.getPersistentInstance(null);
    }

    public static JavaClassLoader getPersistentInstance(String packageName) {
        if (persistentInstance == null) {
            persistentInstance = new JavaClassLoader();
        }
        JavaClassLoader.definePackage(packageName);
        return persistentInstance;
    }

    private static void definePackage(String packageName) {
        if (packageName != null && !packages.contains(packageName)) {
            persistentInstance.definePackage(packageName, "", "1.0", "", "", "1.0", "", null);
            packages.add(packageName);
        }
    }

    public Class<?> loadClassFromByteArray(byte[] classbytes) {
        return this.loadClassFromByteArray(null, classbytes);
    }

    public Class<?> loadClassFromByteArray(String className, byte[] classbytes) {
        try {
            Class<?> c;
            long length = classbytes.length;
            if (length < Integer.MAX_VALUE && (c = this.defineLispClass(className, classbytes, 0, (int)length)) != null) {
                this.resolveClass(c);
                return c;
            }
        }
        catch (LinkageError e) {
            throw e;
        }
        catch (Throwable t) {
            Debug.trace(t);
        }
        return null;
    }

    protected final Class<?> defineLispClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClass(name, b, off, len);
    }

    public Class<?> loadClassFromByteArray(String className, byte[] bytes, int offset, int length) {
        try {
            Class<?> c = this.defineLispClass(className, bytes, offset, length);
            if (c != null) {
                this.resolveClass(c);
                return c;
            }
        }
        catch (VerifyError e) {
            Lisp.error(new LispError("Class verification failed: " + e.getMessage()));
        }
        catch (Throwable t) {
            Debug.trace(t);
        }
        return null;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    protected static void addURL(JavaClassLoader jcl, LispObject jar) {
        URLPathname urlPathname = null;
        if (jar instanceof URLPathname) {
            urlPathname = (URLPathname)jar;
        } else if (jar instanceof Pathname) {
            urlPathname = URLPathname.createFromFile((Pathname)jar);
        } else if (jar instanceof AbstractString) {
            String namestring = jar.getStringValue();
            if (!Pathname.isValidURL(namestring)) {
                Pathname p = Pathname.create(namestring);
                if (p != null) {
                    urlPathname = URLPathname.create(p);
                }
            } else {
                urlPathname = URLPathname.create(namestring);
            }
        }
        if (urlPathname == null) {
            Lisp.error(new TypeError(String.valueOf(jar) + " must be a pathname designator"));
        }
        jcl.addURL(urlPathname.toURL());
    }

    public static LispObject dumpClassPath(ClassLoader o) {
        if (o instanceof URLClassLoader) {
            LispObject list = Lisp.NIL;
            for (URL u : ((URLClassLoader)o).getURLs()) {
                list = list.push(URLPathname.create(u));
            }
            return new Cons(new JavaObject(o), list.nreverse());
        }
        return new JavaObject(o);
    }

    public static ClassLoader getCurrentClassLoader() {
        LispObject classLoader = CLASSLOADER.symbolValueNoThrow();
        if (classLoader != null) {
            return (ClassLoader)classLoader.javaInstance(ClassLoader.class);
        }
        return Lisp.class.getClassLoader();
    }

    static {
        checkPreCompiledClassLoader = true;
        packages = Collections.synchronizedSet(new HashSet());
        CLASSLOADER = Lisp.PACKAGE_JAVA.intern("*CLASSLOADER*");
        GET_DEFAULT_CLASSLOADER = new pf_get_default_classloader();
        MAKE_CLASSLOADER = new pf_make_classloader();
        DUMP_CLASSPATH = new pf_dump_classpath();
        GET_CURRENT_CLASSLOADER = new pf_get_current_classloader();
        ADD_TO_CLASSPATH = new pf_add_to_classpath();
    }

    private static final class pf_add_to_classpath
    extends Primitive {
        pf_add_to_classpath() {
            super("%add-to-classpath", Lisp.PACKAGE_JAVA, false, "jar-or-jars &optional (classloader (get-current-classloader))");
        }

        @Override
        public LispObject execute(LispObject jarOrJars) {
            return this.execute(jarOrJars, new JavaObject(JavaClassLoader.getCurrentClassLoader()));
        }

        @Override
        public LispObject execute(LispObject jarOrJars, LispObject classloader) {
            Object o = classloader.javaInstance();
            if (o instanceof JavaClassLoader) {
                JavaClassLoader jcl = (JavaClassLoader)o;
                if (jarOrJars instanceof Cons) {
                    while (jarOrJars != Lisp.NIL) {
                        JavaClassLoader.addURL(jcl, jarOrJars.car());
                        jarOrJars = jarOrJars.cdr();
                    }
                } else {
                    JavaClassLoader.addURL(jcl, jarOrJars);
                }
                return Lisp.T;
            }
            return Lisp.error(new TypeError(String.valueOf(o) + " must be an instance of " + JavaClassLoader.class.getName()));
        }
    }

    @DocString(name="get-current-classloader")
    private static final class pf_get_current_classloader
    extends Primitive {
        pf_get_current_classloader() {
            super("get-current-classloader", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute() {
            return new JavaObject(JavaClassLoader.getCurrentClassLoader());
        }
    }

    private static final class pf_dump_classpath
    extends Primitive {
        pf_dump_classpath() {
            super("dump-classpath", Lisp.PACKAGE_JAVA, true, "&optional classloader");
        }

        @Override
        public LispObject execute() {
            return this.execute(new JavaObject(JavaClassLoader.getCurrentClassLoader()));
        }

        @Override
        public LispObject execute(LispObject classloader) {
            LispObject list = Lisp.NIL;
            Object o = classloader.javaInstance();
            while (o instanceof ClassLoader) {
                ClassLoader cl = (ClassLoader)o;
                list = list.push(JavaClassLoader.dumpClassPath(cl));
                o = cl.getParent();
            }
            return list.nreverse();
        }
    }

    private static final class pf_make_classloader
    extends Primitive {
        pf_make_classloader() {
            super("make-classloader", Lisp.PACKAGE_JAVA, true, "&optional parent");
        }

        @Override
        public LispObject execute() {
            return new JavaObject(new JavaClassLoader(JavaClassLoader.getCurrentClassLoader()));
        }

        @Override
        public LispObject execute(LispObject parent) {
            return new JavaObject(new JavaClassLoader((ClassLoader)parent.javaInstance(ClassLoader.class)));
        }
    }

    private static final class pf_get_default_classloader
    extends Primitive {
        private final LispObject defaultClassLoader = new JavaObject(new JavaClassLoader());

        pf_get_default_classloader() {
            super("get-default-classloader", Lisp.PACKAGE_JAVA, true, "");
        }

        @Override
        public LispObject execute() {
            return this.defaultClassLoader;
        }
    }
}

