/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.api.MavenStreamResolver;
import org.jboss.galleon.api.ProvisioningBuilder;
import org.jboss.galleon.api.ProvisioningImpl;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.core.builder.LocalFP;
import org.jboss.galleon.impl.ProvisioningUtil;
import org.jboss.galleon.impl.VersionMatcher;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.IoUtils;

public class GalleonBuilder
extends UniverseResolverBuilder<GalleonBuilder> {
    private static final String GALLEON_CORE_GROUP_ID = "org.jboss.galleon";
    private static final String GALLEON_CORE_ARTIFACT_ID = "galleon-core";
    private static final String GALLEON_CORE_EXTENSION = "jar";
    private static final Map<String, ClassLoaderUsage> classLoaders = new HashMap<String, ClassLoaderUsage>();
    private UniverseResolver resolver;
    private final Map<FeaturePackLocation.FPID, LocalFP> locals = new HashMap<FeaturePackLocation.FPID, LocalFP>();

    public FeaturePackLocation addLocal(Path path, boolean installInUniverse) throws ProvisioningException {
        FeaturePackLocation.FPID fpid;
        try {
            fpid = ProvisioningUtil.getFeaturePackProducer(path);
        }
        catch (Exception ex) {
            throw new ProvisioningException(ex);
        }
        this.locals.put(fpid, new LocalFP(fpid, path, installInUniverse));
        return fpid.getLocation();
    }

    public GalleonBuilder setUniverseResolver(UniverseResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    private UniverseResolver getUniverseResolver() throws ProvisioningException {
        if (this.resolver == null) {
            this.resolver = this.buildUniverseResolver();
        }
        return this.resolver;
    }

    public ProvisioningBuilder newProvisioningBuilder() throws ProvisioningException {
        String coreVersion = this.getMavenResolvedCoreVersion();
        if (coreVersion == null) {
            coreVersion = APIVersion.getVersion();
        }
        return new ProvisioningBuilder(this.getUniverseResolver(), this.locals, coreVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningBuilder newProvisioningBuilder(Path provisioning) throws ProvisioningException {
        String coreVersion = this.getMavenResolvedCoreVersion();
        if (coreVersion == null) {
            Path tmp = GalleonBuilder.getTmpDirectory();
            try {
                coreVersion = ProvisioningUtil.getCoreVersion(provisioning, this.getUniverseResolver(), tmp);
                GalleonBuilder.checkArtifactResolver(coreVersion, this.getUniverseResolver());
            }
            finally {
                IoUtils.recursiveDelete(tmp);
            }
        }
        return new ProvisioningBuilder(this.getUniverseResolver(), this.locals, coreVersion);
    }

    public ProvisioningBuilder newProvisioningBuilder(GalleonProvisioningConfig config) throws ProvisioningException {
        return new ProvisioningBuilder(this.getUniverseResolver(), this.locals, this.getCoreVersion(config));
    }

    public URLClassLoader getCoreClassLoader(Path file) throws ProvisioningException {
        return GalleonBuilder.getCallerClassLoader(this.getCoreVersion(file), this.resolver);
    }

    public URLClassLoader getCoreClassLoader(String coreVersion) throws ProvisioningException {
        String mavenResolvedVersion = this.getMavenResolvedCoreVersion();
        if (mavenResolvedVersion != null) {
            coreVersion = mavenResolvedVersion;
        }
        return GalleonBuilder.getCallerClassLoader(coreVersion, this.resolver);
    }

    public String getCoreVersion(FeaturePackLocation fpl) throws ProvisioningException {
        GalleonProvisioningConfig config = ((GalleonProvisioningConfig.Builder)GalleonProvisioningConfig.builder().addFeaturePackDep(fpl)).build();
        return this.getCoreVersion(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCoreVersion(Path file) throws ProvisioningException {
        String coreVersion = this.getMavenResolvedCoreVersion();
        if (coreVersion == null) {
            Path tmp = GalleonBuilder.getTmpDirectory();
            try {
                coreVersion = ProvisioningUtil.getCoreVersion(file, this.getUniverseResolver(), tmp);
                GalleonBuilder.checkArtifactResolver(coreVersion, this.getUniverseResolver());
            }
            finally {
                IoUtils.recursiveDelete(tmp);
            }
        }
        return coreVersion;
    }

    private String getMavenResolvedCoreVersion() throws ProvisioningException {
        RepositoryArtifactResolver repoManager;
        String coreVersion = null;
        UniverseResolver universeResolver = this.getUniverseResolver();
        if (GalleonBuilder.hasMavenArtifactResolver(universeResolver) && (repoManager = GalleonBuilder.getArtifactResolver(universeResolver)) instanceof MavenStreamResolver) {
            MavenStreamResolver resolver = (MavenStreamResolver)((Object)repoManager);
            try {
                coreVersion = resolver.getLatestVersion(GALLEON_CORE_GROUP_ID, GALLEON_CORE_ARTIFACT_ID, GALLEON_CORE_EXTENSION, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (coreVersion != null && VersionMatcher.COMPARATOR.compare(APIVersion.getVersion(), coreVersion) > 0) {
            coreVersion = APIVersion.getVersion();
        }
        return coreVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCoreVersion(GalleonProvisioningConfig config) throws ProvisioningException {
        String mavenResolvedVersion = this.getMavenResolvedCoreVersion();
        if (mavenResolvedVersion != null) {
            return mavenResolvedVersion;
        }
        Path tmp = GalleonBuilder.getTmpDirectory();
        try {
            String coreVersion = APIVersion.getVersion();
            for (GalleonFeaturePackConfig fp : config.getFeaturePackDeps()) {
                LocalFP local = this.locals.get(fp.getLocation().getFPID());
                Path resolvedFP = local == null ? this.getUniverseResolver().resolve(fp.getLocation()) : local.getPath();
                try {
                    coreVersion = ProvisioningUtil.getCoreVersion(resolvedFP, coreVersion, tmp, this.getUniverseResolver());
                }
                catch (Exception ex) {
                    throw new ProvisioningException(ex);
                }
            }
            GalleonBuilder.checkArtifactResolver(coreVersion, this.getUniverseResolver());
            String string = coreVersion;
            return string;
        }
        finally {
            IoUtils.recursiveDelete(tmp);
        }
    }

    private static void checkArtifactResolver(String coreVersion, UniverseResolver universeResolver) throws ProvisioningException {
        if (!APIVersion.getVersion().equals(coreVersion)) {
            try {
                GalleonBuilder.getArtifactResolver(universeResolver);
            }
            catch (ProvisioningException ex) {
                throw new ProvisioningException("No maven artifact resolver specified in universe, the Galleon core library can't be resolved");
            }
        }
    }

    private static RepositoryArtifactResolver getArtifactResolver(UniverseResolver universeResolver) throws ProvisioningException {
        return universeResolver.getArtifactResolver("repository.maven");
    }

    private static boolean hasMavenArtifactResolver(UniverseResolver universeResolver) throws ProvisioningException {
        return universeResolver.hasArtifactResolver("repository.maven");
    }

    private static Path getTmpDirectory() throws ProvisioningException {
        try {
            return Files.createTempDirectory("galleon-tmp", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new ProvisioningException(ex);
        }
    }

    static synchronized void releaseUsage(String version) throws ProvisioningException {
        ClassLoaderUsage usage = classLoaders.get(version);
        if (usage == null) {
            throw new ProvisioningException("Releasing usage of core " + version + " although no usage");
        }
        if (usage.num <= 0) {
            throw new ProvisioningException("Releasing usage of core " + version + " although all usages released");
        }
        --usage.num;
        if (usage.num == 0) {
            try {
                usage.loader.close();
            }
            catch (IOException ex) {
                throw new ProvisioningException(ex);
            }
            classLoaders.remove(version);
        }
    }

    static Map<String, ClassLoaderUsage> getClassLoaders() {
        return Collections.unmodifiableMap(classLoaders);
    }

    private static synchronized ClassLoaderUsage addDefaultCoreClassLoader() throws ProvisioningException {
        String apiVersion = APIVersion.getVersion();
        try {
            Path corePath = Files.createTempDirectory("galleon-core-default-base-dir", new FileAttribute[0]);
            corePath.toFile().deleteOnExit();
            File defaultCore = corePath.resolve("galleon-core.jar").toFile();
            try (InputStream input = ProvisioningImpl.class.getClassLoader().getResourceAsStream("galleon-core-" + apiVersion + ".jar");
                 FileOutputStream output = new FileOutputStream(defaultCore, false);){
                input.transferTo(output);
            }
            defaultCore.deleteOnExit();
            URL[] cp = new URL[1];
            ClassLoaderUsage usage = new ClassLoaderUsage();
            try {
                cp[0] = defaultCore.toURI().toURL();
                usage.loader = new URLClassLoader(cp, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception ex) {
                throw new ProvisioningException(ex);
            }
            classLoaders.put(apiVersion, usage);
            return usage;
        }
        catch (IOException ex) {
            throw new ProvisioningException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static synchronized URLClassLoader getCallerClassLoader(String version, UniverseResolver universeResolver) throws ProvisioningException {
        ClassLoaderUsage usage = classLoaders.get(version);
        if (usage == null) {
            Path path;
            if (APIVersion.getVersion().equals(version)) {
                usage = GalleonBuilder.addDefaultCoreClassLoader();
                return usage.loader;
            }
            RepositoryArtifactResolver repoManager = universeResolver.getArtifactResolver("repository.maven");
            usage = new ClassLoaderUsage();
            String loc = "org.jboss.galleon:galleon-core:jar:" + version;
            try {
                path = repoManager.resolve(loc);
            }
            catch (MavenUniverseException ex) {
                throw new ProvisioningException(ex);
            }
            classLoaders.put(version, usage);
            URL[] cp = new URL[1];
            try {
                cp[0] = path.toFile().toURI().toURL();
                usage.loader = new URLClassLoader(cp, Thread.currentThread().getContextClassLoader());
                return usage.loader;
            }
            catch (Exception ex) {
                throw new ProvisioningException(ex);
            }
        }
        ++usage.num;
        return usage.loader;
    }

    private static class ClassLoaderUsage {
        int num = 1;
        URLClassLoader loader;

        private ClassLoaderUsage() {
        }
    }
}

