/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.SessionID;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

class ProvSSLSessionContext
implements SSLSessionContext {
    private static final Logger LOG = Logger.getLogger(ProvSSLSessionContext.class.getName());
    private static final int provSessionCacheSize = PropertyUtils.getIntegerSystemProperty("javax.net.ssl.sessionCacheSize", 20480, 0, Integer.MAX_VALUE);
    protected final Map<SessionID, SessionEntry> sessionsByID = new LinkedHashMap<SessionID, SessionEntry>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SessionID, SessionEntry> entry) {
            boolean bl;
            boolean bl2 = bl = ProvSSLSessionContext.this.sessionCacheSize > 0 && this.size() > ProvSSLSessionContext.this.sessionCacheSize;
            if (bl) {
                ProvSSLSessionContext.this.removeSessionByPeer(entry.getValue());
            }
            return bl;
        }
    };
    protected final Map<String, SessionEntry> sessionsByPeer = new HashMap<String, SessionEntry>();
    protected final ReferenceQueue<ProvSSLSession> sessionsQueue = new ReferenceQueue();
    protected final ContextData contextData;
    protected int sessionCacheSize = provSessionCacheSize;
    protected int sessionTimeoutSeconds = 86400;

    ProvSSLSessionContext(ContextData contextData) {
        this.contextData = contextData;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.contextData.getContext();
    }

    JcaTlsCrypto getCrypto() {
        return this.contextData.getCrypto();
    }

    synchronized ProvSSLSession getSessionImpl(byte[] byArray) {
        this.processQueue();
        return this.accessSession(ProvSSLSessionContext.mapGet(this.sessionsByID, ProvSSLSessionContext.makeSessionID(byArray)));
    }

    synchronized ProvSSLSession getSessionImpl(String string, int n) {
        this.processQueue();
        SessionEntry sessionEntry = ProvSSLSessionContext.mapGet(this.sessionsByPeer, ProvSSLSessionContext.makePeerKey(string, n));
        ProvSSLSession provSSLSession = this.accessSession(sessionEntry);
        if (provSSLSession != null) {
            this.sessionsByID.get(sessionEntry.getSessionID());
        }
        return provSSLSession;
    }

    synchronized void removeSession(byte[] byArray) {
        SessionEntry sessionEntry = ProvSSLSessionContext.mapRemove(this.sessionsByID, ProvSSLSessionContext.makeSessionID(byArray));
        if (null != sessionEntry) {
            this.removeSessionByPeer(sessionEntry);
        }
    }

    synchronized ProvSSLSession reportSession(String string, int n, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters, boolean bl) {
        ProvSSLSession provSSLSession;
        this.processQueue();
        if (!bl) {
            return new ProvSSLSession(this, string, n, tlsSession, jsseSessionParameters);
        }
        SessionID sessionID = ProvSSLSessionContext.makeSessionID(tlsSession.getSessionID());
        SessionEntry sessionEntry = ProvSSLSessionContext.mapGet(this.sessionsByID, sessionID);
        ProvSSLSession provSSLSession2 = provSSLSession = sessionEntry == null ? null : (ProvSSLSession)sessionEntry.get();
        if (null == provSSLSession || provSSLSession.getTlsSession() != tlsSession) {
            provSSLSession = new ProvSSLSession(this, string, n, tlsSession, jsseSessionParameters);
            if (null != sessionID) {
                sessionEntry = new SessionEntry(sessionID, provSSLSession, this.sessionsQueue);
                this.sessionsByID.put(sessionID, sessionEntry);
            }
        }
        if (null != sessionEntry) {
            ProvSSLSessionContext.mapAdd(this.sessionsByPeer, sessionEntry.getPeerKey(), sessionEntry);
        }
        return provSSLSession;
    }

    @Override
    public synchronized Enumeration<byte[]> getIds() {
        this.removeAllExpiredSessions();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(this.sessionsByID.size());
        for (SessionID sessionID : this.sessionsByID.keySet()) {
            arrayList.add(sessionID.getBytes());
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'sessionID' cannot be null");
        }
        return this.getSessionImpl(byArray);
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeoutSeconds;
    }

    @Override
    public synchronized void setSessionCacheSize(int n) throws IllegalArgumentException {
        int n2;
        if (this.sessionCacheSize == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = n;
        this.removeAllExpiredSessions();
        if (this.sessionCacheSize > 0 && (n2 = this.sessionsByID.size()) > this.sessionCacheSize) {
            Iterator<SessionEntry> iterator2 = this.sessionsByID.values().iterator();
            while (iterator2.hasNext() && n2 > this.sessionCacheSize) {
                SessionEntry sessionEntry = iterator2.next();
                iterator2.remove();
                this.removeSessionByPeer(sessionEntry);
                --n2;
            }
        }
    }

    @Override
    public synchronized void setSessionTimeout(int n) throws IllegalArgumentException {
        if (this.sessionTimeoutSeconds == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeoutSeconds = n;
        this.removeAllExpiredSessions();
    }

    private ProvSSLSession accessSession(SessionEntry sessionEntry) {
        if (sessionEntry != null) {
            long l;
            ProvSSLSession provSSLSession = (ProvSSLSession)sessionEntry.get();
            if (provSSLSession != null && !this.invalidateIfCreatedBefore(sessionEntry, this.getCreationTimeLimit(l = System.currentTimeMillis()))) {
                provSSLSession.accessedAt(l);
                return provSSLSession;
            }
            this.removeSession(sessionEntry);
        }
        return null;
    }

    private long getCreationTimeLimit(long l) {
        return this.sessionTimeoutSeconds < 1 ? Long.MIN_VALUE : l - 1000L * (long)this.sessionTimeoutSeconds;
    }

    private boolean invalidateIfCreatedBefore(SessionEntry sessionEntry, long l) {
        ProvSSLSession provSSLSession = (ProvSSLSession)sessionEntry.get();
        if (provSSLSession == null) {
            return true;
        }
        if (provSSLSession.getCreationTime() < l) {
            provSSLSession.invalidatedBySessionContext();
        }
        return !provSSLSession.isValid();
    }

    private void processQueue() {
        SessionEntry sessionEntry;
        int n = 0;
        while ((sessionEntry = (SessionEntry)this.sessionsQueue.poll()) != null) {
            this.removeSession(sessionEntry);
            ++n;
        }
        if (n > 0) {
            LOG.fine("Processed " + n + " session entries (soft references) from the reference queue");
        }
    }

    private void removeAllExpiredSessions() {
        this.processQueue();
        long l = this.getCreationTimeLimit(System.currentTimeMillis());
        Iterator<SessionEntry> iterator2 = this.sessionsByID.values().iterator();
        while (iterator2.hasNext()) {
            SessionEntry sessionEntry = iterator2.next();
            if (!this.invalidateIfCreatedBefore(sessionEntry, l)) continue;
            iterator2.remove();
            this.removeSessionByPeer(sessionEntry);
        }
    }

    private void removeSession(SessionEntry sessionEntry) {
        ProvSSLSessionContext.mapRemove(this.sessionsByID, sessionEntry.getSessionID(), sessionEntry);
        this.removeSessionByPeer(sessionEntry);
    }

    private boolean removeSessionByPeer(SessionEntry sessionEntry) {
        return ProvSSLSessionContext.mapRemove(this.sessionsByPeer, sessionEntry.getPeerKey(), sessionEntry);
    }

    private static String makePeerKey(ProvSSLSession provSSLSession) {
        return provSSLSession == null ? null : ProvSSLSessionContext.makePeerKey(provSSLSession.getPeerHost(), provSSLSession.getPeerPort());
    }

    private static String makePeerKey(String string, int n) {
        return string == null || n < 0 ? null : (string + ':' + Integer.toString(n)).toLowerCase(Locale.ENGLISH);
    }

    private static SessionID makeSessionID(byte[] byArray) {
        return TlsUtils.isNullOrEmpty(byArray) ? null : new SessionID(byArray);
    }

    private static <K, V> void mapAdd(Map<K, V> map, K k, V v) {
        if (map == null || v == null) {
            throw new NullPointerException();
        }
        if (k != null) {
            map.put(k, v);
        }
    }

    private static <K, V> V mapGet(Map<K, V> map, K k) {
        if (map == null) {
            throw new NullPointerException();
        }
        return k == null ? null : (V)map.get(k);
    }

    private static <K, V> V mapRemove(Map<K, V> map, K k) {
        if (map == null) {
            throw new NullPointerException();
        }
        return k == null ? null : (V)map.remove(k);
    }

    private static <K, V> boolean mapRemove(Map<K, V> map, K k, V v) {
        if (map == null || v == null) {
            throw new NullPointerException();
        }
        if (k != null) {
            V v2 = map.remove(k);
            if (v2 == v) {
                return true;
            }
            if (v2 != null) {
                map.put(k, v2);
            }
        }
        return false;
    }

    private static final class SessionEntry
    extends SoftReference<ProvSSLSession> {
        private final SessionID sessionID;
        private final String peerKey;

        SessionEntry(SessionID sessionID, ProvSSLSession provSSLSession, ReferenceQueue<ProvSSLSession> referenceQueue) {
            super(provSSLSession, referenceQueue);
            if (sessionID == null || provSSLSession == null || referenceQueue == null) {
                throw new NullPointerException();
            }
            this.sessionID = sessionID;
            this.peerKey = ProvSSLSessionContext.makePeerKey(provSSLSession);
        }

        public String getPeerKey() {
            return this.peerKey;
        }

        public SessionID getSessionID() {
            return this.sessionID;
        }
    }
}

