/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import io.quarkus.opentelemetry.runtime.config.build.SamplerType;
import java.util.Arrays;
import java.util.List;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class TracingOptions {
    public static final Option<Boolean> TRACING_ENABLED = new OptionBuilder<Boolean>("tracing-enabled", Boolean.class).category(OptionCategory.TRACING).description("Enables the OpenTelemetry tracing.").defaultValue(Boolean.FALSE).buildTime(true).build();
    public static final Option<String> TRACING_ENDPOINT = new OptionBuilder<String>("tracing-endpoint", String.class).category(OptionCategory.TRACING).description("OpenTelemetry endpoint to connect to.").defaultValue("http://localhost:4317").build();
    public static final Option<Boolean> TRACING_JDBC_ENABLED = new OptionBuilder<Boolean>("tracing-jdbc-enabled", Boolean.class).category(OptionCategory.TRACING).description("Enables the OpenTelemetry JDBC tracing.").defaultValue(true).buildTime(true).build();
    public static final Option<String> TRACING_SERVICE_NAME = new OptionBuilder<String>("tracing-service-name", String.class).category(OptionCategory.TRACING).description("OpenTelemetry service name. Takes precedence over 'service.name' defined in the 'tracing-resource-attributes' property.").defaultValue("keycloak").build();
    public static final Option<List<String>> TRACING_RESOURCE_ATTRIBUTES = OptionBuilder.listOptionBuilder("tracing-resource-attributes", String.class).category(OptionCategory.TRACING).description("OpenTelemetry resource attributes present in the exported trace to characterize the telemetry producer. Values in format 'key1=val1,key2=val2'. For more information, check the Tracing guide.").build();
    public static final Option<String> TRACING_PROTOCOL = new OptionBuilder<String>("tracing-protocol", String.class).category(OptionCategory.TRACING).description("OpenTelemetry protocol used for the telemetry data.").defaultValue("grpc").expectedValues((String[])new String[]{"grpc", "http/protobuf"}).build();
    public static final Option<String> TRACING_SAMPLER_TYPE = new OptionBuilder<String>("tracing-sampler-type", String.class).category(OptionCategory.TRACING).description("OpenTelemetry sampler to use for tracing.").defaultValue(SamplerType.TRACE_ID_RATIO.getValue()).expectedValues(Arrays.stream(SamplerType.values()).map(SamplerType::getValue).toList()).buildTime(true).build();
    public static final Option<Double> TRACING_SAMPLER_RATIO = new OptionBuilder<Double>("tracing-sampler-ratio", Double.class).category(OptionCategory.TRACING).description("OpenTelemetry sampler ratio. Probability that a span will be sampled. Expected double value in interval [0,1].").defaultValue(1.0).build();
    public static final Option<TracingCompression> TRACING_COMPRESSION = new OptionBuilder<TracingCompression>("tracing-compression", TracingCompression.class).category(OptionCategory.TRACING).description("OpenTelemetry compression method used to compress payloads. If unset, compression is disabled.").defaultValue(TracingCompression.none).build();

    public static enum TracingCompression {
        gzip,
        none;

    }
}

