/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.updater.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.BaseUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Expiration;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.UpdaterFactory;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.helper.MapUpdater;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;

public class UserSessionUpdater
extends BaseUpdater<String, RemoteUserSessionEntity>
implements UserSessionModel {
    private static final Factory ONLINE = new Factory(false);
    private static final Factory OFFLINE = new Factory(true);
    private final MapUpdater<String, String> notesUpdater;
    private final List<Consumer<RemoteUserSessionEntity>> changes;
    private final boolean offline;
    private RealmModel realm;
    private UserModel user;
    private Map<String, AuthenticatedClientSessionModel> clientSessions;
    private UserSessionModel.SessionPersistenceState persistenceState = UserSessionModel.SessionPersistenceState.PERSISTENT;

    private UserSessionUpdater(String cacheKey, RemoteUserSessionEntity cacheValue, long version, boolean offline, BaseUpdater.UpdaterState initialState) {
        super(cacheKey, cacheValue, version, initialState);
        this.offline = offline;
        if (cacheValue == null) {
            assert (initialState == BaseUpdater.UpdaterState.DELETED);
            this.changes = List.of();
            this.notesUpdater = null;
            return;
        }
        UserSessionUpdater.initNotes(cacheValue);
        this.notesUpdater = new MapUpdater<String, String>(cacheValue.getNotes());
        this.changes = new ArrayList<Consumer<RemoteUserSessionEntity>>(4);
    }

    public static UpdaterFactory<String, RemoteUserSessionEntity, UserSessionUpdater> onlineFactory() {
        return ONLINE;
    }

    public static UpdaterFactory<String, RemoteUserSessionEntity, UserSessionUpdater> offlineFactory() {
        return OFFLINE;
    }

    @Override
    public RemoteUserSessionEntity apply(String ignored, RemoteUserSessionEntity userSessionEntity) {
        UserSessionUpdater.initNotes(userSessionEntity);
        this.changes.forEach(change -> change.accept(userSessionEntity));
        this.notesUpdater.applyChanges(userSessionEntity.getNotes());
        return userSessionEntity;
    }

    @Override
    public Expiration computeExpiration() {
        long maxIdle = SessionTimeouts.getUserSessionMaxIdleMs(this.realm, this.isOffline(), ((RemoteUserSessionEntity)this.getValue()).isRememberMe(), ((RemoteUserSessionEntity)this.getValue()).getLastSessionRefresh());
        long lifespan = SessionTimeouts.getUserSessionLifespanMs(this.realm, this.isOffline(), ((RemoteUserSessionEntity)this.getValue()).isRememberMe(), ((RemoteUserSessionEntity)this.getValue()).getStarted());
        return new Expiration(maxIdle, lifespan);
    }

    public String getId() {
        return (String)this.getKey();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getBrokerSessionId() {
        return ((RemoteUserSessionEntity)this.getValue()).getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return ((RemoteUserSessionEntity)this.getValue()).getBrokerUserId();
    }

    public UserModel getUser() {
        return this.user;
    }

    public String getLoginUsername() {
        return ((RemoteUserSessionEntity)this.getValue()).getLoginUsername();
    }

    public String getIpAddress() {
        return ((RemoteUserSessionEntity)this.getValue()).getIpAddress();
    }

    public String getAuthMethod() {
        return ((RemoteUserSessionEntity)this.getValue()).getAuthMethod();
    }

    public boolean isRememberMe() {
        return ((RemoteUserSessionEntity)this.getValue()).isRememberMe();
    }

    public int getStarted() {
        return ((RemoteUserSessionEntity)this.getValue()).getStarted();
    }

    public int getLastSessionRefresh() {
        return ((RemoteUserSessionEntity)this.getValue()).getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        this.addAndApplyChange(userSessionEntity -> userSessionEntity.setLastSessionRefresh(seconds));
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
        return this.clientSessions;
    }

    public void removeAuthenticatedClientSessions(Collection<String> removedClientUUIDS) {
        if (removedClientUUIDS == null || removedClientUUIDS.isEmpty()) {
            return;
        }
        removedClientUUIDS.forEach(this.clientSessions::remove);
    }

    public AuthenticatedClientSessionModel getAuthenticatedClientSessionByClient(String clientUUID) {
        return this.clientSessions.get(clientUUID);
    }

    public String getNote(String name) {
        return this.notesUpdater.get(name);
    }

    public void setNote(String name, String value) {
        if (value == null) {
            this.removeNote(name);
        } else {
            this.notesUpdater.put(name, value);
        }
    }

    public void removeNote(String name) {
        this.notesUpdater.remove(name);
    }

    public Map<String, String> getNotes() {
        return this.notesUpdater;
    }

    public UserSessionModel.State getState() {
        return ((RemoteUserSessionEntity)this.getValue()).getState();
    }

    public void setState(UserSessionModel.State state) {
        this.addAndApplyChange(userSessionEntity -> userSessionEntity.setState(state));
    }

    public void restartSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        this.realm = realm;
        this.user = user;
        this.changes.clear();
        this.notesUpdater.clear();
        this.clientSessions.clear();
        this.addAndApplyChange(userSessionEntity -> userSessionEntity.restart(realm.getId(), user.getId(), loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId));
    }

    public UserSessionModel.SessionPersistenceState getPersistenceState() {
        return this.persistenceState;
    }

    @Override
    public boolean isTransient() {
        return !this.isDeleted() && this.persistenceState == UserSessionModel.SessionPersistenceState.TRANSIENT;
    }

    @Override
    protected boolean isUnchanged() {
        return this.changes.isEmpty() && this.notesUpdater.isUnchanged();
    }

    public synchronized void initialize(UserSessionModel.SessionPersistenceState persistenceState, RealmModel realm, UserModel user, Map<String, AuthenticatedClientSessionModel> clientSessions) {
        this.realm = Objects.requireNonNull(realm);
        this.user = Objects.requireNonNull(user);
        this.persistenceState = Objects.requireNonNull(persistenceState);
        this.clientSessions = Objects.requireNonNull(clientSessions);
    }

    public synchronized boolean isInitialized() {
        return this.realm != null;
    }

    private void addAndApplyChange(Consumer<RemoteUserSessionEntity> change) {
        change.accept((RemoteUserSessionEntity)this.getValue());
        this.changes.add(change);
    }

    private static void initNotes(RemoteUserSessionEntity entity) {
        Map<String, String> notes = entity.getNotes();
        if (notes == null) {
            entity.setNotes(new HashMap<String, String>());
        }
    }

    private record Factory(boolean offline) implements UpdaterFactory<String, RemoteUserSessionEntity, UserSessionUpdater>
    {
        @Override
        public UserSessionUpdater create(String key, RemoteUserSessionEntity entity) {
            return new UserSessionUpdater(key, Objects.requireNonNull(entity), -1L, this.offline, BaseUpdater.UpdaterState.CREATED);
        }

        @Override
        public UserSessionUpdater wrapFromCache(String key, RemoteUserSessionEntity value, long version) {
            return new UserSessionUpdater(key, value, version, this.offline, BaseUpdater.UpdaterState.READ);
        }

        @Override
        public UserSessionUpdater deleted(String key) {
            return new UserSessionUpdater(key, null, -1L, this.offline, BaseUpdater.UpdaterState.DELETED);
        }
    }
}

