/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractInvocationContext;
import org.infinispan.remoting.transport.Address;

public class NonTxInvocationContext
extends AbstractInvocationContext {
    private static final int INITIAL_CAPACITY = 4;
    private final Map<Object, CacheEntry> lookedUpEntries;
    private Set<Object> lockedKeys;
    private Object lockOwner;

    public NonTxInvocationContext(int numEntries, Address origin) {
        super(origin);
        this.lookedUpEntries = new HashMap<Object, CacheEntry>(numEntries);
    }

    public NonTxInvocationContext(Address origin) {
        super(origin);
        this.lookedUpEntries = new HashMap<Object, CacheEntry>(4);
    }

    @Override
    public CacheEntry lookupEntry(Object k) {
        return this.lookedUpEntries.get(k);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.lookedUpEntries.remove(key);
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? Collections.emptyMap() : this.lookedUpEntries;
    }

    @Override
    public void forEachEntry(BiConsumer<Object, CacheEntry> action) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.forEach(action);
        }
    }

    @Override
    public int lookedUpEntriesCount() {
        return this.lookedUpEntries != null ? this.lookedUpEntries.size() : 0;
    }

    @Override
    public boolean isInTxScope() {
        return false;
    }

    @Override
    public Object getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public void setLockOwner(Object lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public NonTxInvocationContext clone() {
        NonTxInvocationContext dolly = (NonTxInvocationContext)super.clone();
        dolly.lookedUpEntries.putAll(this.lookedUpEntries);
        return dolly;
    }

    @Override
    public void addLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = new HashSet<Object>(4);
        }
        this.lockedKeys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? Collections.emptySet() : this.lockedKeys;
    }

    @Override
    public void clearLockedKeys() {
        this.lockedKeys = null;
    }
}

