/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class TableRowHeightStep
extends IterateVisualProcessStep {
    private FastStack tableStack = new FastStack();
    private TableInfoStructure currentTable;
    private long shiftDistance;

    public void compute(LogicalPageBox logicalPageBox) {
        this.tableStack.clear();
        this.currentTable = null;
        this.shiftDistance = 0L;
        this.startProcessing(logicalPageBox);
        this.shiftDistance = 0L;
        this.tableStack.clear();
        this.currentTable = null;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        this.processBoxChilds(paragraphRenderBox);
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox renderBox) {
        renderBox.setY(renderBox.getY() + this.shiftDistance);
        return true;
    }

    @Override
    protected void processInlineLevelNode(RenderNode renderNode) {
        renderNode.setY(renderNode.getY() + this.shiftDistance);
    }

    @Override
    protected void processBlockLevelNode(RenderNode renderNode) {
        renderNode.setY(renderNode.getY() + this.shiftDistance);
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox renderBox) {
        renderBox.setY(renderBox.getY() + this.shiftDistance);
        if (renderBox instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)renderBox;
            this.currentTable = new TableInfoStructure(tableRenderBox);
            this.currentTable.setPosition(tableRenderBox.getY());
            this.tableStack.push((Object)this.currentTable);
        } else if (renderBox instanceof TableSectionRenderBox) {
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)renderBox;
            this.currentTable.setRowModel(tableSectionRenderBox.getRowModel());
        }
        return true;
    }

    @Override
    protected void finishBlockLevelBox(RenderBox renderBox) {
        if (renderBox instanceof TableCellRenderBox) {
            TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)renderBox;
            int n = tableCellRenderBox.getRowSpan();
            this.currentTable.getRow().updateValidatedSize(n, 0L, tableCellRenderBox.getHeight());
        } else if (renderBox instanceof TableRowRenderBox) {
            this.currentTable.increaseRowNumber();
        } else if (renderBox instanceof TableSectionRenderBox) {
            this.finishSection((TableSectionRenderBox)renderBox);
            this.currentTable.setRowModel(null);
        } else if (renderBox instanceof TableRenderBox) {
            long l = renderBox.getHeight();
            long l2 = this.currentTable.getPosition() - renderBox.getY();
            renderBox.setHeight(l2);
            this.tableStack.pop();
            if (!this.tableStack.isEmpty()) {
                this.currentTable = (TableInfoStructure)this.tableStack.peek();
            }
            long l3 = l2 - l;
            this.shiftDistance += l3;
        }
    }

    protected void finishSection(TableSectionRenderBox tableSectionRenderBox) {
        TableRowModel tableRowModel = tableSectionRenderBox.getRowModel();
        tableRowModel.validateActualSizes();
        long l = this.currentTable.getPosition();
        TableRow[] tableRowArray = tableRowModel.getRows();
        RenderNode renderNode = tableSectionRenderBox.getFirstChild();
        boolean bl = true;
        while (renderNode != null) {
            if (!(renderNode instanceof TableRowRenderBox)) {
                renderNode = renderNode.getNext();
                continue;
            }
            if (!renderNode.isDirty()) {
                throw new IllegalStateException("The row is not dirty?");
            }
            TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)renderNode;
            int n = tableRowRenderBox.getRowInfoStructure().getRowNumber();
            TableRow tableRow = tableRowArray[n];
            long l2 = tableRow.getValidateSize();
            if (bl) {
                bl = false;
            } else {
                l += tableRowModel.getRowSpacing();
            }
            long l3 = tableRowRenderBox.getY();
            long l4 = l - l3;
            if (l4 < 0L) {
                throw new IllegalStateException("Shift-back is not allowed.");
            }
            this.shift(tableRowRenderBox, l4);
            this.shiftDistance += l4;
            RenderNode renderNode2 = tableRowRenderBox.getFirstChild();
            while (renderNode2 != null) {
                if (!(renderNode2 instanceof TableCellRenderBox)) {
                    renderNode2 = renderNode2.getNext();
                    continue;
                }
                TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)renderNode2;
                long l5 = l - tableCellRenderBox.getY();
                if (l5 != 0L) {
                    this.shift(tableCellRenderBox, l5);
                }
                tableCellRenderBox.setHeight(l2);
                renderNode2 = renderNode2.getNext();
            }
            tableRowRenderBox.setHeight(l2);
            tableRowRenderBox.setDirty(false);
            l += l2;
            renderNode = renderNode.getNext();
        }
        long l6 = l - tableSectionRenderBox.getY();
        long l7 = l6 - tableSectionRenderBox.getHeight();
        tableSectionRenderBox.setHeight(l6);
        if (l7 != 0L) {
            for (RenderBox renderBox = tableSectionRenderBox.getParent(); renderBox != null; renderBox = renderBox.getParent()) {
                renderBox.setHeight(renderBox.getHeight() + l7);
            }
            this.shiftDistance += l7;
        }
        this.currentTable.setPosition(l);
    }

    private void shift(RenderNode renderNode, long l) {
        if (l == 0L) {
            return;
        }
        long l2 = renderNode.getY();
        renderNode.setY(l2 + l);
        if (!(renderNode instanceof RenderBox)) {
            return;
        }
        RenderBox renderBox = (RenderBox)renderNode;
        for (RenderNode renderNode2 = renderBox.getFirstChild(); renderNode2 != null; renderNode2 = renderNode2.getNext()) {
            this.shift(renderNode2, l);
        }
    }

    public static class TableInfoStructure {
        private TableRenderBox table;
        private TableColumnModel columnModel;
        private TableRowModel rowModel;
        private int rowNumber;
        private long position;

        public TableInfoStructure(TableRenderBox tableRenderBox) {
            this.table = tableRenderBox;
            this.columnModel = tableRenderBox.getColumnModel();
        }

        public TableRow getRow() {
            return this.rowModel.getRow(this.rowNumber);
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long l) {
            this.position = l;
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public TableRowModel getRowModel() {
            return this.rowModel;
        }

        public void setRowModel(TableRowModel tableRowModel) {
            this.rowModel = tableRowModel;
            this.rowNumber = 0;
        }

        public int getRowNumber() {
            return this.rowNumber;
        }

        public void increaseRowNumber() {
            ++this.rowNumber;
        }
    }
}

