/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nokogiri.XmlDocument;
import nokogiri.XmlDtd;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriDomParser;
import nokogiri.internals.NokogiriEntityResolver;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNonStrictErrorHandler;
import nokogiri.internals.NokogiriStrictErrorHandler;
import nokogiri.internals.ParserContext;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.SecurityManager;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlDomParserContext
extends ParserContext {
    private static final long serialVersionUID = 1L;
    protected static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String FEATURE_LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    protected static final String FEATURE_INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String FEATURE_NOT_EXPAND_ENTITY = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String FEATURE_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    protected ParserContext.Options options;
    protected DOMParser parser;
    protected NokogiriErrorHandler errorHandler;
    protected IRubyObject ruby_encoding;

    public XmlDomParserContext(Ruby ruby, IRubyObject iRubyObject) {
        this(ruby, ruby.getNil(), iRubyObject);
    }

    public XmlDomParserContext(Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        super(ruby);
        this.options = new ParserContext.Options(RubyFixnum.fix2long((IRubyObject)iRubyObject2));
        this.java_encoding = NokogiriHelpers.getValidEncodingOrNull(iRubyObject);
        this.ruby_encoding = iRubyObject;
        this.initErrorHandler(ruby);
        this.initParser(ruby);
    }

    protected void initErrorHandler(Ruby ruby) {
        this.errorHandler = this.options.recover ? new NokogiriNonStrictErrorHandler(ruby, this.options.noError, this.options.noWarning) : new NokogiriStrictErrorHandler(ruby, this.options.noError, this.options.noWarning);
    }

    protected void initParser(Ruby ruby) {
        if (this.options.xInclude) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XIncludeParserConfiguration");
        }
        this.parser = new NokogiriDomParser(this.options);
        this.parser.setErrorHandler((ErrorHandler)this.errorHandler);
        this.setProperty(SECURITY_MANAGER, new SecurityManager());
        this.setFeature(FEATURE_INCLUDE_IGNORABLE_WHITESPACE, !this.options.noBlanks);
        this.setFeature(CONTINUE_AFTER_FATAL_ERROR, this.options.recover);
        this.setFeature(FEATURE_VALIDATION, this.options.dtdValid);
        this.setFeature(FEATURE_NOT_EXPAND_ENTITY, !this.options.noEnt);
        this.setFeature(FEATURE_LOAD_EXTERNAL_DTD, this.options.dtdLoad);
        this.setFeature(FEATURE_LOAD_DTD_GRAMMAR, this.options.dtdLoad);
        this.parser.setEntityResolver((EntityResolver)new NokogiriEntityResolver(ruby, this.errorHandler, this.options));
    }

    protected void setFeature(String string, boolean bl) {
        try {
            this.parser.setFeature(string, bl);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void setProperty(String string, Object object) {
        try {
            this.parser.setProperty(string, object);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void addErrorsIfNecessary(ThreadContext threadContext, XmlDocument xmlDocument) {
        xmlDocument.setInstanceVariable("@errors", (IRubyObject)XmlDomParserContext.mapErrors(threadContext, this.errorHandler));
    }

    public static RubyArray<?> mapErrors(ThreadContext threadContext, NokogiriErrorHandler nokogiriErrorHandler) {
        Ruby ruby = threadContext.runtime;
        List<RubyException> list = nokogiriErrorHandler.getErrors();
        IRubyObject[] iRubyObjectArray = new IRubyObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iRubyObjectArray[i] = (IRubyObject)list.get(i);
        }
        return ruby.newArrayNoCopy(iRubyObjectArray);
    }

    public XmlDocument getDocumentWithErrorsOrRaiseException(ThreadContext threadContext, RubyClass rubyClass, Exception exception) {
        if (this.options.recover) {
            XmlDocument xmlDocument = this.getInterruptedOrNewXmlDocument(threadContext, rubyClass);
            this.addErrorsIfNecessary(threadContext, xmlDocument);
            XmlSyntaxError xmlSyntaxError = XmlSyntaxError.createXMLSyntaxError(threadContext.runtime);
            xmlSyntaxError.setException(exception);
            ((RubyArray)xmlDocument.getInstanceVariable("@errors")).append((IRubyObject)xmlSyntaxError);
            return xmlDocument;
        }
        XmlSyntaxError xmlSyntaxError = XmlSyntaxError.createXMLSyntaxError(threadContext.runtime);
        xmlSyntaxError.setException(exception);
        throw xmlSyntaxError.toThrowable();
    }

    private XmlDocument getInterruptedOrNewXmlDocument(ThreadContext threadContext, RubyClass rubyClass) {
        Document document = this.parser.getDocument();
        XmlDocument xmlDocument = new XmlDocument(threadContext.runtime, rubyClass, document);
        xmlDocument.setEncoding(this.ruby_encoding);
        return xmlDocument;
    }

    protected XmlDocument wrapDocument(ThreadContext threadContext, RubyClass rubyClass, Document document) {
        IRubyObject iRubyObject;
        XmlDocument xmlDocument = new XmlDocument(threadContext.runtime, rubyClass, document);
        Helpers.invoke((ThreadContext)threadContext, (IRubyObject)xmlDocument, (String)"initialize");
        xmlDocument.setEncoding(this.ruby_encoding);
        if (this.options.dtdLoad && !(iRubyObject = XmlDtd.newFromExternalSubset(threadContext.runtime, document)).isNil()) {
            document.setUserData("DTD_EXTERNAL_SUBSET", (Object)((XmlDtd)iRubyObject), null);
        }
        return xmlDocument;
    }

    public XmlDocument parse(ThreadContext threadContext, RubyClass rubyClass, IRubyObject iRubyObject) {
        try {
            Document document = this.do_parse();
            XmlDocument xmlDocument = this.wrapDocument(threadContext, rubyClass, document);
            xmlDocument.setUrl(iRubyObject);
            this.addErrorsIfNecessary(threadContext, xmlDocument);
            return xmlDocument;
        }
        catch (SAXException sAXException) {
            return this.getDocumentWithErrorsOrRaiseException(threadContext, rubyClass, sAXException);
        }
        catch (IOException iOException) {
            return this.getDocumentWithErrorsOrRaiseException(threadContext, rubyClass, iOException);
        }
    }

    protected Document do_parse() throws SAXException, IOException {
        try {
            this.parser.parse(this.getInputSource());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.options.noBlanks) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            XmlDomParserContext.findEmptyTexts(this.parser.getDocument(), arrayList);
            if (arrayList.size() > 0) {
                for (Node node : arrayList) {
                    node.getParentNode().removeChild(node);
                }
            }
        }
        return this.parser.getDocument();
    }

    private static void findEmptyTexts(Node node, List<Node> list) {
        if (node.getNodeType() == 3 && NokogiriHelpers.isBlank(node.getTextContent())) {
            list.add(node);
        } else {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XmlDomParserContext.findEmptyTexts(nodeList.item(i), list);
            }
        }
    }
}

