/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

public class AutoloadedDriver
implements Driver {
    private static boolean _engineForcedDown = false;
    private static AutoloadedDriver _autoloadedDriver;
    private static Driver _driverModule;

    protected static void registerMe(AutoloadedDriver me) {
        try {
            _autoloadedDriver = me;
            DriverManager.registerDriver(_autoloadedDriver);
        }
        catch (SQLException se) {
            String message = MessageService.getTextMessage((String)"I026", (Object[])new Object[]{se.getMessage()});
            throw new IllegalStateException(message);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return !_engineForcedDown && InternalDriver.embeddedDriverAcceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!InternalDriver.embeddedDriverAcceptsURL(url)) {
            return null;
        }
        return AutoloadedDriver.getDriverModule().connect(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return AutoloadedDriver.getDriverModule().getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMajorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMinorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return AutoloadedDriver.getDriverModule().jdbcCompliant();
        }
        catch (SQLException se) {
            return false;
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.notImplemented("getParentLogger()");
    }

    public static Driver getDriverModule() throws SQLException {
        if (_engineForcedDown && _autoloadedDriver == null) {
            throw Util.generateCsSQLException("08006.C.8", new Object[0]);
        }
        if (!AutoloadedDriver.isBooted()) {
            JDBCBoot.boot();
        }
        return _driverModule;
    }

    public static void registerDriverModule(Driver driver) {
        _driverModule = driver;
        _engineForcedDown = false;
        try {
            if (_autoloadedDriver == null) {
                _autoloadedDriver = AutoloadedDriver.makeAutoloadedDriver();
                DriverManager.registerDriver(_autoloadedDriver);
            }
        }
        catch (SQLException e) {
            SanityManager.THROWASSERT((Throwable)e);
        }
    }

    public static void unregisterDriverModule() {
        _engineForcedDown = true;
        try {
            if (InternalDriver.getDeregister() && _autoloadedDriver != null) {
                AutoloadedDriver.deregisterDriver(_autoloadedDriver);
                _autoloadedDriver = null;
            }
            InternalDriver.setDeregister(true);
            _driverModule = null;
        }
        catch (SQLException e) {
            SanityManager.THROWASSERT((Throwable)e);
        }
    }

    private static void deregisterDriver(final AutoloadedDriver driver) throws SQLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws SQLException {
                    DriverManager.deregisterDriver(driver);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SQLException)pae.getCause();
        }
        catch (AccessControlException ace) {
            Monitor.logTextMessage("J137", new Object[0]);
            Monitor.logThrowable(ace);
        }
    }

    private static boolean isBooted() {
        return _driverModule != null;
    }

    private static AutoloadedDriver makeAutoloadedDriver() {
        return new AutoloadedDriver();
    }

    static {
        AutoloadedDriver.registerMe(new AutoloadedDriver());
    }
}

