/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThanEqual(vec2(-1.5, -1.5), vec2(-1.5, -0.5)) => bvec2(true, true)
 * lessThanEqual(vec2(-1.5, -1.5), vec2(0.5, 1.5)) => bvec2(true, true)
 * lessThanEqual(vec2(-0.5, -0.5), vec2(-1.5, -0.5)) => bvec2(false, true)
 * lessThanEqual(vec2(-0.5, -0.5), vec2(0.5, 1.5)) => bvec2(true, true)
 * lessThanEqual(vec2(0.5, 0.5), vec2(-1.5, -0.5)) => bvec2(false, false)
 * lessThanEqual(vec2(0.5, 0.5), vec2(0.5, 1.5)) => bvec2(true, true)
 * lessThanEqual(vec2(1.5, 1.5), vec2(-1.5, -0.5)) => bvec2(false, false)
 * lessThanEqual(vec2(1.5, 1.5), vec2(0.5, 1.5)) => bvec2(false, true)
 */
#version 120

void main()
{
  float[all(equal(lessThanEqual(vec2(-1.5, -1.5), vec2(-1.5, -0.5)), bvec2(true, true))) ? 1 : -1] array0;
  float[all(equal(lessThanEqual(vec2(-1.5, -1.5), vec2(0.5, 1.5)), bvec2(true, true))) ? 1 : -1] array1;
  float[all(equal(lessThanEqual(vec2(-0.5, -0.5), vec2(-1.5, -0.5)), bvec2(false, true))) ? 1 : -1] array2;
  float[all(equal(lessThanEqual(vec2(-0.5, -0.5), vec2(0.5, 1.5)), bvec2(true, true))) ? 1 : -1] array3;
  float[all(equal(lessThanEqual(vec2(0.5, 0.5), vec2(-1.5, -0.5)), bvec2(false, false))) ? 1 : -1] array4;
  float[all(equal(lessThanEqual(vec2(0.5, 0.5), vec2(0.5, 1.5)), bvec2(true, true))) ? 1 : -1] array5;
  float[all(equal(lessThanEqual(vec2(1.5, 1.5), vec2(-1.5, -0.5)), bvec2(false, false))) ? 1 : -1] array6;
  float[all(equal(lessThanEqual(vec2(1.5, 1.5), vec2(0.5, 1.5)), bvec2(false, true))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
