/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 - ivec3(-36, 32, -88)) => ivec3(48, -20, 100)
 * (12 - ivec3(36, 32, 88)) => ivec3(-24, -20, -76)
 * (12 - ivec3(59, 77, 68)) => ivec3(-47, -65, -56)
 * (-6 - ivec3(-36, 32, -88)) => ivec3(30, -38, 82)
 * (-6 - ivec3(36, 32, 88)) => ivec3(-42, -38, -94)
 * (-6 - ivec3(59, 77, 68)) => ivec3(-65, -83, -74)
 * (76 - ivec3(-36, 32, -88)) => ivec3(112, 44, 164)
 * (76 - ivec3(36, 32, 88)) => ivec3(40, 44, -12)
 * (76 - ivec3(59, 77, 68)) => ivec3(17, -1, 8)
 * (-32 - ivec3(-36, 32, -88)) => ivec3(4, -64, 56)
 * (-32 - ivec3(36, 32, 88)) => ivec3(-68, -64, -120)
 * (-32 - ivec3(59, 77, 68)) => ivec3(-91, -109, -100)
 * (0 - ivec3(-36, 32, -88)) => ivec3(36, -32, 88)
 * (0 - ivec3(36, 32, 88)) => ivec3(-36, -32, -88)
 * (0 - ivec3(59, 77, 68)) => ivec3(-59, -77, -68)
 */
#version 120

void main()
{
  float[all(equal((12 - ivec3(-36, 32, -88)), ivec3(48, -20, 100))) ? 1 : -1] array0;
  float[all(equal((12 - ivec3(36, 32, 88)), ivec3(-24, -20, -76))) ? 1 : -1] array1;
  float[all(equal((12 - ivec3(59, 77, 68)), ivec3(-47, -65, -56))) ? 1 : -1] array2;
  float[all(equal((-6 - ivec3(-36, 32, -88)), ivec3(30, -38, 82))) ? 1 : -1] array3;
  float[all(equal((-6 - ivec3(36, 32, 88)), ivec3(-42, -38, -94))) ? 1 : -1] array4;
  float[all(equal((-6 - ivec3(59, 77, 68)), ivec3(-65, -83, -74))) ? 1 : -1] array5;
  float[all(equal((76 - ivec3(-36, 32, -88)), ivec3(112, 44, 164))) ? 1 : -1] array6;
  float[all(equal((76 - ivec3(36, 32, 88)), ivec3(40, 44, -12))) ? 1 : -1] array7;
  float[all(equal((76 - ivec3(59, 77, 68)), ivec3(17, -1, 8))) ? 1 : -1] array8;
  float[all(equal((-32 - ivec3(-36, 32, -88)), ivec3(4, -64, 56))) ? 1 : -1] array9;
  float[all(equal((-32 - ivec3(36, 32, 88)), ivec3(-68, -64, -120))) ? 1 : -1] array10;
  float[all(equal((-32 - ivec3(59, 77, 68)), ivec3(-91, -109, -100))) ? 1 : -1] array11;
  float[all(equal((0 - ivec3(-36, 32, -88)), ivec3(36, -32, 88))) ? 1 : -1] array12;
  float[all(equal((0 - ivec3(36, 32, 88)), ivec3(-36, -32, -88))) ? 1 : -1] array13;
  float[all(equal((0 - ivec3(59, 77, 68)), ivec3(-59, -77, -68))) ? 1 : -1] array14;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
