/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec2(-0.1, -1.2) - 0.0) => vec2(-0.1, -1.2)
 * (vec2(-0.1, -1.2) - -1.33) => vec2(1.23, 0.13)
 * (vec2(-0.1, -1.2) - 0.85) => vec2(-0.95000005, -2.0500002)
 * (vec2(-0.42, 0.48) - 0.0) => vec2(-0.42, 0.48)
 * (vec2(-0.42, 0.48) - -1.33) => vec2(0.9100001, 1.8100001)
 * (vec2(-0.42, 0.48) - 0.85) => vec2(-1.27, -0.37000003)
 */
#version 120

void main()
{
  float[distance((vec2(-0.1, -1.2) - 0.0), vec2(-0.1, -1.2)) <= 1.2041595e-05 ? 1 : -1] array0;
  float[distance((vec2(-0.1, -1.2) - -1.33), vec2(1.23, 0.13)) <= 1.2368509e-05 ? 1 : -1] array1;
  float[distance((vec2(-0.1, -1.2) - 0.85), vec2(-0.95000005, -2.0500002)) <= 2.2594248e-05 ? 1 : -1] array2;
  float[distance((vec2(-0.42, 0.48) - 0.0), vec2(-0.42, 0.48)) <= 6.378087e-06 ? 1 : -1] array3;
  float[distance((vec2(-0.42, 0.48) - -1.33), vec2(0.9100001, 1.8100001)) <= 2.0258825e-05 ? 1 : -1] array4;
  float[distance((vec2(-0.42, 0.48) - 0.85), vec2(-1.27, -0.37000003)) <= 1.3228001e-05 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
