/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) * 0u) => uvec3(0u, 0u, 0u)
 * (uvec3(36u, 32u, 88u) * 6u) => uvec3(216u, 192u, 528u)
 * (uvec3(36u, 32u, 88u) * 12u) => uvec3(432u, 384u, 1056u)
 * (uvec3(36u, 32u, 88u) * 32u) => uvec3(1152u, 1024u, 2816u)
 * (uvec3(36u, 32u, 88u) * 74u) => uvec3(2664u, 2368u, 6512u)
 * (uvec3(59u, 77u, 68u) * 0u) => uvec3(0u, 0u, 0u)
 * (uvec3(59u, 77u, 68u) * 6u) => uvec3(354u, 462u, 408u)
 * (uvec3(59u, 77u, 68u) * 12u) => uvec3(708u, 924u, 816u)
 * (uvec3(59u, 77u, 68u) * 32u) => uvec3(1888u, 2464u, 2176u)
 * (uvec3(59u, 77u, 68u) * 74u) => uvec3(4366u, 5698u, 5032u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) * 0u), uvec3(0u, 0u, 0u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) * 6u), uvec3(216u, 192u, 528u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) * 12u), uvec3(432u, 384u, 1056u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) * 32u), uvec3(1152u, 1024u, 2816u))) ? 1 : -1] array3;
  float[all(equal((uvec3(36u, 32u, 88u) * 74u), uvec3(2664u, 2368u, 6512u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) * 0u), uvec3(0u, 0u, 0u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) * 6u), uvec3(354u, 462u, 408u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) * 12u), uvec3(708u, 924u, 816u))) ? 1 : -1] array7;
  float[all(equal((uvec3(59u, 77u, 68u) * 32u), uvec3(1888u, 2464u, 2176u))) ? 1 : -1] array8;
  float[all(equal((uvec3(59u, 77u, 68u) * 74u), uvec3(4366u, 5698u, 5032u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
