/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) + uvec3(36u, 32u, 88u)) => uvec3(72u, 64u, 176u)
 * (uvec3(36u, 32u, 88u) + uvec3(59u, 77u, 68u)) => uvec3(95u, 109u, 156u)
 * (uvec3(59u, 77u, 68u) + uvec3(36u, 32u, 88u)) => uvec3(95u, 109u, 156u)
 * (uvec3(59u, 77u, 68u) + uvec3(59u, 77u, 68u)) => uvec3(118u, 154u, 136u)
 */
#version 150

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) + uvec3(36u, 32u, 88u)), uvec3(72u, 64u, 176u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) + uvec3(59u, 77u, 68u)), uvec3(95u, 109u, 156u))) ? 1 : -1] array1;
  float[all(equal((uvec3(59u, 77u, 68u) + uvec3(36u, 32u, 88u)), uvec3(95u, 109u, 156u))) ? 1 : -1] array2;
  float[all(equal((uvec3(59u, 77u, 68u) + uvec3(59u, 77u, 68u)), uvec3(118u, 154u, 136u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
