/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import de.escape.quincunx.gimmicks.LengthUnit;
import de.escape.quincunx.gimmicks.PaperFormat;
import de.escape.quincunx.gimmicks.PhysicalLength;
import java.io.Serializable;

public class BasicPaperFormat
implements PaperFormat,
Serializable {
    public static final PhysicalLength DEFAULT_MARGIN = new PhysicalLength(10.0, LengthUnit.MILLIMETER);
    public static final BasicPaperFormat A4_PAPER_PORTRAIT = new BasicPaperFormat("A4 (portrait)", 210.0, 297.0);
    public static final BasicPaperFormat A4_PAPER_LANDSCAPE = new BasicPaperFormat("A4 (landscape)", 297.0, 210.0);
    public static final BasicPaperFormat A3_PAPER_PORTRAIT = new BasicPaperFormat("A3 (portrait)", 297.0, 420.0);
    public static final BasicPaperFormat A3_PAPER_LANDSCAPE = new BasicPaperFormat("A3 (landscape)", 420.0, 297.0);
    public static final BasicPaperFormat A2_PAPER_PORTRAIT = new BasicPaperFormat("A2 (portrait)", 420.0, 595.0);
    public static final BasicPaperFormat A2_PAPER_LANDSCAPE = new BasicPaperFormat("A2 (landscape)", 595.0, 420.0);
    public static final BasicPaperFormat A1_PAPER_PORTRAIT = new BasicPaperFormat("A1 (portrait)", 595.0, 841.0);
    public static final BasicPaperFormat A1_PAPER_LANDSCAPE = new BasicPaperFormat("A1 (landscape)", 841.0, 595.0);
    public static final BasicPaperFormat A0_PAPER_PORTRAIT = new BasicPaperFormat("A0 (portrait)", 841.0, 1189.0);
    public static final BasicPaperFormat A0_PAPER_LANDSCAPE = new BasicPaperFormat("A0 (landscape)", 1189.0, 841.0);
    public static final BasicPaperFormat B5_PAPER_PORTRAIT = new BasicPaperFormat("B5 (portrait)", 176.0, 250.0);
    public static final BasicPaperFormat B5_PAPER_LANDSCAPE = new BasicPaperFormat("B5 (landscape)", 250.0, 176.0);
    public static final BasicPaperFormat B4_PAPER_PORTRAIT = new BasicPaperFormat("B4 (portrait)", 250.0, 353.0);
    public static final BasicPaperFormat B4_PAPER_LANDSCAPE = new BasicPaperFormat("B4 (landscape)", 353.0, 250.0);
    public static final BasicPaperFormat B3_PAPER_PORTRAIT = new BasicPaperFormat("B3 (portrait)", 353.0, 500.0);
    public static final BasicPaperFormat B3_PAPER_LANDSCAPE = new BasicPaperFormat("B3 (landscape)", 500.0, 353.0);
    public static final BasicPaperFormat B2_PAPER_PORTRAIT = new BasicPaperFormat("B2 (portrait)", 500.0, 707.0);
    public static final BasicPaperFormat B2_PAPER_LANDSCAPE = new BasicPaperFormat("B2 (landscape)", 707.0, 500.0);
    public static final BasicPaperFormat B1_PAPER_PORTRAIT = new BasicPaperFormat("B1 (portrait)", 707.0, 1000.0);
    public static final BasicPaperFormat B1_PAPER_LANDSCAPE = new BasicPaperFormat("B1 (landscape)", 1000.0, 707.0);
    public static final BasicPaperFormat B0_PAPER_PORTRAIT = new BasicPaperFormat("B0 (portrait)", 1000.0, 1414.0);
    public static final BasicPaperFormat B0_PAPER_LANDSCAPE = new BasicPaperFormat("B0 (landscape)", 1414.0, 1000.0);
    public static final BasicPaperFormat LETTER_PAPER_PORTRAIT = new BasicPaperFormat("Letter (portrait)", 216.0, 279.0);
    public static final BasicPaperFormat LETTER_PAPER_LANDSCAPE = new BasicPaperFormat("Letter (landscape)", 279.0, 216.0);
    public static final BasicPaperFormat LEGAL_PAPER_PORTRAIT = new BasicPaperFormat("Legal (portrait)", 216.0, 356.0);
    public static final BasicPaperFormat LEGAL_PAPER_LANDSCAPE = new BasicPaperFormat("Legal (landscape)", 356.0, 216.0);
    public static final BasicPaperFormat EXECUTIVE_PAPER_PORTRAIT = new BasicPaperFormat("Executive (portrait)", 190.0, 254.0);
    public static final BasicPaperFormat EXECUTIVE_PAPER_LANDSCAPE = new BasicPaperFormat("Executive (landscape)", 254.0, 190.0);
    public static final BasicPaperFormat TABLOID_PAPER_PORTRAIT = new BasicPaperFormat("Tabloid (portrait)", 279.0, 432.0);
    public static final BasicPaperFormat TABLOID_PAPER_LANDSCAPE = new BasicPaperFormat("Tabloid (landscape)", 432.0, 279.0);
    private PhysicalLength width;
    private PhysicalLength height;
    private PhysicalLength leftMargin;
    private PhysicalLength rightMargin;
    private PhysicalLength topMargin;
    private PhysicalLength bottomMargin;
    private String name;

    protected BasicPaperFormat(String name, double width, double height) {
        this(new PhysicalLength(width, LengthUnit.MILLIMETER), new PhysicalLength(height, LengthUnit.MILLIMETER), DEFAULT_MARGIN);
        this.name = name;
    }

    public BasicPaperFormat(PhysicalLength width, PhysicalLength height, PhysicalLength margin) {
        this(width, height, margin, margin, margin, margin);
    }

    public BasicPaperFormat(PhysicalLength width, PhysicalLength height, PhysicalLength leftMargin, PhysicalLength rightMargin, PhysicalLength topMargin, PhysicalLength bottomMargin) {
        this.width = width;
        this.height = height;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
    }

    public BasicPaperFormat(PaperFormat pf, PhysicalLength leftMargin, PhysicalLength rightMargin, PhysicalLength topMargin, PhysicalLength bottomMargin) {
        this(pf.getWidth(), pf.getHeight(), leftMargin, rightMargin, topMargin, bottomMargin);
        if (pf instanceof BasicPaperFormat) {
            this.name = ((BasicPaperFormat)pf).name;
        }
    }

    public PhysicalLength getWidth() {
        return this.width;
    }

    public PhysicalLength getHeight() {
        return this.height;
    }

    public PhysicalLength getLeftMargin() {
        return this.leftMargin;
    }

    public PhysicalLength getRightMargin() {
        return this.rightMargin;
    }

    public PhysicalLength getTopMargin() {
        return this.topMargin;
    }

    public PhysicalLength getBottomMargin() {
        return this.bottomMargin;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        BasicPaperFormat other = (BasicPaperFormat)obj;
        return other != null && (this.name == other.name || this.name != null && this.name.equals(other.name)) && this.width.equals(other.width) && this.height.equals(other.height) && this.leftMargin.equals(other.leftMargin) && this.rightMargin.equals(other.rightMargin) && this.topMargin.equals(other.topMargin) && this.bottomMargin.equals(other.bottomMargin);
    }
}

