/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;

public class PPolygon
implements PConstants {
    static final int DEFAULT_SIZE = 64;
    float[][] vertices = new float[64][36];
    int vertexCount;
    float[] r = new float[64];
    float[] dr = new float[64];
    float[] l = new float[64];
    float[] dl = new float[64];
    float[] sp = new float[64];
    float[] sdp = new float[64];
    protected boolean interpX;
    protected boolean interpUV;
    protected boolean interpARGB;
    private int rgba;
    private int r2;
    private int g2;
    private int b2;
    private int a2;
    private int a2orig;
    PGraphics parent;
    int[] pixels;
    int width;
    int height;
    int width1;
    int height1;
    PImage timage;
    int[] tpixels;
    int theight;
    int twidth;
    int theight1;
    int twidth1;
    int tformat;
    static final int SUBXRES = 8;
    static final int SUBXRES1 = 7;
    static final int SUBYRES = 8;
    static final int SUBYRES1 = 7;
    static final int MAX_COVERAGE = 64;
    boolean smooth;
    int firstModY;
    int lastModY;
    int lastY;
    int[] aaleft = new int[8];
    int[] aaright = new int[8];
    int aaleftmin;
    int aarightmin;
    int aaleftmax;
    int aarightmax;
    int aaleftfull;
    int aarightfull;

    private final int MODYRES(int n) {
        return n & 7;
    }

    public PPolygon(PGraphics pGraphics) {
        this.parent = pGraphics;
        this.reset(0);
    }

    protected void reset(int n) {
        this.vertexCount = n;
        this.interpX = true;
        this.interpUV = false;
        this.interpARGB = true;
        this.timage = null;
    }

    protected float[] nextVertex() {
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
            this.r = new float[this.vertices.length];
            this.dr = new float[this.vertices.length];
            this.l = new float[this.vertices.length];
            this.dl = new float[this.vertices.length];
            this.sp = new float[this.vertices.length];
            this.sdp = new float[this.vertices.length];
        }
        return this.vertices[this.vertexCount++];
    }

    protected void texture(PImage pImage) {
        this.timage = pImage;
        if (pImage != null) {
            this.tpixels = pImage.pixels;
            this.twidth = pImage.width;
            this.theight = pImage.height;
            this.tformat = pImage.format;
            this.twidth1 = this.twidth - 1;
            this.theight1 = this.theight - 1;
            this.interpUV = true;
        } else {
            this.interpUV = false;
        }
    }

    protected void renderPolygon(float[][] fArray, int n) {
        this.vertices = fArray;
        this.vertexCount = n;
        if (this.r.length < this.vertexCount) {
            this.r = new float[this.vertexCount];
            this.dr = new float[this.vertexCount];
            this.l = new float[this.vertexCount];
            this.dl = new float[this.vertexCount];
            this.sp = new float[this.vertexCount];
            this.sdp = new float[this.vertexCount];
        }
        this.render();
        this.checkExpand();
    }

    protected void renderTriangle(float[] fArray, float[] fArray2, float[] fArray3) {
        this.vertices[0] = fArray;
        this.vertices[1] = fArray2;
        this.vertices[2] = fArray3;
        this.render();
        this.checkExpand();
    }

    protected void checkExpand() {
        if (this.smooth) {
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray = this.vertices[i];
                fArray[18] = fArray[18] / 8.0f;
                float[] fArray2 = this.vertices[i];
                fArray2[19] = fArray2[19] / 8.0f;
            }
        }
    }

    protected void render() {
        int n;
        int n2;
        if (this.vertexCount < 3) {
            return;
        }
        this.pixels = this.parent.pixels;
        this.smooth = this.parent.smooth;
        this.width = this.smooth ? this.parent.width * 8 : this.parent.width;
        this.height = this.smooth ? this.parent.height * 8 : this.parent.height;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        if (!this.interpARGB) {
            this.r2 = (int)(this.vertices[0][3] * 255.0f);
            this.g2 = (int)(this.vertices[0][4] * 255.0f);
            this.b2 = (int)(this.vertices[0][5] * 255.0f);
            this.a2orig = this.a2 = (int)(this.vertices[0][6] * 255.0f);
            this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
        }
        for (n2 = 0; n2 < this.vertexCount; ++n2) {
            this.r[n2] = 0.0f;
            this.dr[n2] = 0.0f;
            this.l[n2] = 0.0f;
            this.dl[n2] = 0.0f;
        }
        if (this.smooth) {
            for (n2 = 0; n2 < this.vertexCount; ++n2) {
                float[] fArray = this.vertices[n2];
                fArray[18] = fArray[18] * 8.0f;
                float[] fArray2 = this.vertices[n2];
                fArray2[19] = fArray2[19] * 8.0f;
            }
            this.firstModY = -1;
        }
        n2 = 0;
        float f = this.vertices[0][19];
        float f2 = this.vertices[0][19];
        for (n = 1; n < this.vertexCount; ++n) {
            if (this.vertices[n][19] < f) {
                f = this.vertices[n][19];
                n2 = n;
            }
            if (!(this.vertices[n][19] > f2)) continue;
            f2 = this.vertices[n][19];
        }
        this.lastY = (int)(f2 - 0.5f);
        n = n2;
        int n3 = n2;
        int n4 = (int)(f + 0.5f);
        int n5 = n4 - 1;
        int n6 = n4 - 1;
        this.interpX = true;
        int n7 = this.vertexCount;
        while (n7 > 0) {
            int n8;
            while (n5 <= n4 && n7 > 0) {
                --n7;
                n8 = n != 0 ? n - 1 : this.vertexCount - 1;
                this.incrementalizeY(this.vertices[n], this.vertices[n8], this.l, this.dl, n4);
                n5 = (int)(this.vertices[n8][19] + 0.5f);
                n = n8;
            }
            while (n6 <= n4 && n7 > 0) {
                --n7;
                n8 = n3 != this.vertexCount - 1 ? n3 + 1 : 0;
                this.incrementalizeY(this.vertices[n3], this.vertices[n8], this.r, this.dr, n4);
                n6 = (int)(this.vertices[n8][19] + 0.5f);
                n3 = n8;
            }
            while (n4 < n5 && n4 < n6) {
                if (n4 >= 0 && n4 < this.height) {
                    if (this.l[18] <= this.r[18]) {
                        this.scanline(n4, this.l, this.r);
                    } else {
                        this.scanline(n4, this.r, this.l);
                    }
                }
                ++n4;
                this.increment(this.l, this.dl);
                this.increment(this.r, this.dr);
            }
        }
    }

    private void scanline(int n, float[] fArray, float[] fArray2) {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.vertexCount; ++n4) {
            this.sp[n4] = 0.0f;
            this.sdp[n4] = 0.0f;
        }
        n4 = (int)(fArray[18] + 0.49999f);
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = (int)(fArray2[18] - 0.5f)) > this.width1) {
            n3 = this.width1;
        }
        if (n4 > n3) {
            return;
        }
        if (this.smooth) {
            n2 = this.MODYRES(n);
            this.aaleft[n2] = n4;
            this.aaright[n2] = n3;
            if (this.firstModY == -1) {
                this.firstModY = n2;
                this.aaleftmin = n4;
                this.aaleftmax = n4;
                this.aarightmin = n3;
                this.aarightmax = n3;
            } else {
                if (this.aaleftmin > this.aaleft[n2]) {
                    this.aaleftmin = this.aaleft[n2];
                }
                if (this.aaleftmax < this.aaleft[n2]) {
                    this.aaleftmax = this.aaleft[n2];
                }
                if (this.aarightmin > this.aaright[n2]) {
                    this.aarightmin = this.aaright[n2];
                }
                if (this.aarightmax < this.aaright[n2]) {
                    this.aarightmax = this.aaright[n2];
                }
            }
            this.lastModY = n2;
            if (n2 != 7 && n != this.lastY) {
                return;
            }
            this.aaleftfull = this.aaleftmax / 8 + 1;
            this.aarightfull = this.aarightmin / 8 - 1;
        }
        this.incrementalizeX(fArray, fArray2, this.sp, this.sdp, n4);
        n2 = this.smooth ? this.parent.width * (n / 8) : this.parent.width * n;
        int n5 = 0;
        int n6 = 0;
        if (this.smooth) {
            n5 = n4 / 8;
            n6 = (n3 + 7) / 8;
            n4 = this.aaleftmin / 8;
            n3 = (this.aarightmax + 7) / 8;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 > this.parent.width1) {
                n3 = this.parent.width1;
            }
        }
        this.interpX = false;
        for (int i = n4; i <= n3; ++i) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            if (this.interpUV) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                n11 = (int)(this.sp[7] * (float)this.twidth);
                n10 = (int)(this.sp[8] * (float)this.theight);
                if (n11 > this.twidth1) {
                    n11 = this.twidth1;
                }
                if (n10 > this.theight1) {
                    n10 = this.theight1;
                }
                if (n11 < 0) {
                    n11 = 0;
                }
                if (n10 < 0) {
                    n10 = 0;
                }
                n9 = n10 * this.twidth + n11;
                n8 = (int)(255.0f * (this.sp[7] * (float)this.twidth - (float)n11));
                n7 = (int)(255.0f * (this.sp[8] * (float)this.theight - (float)n10));
                int n24 = 255 - n8;
                int n25 = 255 - n7;
                int n26 = this.tpixels[n9];
                int n27 = n10 < this.theight1 ? this.tpixels[n9 + this.twidth] : this.tpixels[n9];
                int n28 = n11 < this.twidth1 ? this.tpixels[n9 + 1] : this.tpixels[n9];
                int n29 = n23 = n10 < this.theight1 && n11 < this.twidth1 ? this.tpixels[n9 + this.twidth + 1] : this.tpixels[n9];
                if (this.tformat == 4) {
                    n22 = n26 * n24 + n28 * n8 >> 8;
                    n21 = n27 * n24 + n23 * n8 >> 8;
                    n20 = (n22 * n25 + n21 * n7 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                } else if (this.tformat == 2) {
                    n19 = n26 >> 24 & 0xFF;
                    n18 = n27 >> 24 & 0xFF;
                    n17 = n28 >> 24 & 0xFF;
                    n16 = n23 >> 24 & 0xFF;
                    n22 = n19 * n24 + n17 * n8 >> 8;
                    n21 = n18 * n24 + n16 * n8 >> 8;
                    n20 = (n22 * n25 + n21 * n7 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                } else {
                    int n30 = n20 = this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig;
                }
                if (this.tformat == 1 || this.tformat == 2) {
                    n19 = n26 >> 16 & 0xFF;
                    n18 = n27 >> 16 & 0xFF;
                    n17 = n28 >> 16 & 0xFF;
                    n16 = n23 >> 16 & 0xFF;
                    n22 = n19 * n24 + n17 * n8 >> 8;
                    n21 = n18 * n24 + n16 * n8 >> 8;
                    n15 = (n22 * n25 + n21 * n7 >> 8) * (this.interpARGB ? (int)(this.sp[3] * 255.0f) : this.r2) >> 8;
                    n19 = n26 >> 8 & 0xFF;
                    n18 = n27 >> 8 & 0xFF;
                    n17 = n28 >> 8 & 0xFF;
                    n16 = n23 >> 8 & 0xFF;
                    n22 = n19 * n24 + n17 * n8 >> 8;
                    n21 = n18 * n24 + n16 * n8 >> 8;
                    n14 = (n22 * n25 + n21 * n7 >> 8) * (this.interpARGB ? (int)(this.sp[4] * 255.0f) : this.g2) >> 8;
                    n19 = n26 & 0xFF;
                    n18 = n27 & 0xFF;
                    n17 = n28 & 0xFF;
                    n16 = n23 & 0xFF;
                    n22 = n19 * n24 + n17 * n8 >> 8;
                    n21 = n18 * n24 + n16 * n8 >> 8;
                    n13 = (n22 * n25 + n21 * n7 >> 8) * (this.interpARGB ? (int)(this.sp[5] * 255.0f) : this.b2) >> 8;
                } else if (this.interpARGB) {
                    n15 = (int)(this.sp[3] * 255.0f);
                    n14 = (int)(this.sp[4] * 255.0f);
                    n13 = (int)(this.sp[5] * 255.0f);
                } else {
                    n15 = this.r2;
                    n14 = this.g2;
                    n13 = this.b2;
                }
                int n31 = n12 = this.smooth ? this.coverage(i) : 255;
                if (n12 != 255) {
                    n20 = n20 * n12 >> 8;
                }
                if (n20 == 254 || n20 == 255) {
                    this.pixels[n2 + i] = 0xFF000000 | n15 << 16 | n14 << 8 | n13;
                } else {
                    int n32 = 255 - n20;
                    int n33 = this.pixels[n2 + i] >> 16 & 0xFF;
                    int n34 = this.pixels[n2 + i] >> 8 & 0xFF;
                    int n35 = this.pixels[n2 + i] & 0xFF;
                    this.pixels[n2 + i] = 0xFF000000 | n15 * n20 + n33 * n32 >> 8 << 16 | n14 * n20 + n34 * n32 & 0xFF00 | n13 * n20 + n35 * n32 >> 8;
                }
            } else {
                int n36 = n11 = this.smooth ? this.coverage(i) : 255;
                if (this.interpARGB) {
                    this.r2 = (int)(this.sp[3] * 255.0f);
                    this.g2 = (int)(this.sp[4] * 255.0f);
                    this.b2 = (int)(this.sp[5] * 255.0f);
                    if (this.sp[6] != 1.0f) {
                        n11 = n11 * (int)(this.sp[6] * 255.0f) >> 8;
                    }
                    if (n11 == 255) {
                        this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
                    }
                } else if (this.a2orig != 255) {
                    n11 = n11 * this.a2orig >> 8;
                }
                if (n11 == 255) {
                    this.pixels[n2 + i] = this.rgba;
                } else {
                    n10 = this.pixels[n2 + i] >> 16 & 0xFF;
                    n9 = this.pixels[n2 + i] >> 8 & 0xFF;
                    n8 = this.pixels[n2 + i] & 0xFF;
                    this.a2 = n11;
                    n7 = 255 - this.a2;
                    this.pixels[n2 + i] = 0xFF000000 | n10 * n7 + this.r2 * this.a2 >> 8 << 16 | n9 * n7 + this.g2 * this.a2 >> 8 << 8 | n8 * n7 + this.b2 * this.a2 >> 8;
                }
            }
            if (this.smooth && (i < n5 || i > n6)) continue;
            this.increment(this.sp, this.sdp);
        }
        this.firstModY = -1;
        this.interpX = true;
    }

    private int coverage(int n) {
        if (n >= this.aaleftfull && n <= this.aarightfull && this.firstModY == 0 && this.lastModY == 7) {
            return 255;
        }
        int n2 = n * 8;
        int n3 = n2 + 8;
        int n4 = 0;
        for (int i = this.firstModY; i <= this.lastModY; ++i) {
            if (this.aaleft[i] > n3 || this.aaright[i] < n2) continue;
            n4 += (this.aaright[i] < n3 ? this.aaright[i] : n3) - (this.aaleft[i] > n2 ? this.aaleft[i] : n2);
        }
        return (n4 <<= 2) == 256 ? 255 : n4;
    }

    private void incrementalizeY(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[19] - fArray[19];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[19];
        if (this.interpX) {
            fArray4[18] = (fArray2[18] - fArray[18]) / f;
            fArray3[18] = fArray[18] + fArray4[18] * f2;
        }
        if (this.interpARGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray4[6] = (fArray2[6] - fArray[6]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
            fArray3[6] = fArray[6] + fArray4[6] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private void incrementalizeX(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[18] - fArray[18];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[18];
        if (this.smooth) {
            f /= 8.0f;
            f2 /= 8.0f;
        }
        if (this.interpX) {
            fArray4[18] = (fArray2[18] - fArray[18]) / f;
            fArray3[18] = fArray[18] + fArray4[18] * f2;
        }
        if (this.interpARGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray4[6] = (fArray2[6] - fArray[6]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
            fArray3[6] = fArray[6] + fArray4[6] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private void increment(float[] fArray, float[] fArray2) {
        if (this.interpX) {
            fArray[18] = fArray[18] + fArray2[18];
        }
        if (this.interpARGB) {
            fArray[3] = fArray[3] + fArray2[3];
            fArray[4] = fArray[4] + fArray2[4];
            fArray[5] = fArray[5] + fArray2[5];
            fArray[6] = fArray[6] + fArray2[6];
        }
        if (this.interpUV) {
            fArray[7] = fArray[7] + fArray2[7];
            fArray[8] = fArray[8] + fArray2[8];
        }
    }
}

