/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.configuration;

import com.projectlibre1.configuration.ProvidesDigesterEvents;
import com.projectlibre1.contrib.util.Log;
import com.projectlibre1.contrib.util.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.digester.Digester;

public class ConfigurationReader {
    static Log log = LogFactory.getLog(ConfigurationReader.class);

    public static ProvidesDigesterEvents read(String string, ProvidesDigesterEvents providesDigesterEvents) {
        URL uRL = ConfigurationReader.class.getClassLoader().getResource(string);
        if (uRL == null) {
            log.fatal("could not find xml configuration file: " + string);
            return null;
        }
        ProvidesDigesterEvents providesDigesterEvents2 = null;
        try {
            providesDigesterEvents2 = ConfigurationReader.readStream(uRL.openStream(), providesDigesterEvents);
        }
        catch (IOException iOException) {
            log.error("Could not read field xml configuration file " + uRL);
            iOException.printStackTrace();
        }
        return providesDigesterEvents2;
    }

    public static ProvidesDigesterEvents readString(String string, ProvidesDigesterEvents providesDigesterEvents) {
        if (string == null) {
            return providesDigesterEvents;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return ConfigurationReader.readStream(byteArrayInputStream, providesDigesterEvents);
    }

    public static ProvidesDigesterEvents readStream(InputStream inputStream, ProvidesDigesterEvents providesDigesterEvents) {
        ProvidesDigesterEvents providesDigesterEvents2 = null;
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.push(providesDigesterEvents);
        providesDigesterEvents.addDigesterEvents(digester);
        try {
            providesDigesterEvents2 = (ProvidesDigesterEvents)digester.parse(inputStream);
        }
        catch (Exception exception) {
            log.error("Error parsing reading/parsing field xml configuration file.");
            exception.printStackTrace();
        }
        return providesDigesterEvents2;
    }
}

