# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("mprapi.dll")
prototypes = \
    {
        #
        'MprAdminConnectionEnumEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwConnectDuration": SimTypeInt(signed=False, label="UInt32"), "dwInterfaceType": SimTypeInt(signed=False, label="ROUTER_INTERFACE_TYPE"), "dwConnectionFlags": SimTypeInt(signed=False, label="RAS_FLAGS"), "wszInterfaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "wszUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "wszLogonDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "wszRemoteComputer": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "guid": SimTypeBottom(label="Guid"), "rasQuarState": SimTypeInt(signed=False, label="RAS_QUARANTINE_STATE"), "probationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "dwBytesXmited": SimTypeInt(signed=False, label="UInt32"), "dwBytesRcved": SimTypeInt(signed=False, label="UInt32"), "dwFramesXmited": SimTypeInt(signed=False, label="UInt32"), "dwFramesRcved": SimTypeInt(signed=False, label="UInt32"), "dwCrcErr": SimTypeInt(signed=False, label="UInt32"), "dwTimeoutErr": SimTypeInt(signed=False, label="UInt32"), "dwAlignmentErr": SimTypeInt(signed=False, label="UInt32"), "dwHardwareOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwFramingErr": SimTypeInt(signed=False, label="UInt32"), "dwBufferOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioIn": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioOut": SimTypeInt(signed=False, label="UInt32"), "dwNumSwitchOvers": SimTypeInt(signed=False, label="UInt32"), "wszRemoteEndpointAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "wszLocalEndpointAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "ProjectionInfo": SimStruct({"projectionInfoType": SimTypeChar(label="Byte"), "Anonymous": SimUnion({"PppProjectionInfo": SimStruct({"dwIPv4NegotiationError": SimTypeInt(signed=False, label="UInt32"), "wszAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "wszRemoteAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "dwIPv4Options": SimTypeInt(signed=False, label="UInt32"), "dwIPv4RemoteOptions": SimTypeInt(signed=False, label="UInt32"), "IPv4SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwIPv6NegotiationError": SimTypeInt(signed=False, label="UInt32"), "bInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bRemoteInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bPrefix": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwPrefixLength": SimTypeInt(signed=False, label="UInt32"), "IPv6SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwLcpError": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationProtocol": SimTypeInt(signed=False, label="PPP_LCP"), "dwAuthenticationData": SimTypeInt(signed=False, label="PPP_LCP_INFO_AUTH_DATA"), "dwRemoteAuthenticationProtocol": SimTypeInt(signed=False, label="PPP_LCP"), "dwRemoteAuthenticationData": SimTypeInt(signed=False, label="PPP_LCP_INFO_AUTH_DATA"), "dwLcpTerminateReason": SimTypeInt(signed=False, label="UInt32"), "dwLcpRemoteTerminateReason": SimTypeInt(signed=False, label="UInt32"), "dwLcpOptions": SimTypeInt(signed=False, label="UInt32"), "dwLcpRemoteOptions": SimTypeInt(signed=False, label="UInt32"), "dwEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwRemoteEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwCcpError": SimTypeInt(signed=False, label="UInt32"), "dwCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwCcpOptions": SimTypeInt(signed=False, label="UInt32"), "dwRemoteCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwCcpRemoteOptions": SimTypeInt(signed=False, label="UInt32")}, name="PPP_PROJECTION_INFO", pack=False, align=None), "Ikev2ProjectionInfo": SimStruct({"dwIPv4NegotiationError": SimTypeInt(signed=False, label="UInt32"), "wszAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "wszRemoteAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "IPv4SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwIPv6NegotiationError": SimTypeInt(signed=False, label="UInt32"), "bInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bRemoteInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bPrefix": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwPrefixLength": SimTypeInt(signed=False, label="UInt32"), "IPv6SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationProtocol": SimTypeInt(signed=False, label="UInt32"), "dwEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32")}, name="IKEV2_PROJECTION_INFO", pack=False, align=None)}, name="<anon>", label="None")}, name="PROJECTION_INFO", pack=False, align=None), "hConnection": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInterface": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RAS_CONNECTION_EX", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "pObjectHeader", "dwPreferedMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "ppRasConn", "lpdwResumeHandle"]),
        #
        'MprAdminConnectionGetInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwConnectDuration": SimTypeInt(signed=False, label="UInt32"), "dwInterfaceType": SimTypeInt(signed=False, label="ROUTER_INTERFACE_TYPE"), "dwConnectionFlags": SimTypeInt(signed=False, label="RAS_FLAGS"), "wszInterfaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "wszUserName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 257), "wszLogonDomain": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "wszRemoteComputer": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 17), "guid": SimTypeBottom(label="Guid"), "rasQuarState": SimTypeInt(signed=False, label="RAS_QUARANTINE_STATE"), "probationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "dwBytesXmited": SimTypeInt(signed=False, label="UInt32"), "dwBytesRcved": SimTypeInt(signed=False, label="UInt32"), "dwFramesXmited": SimTypeInt(signed=False, label="UInt32"), "dwFramesRcved": SimTypeInt(signed=False, label="UInt32"), "dwCrcErr": SimTypeInt(signed=False, label="UInt32"), "dwTimeoutErr": SimTypeInt(signed=False, label="UInt32"), "dwAlignmentErr": SimTypeInt(signed=False, label="UInt32"), "dwHardwareOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwFramingErr": SimTypeInt(signed=False, label="UInt32"), "dwBufferOverrunErr": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioIn": SimTypeInt(signed=False, label="UInt32"), "dwCompressionRatioOut": SimTypeInt(signed=False, label="UInt32"), "dwNumSwitchOvers": SimTypeInt(signed=False, label="UInt32"), "wszRemoteEndpointAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "wszLocalEndpointAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "ProjectionInfo": SimStruct({"projectionInfoType": SimTypeChar(label="Byte"), "Anonymous": SimUnion({"PppProjectionInfo": SimStruct({"dwIPv4NegotiationError": SimTypeInt(signed=False, label="UInt32"), "wszAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "wszRemoteAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "dwIPv4Options": SimTypeInt(signed=False, label="UInt32"), "dwIPv4RemoteOptions": SimTypeInt(signed=False, label="UInt32"), "IPv4SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwIPv6NegotiationError": SimTypeInt(signed=False, label="UInt32"), "bInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bRemoteInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bPrefix": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwPrefixLength": SimTypeInt(signed=False, label="UInt32"), "IPv6SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwLcpError": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationProtocol": SimTypeInt(signed=False, label="PPP_LCP"), "dwAuthenticationData": SimTypeInt(signed=False, label="PPP_LCP_INFO_AUTH_DATA"), "dwRemoteAuthenticationProtocol": SimTypeInt(signed=False, label="PPP_LCP"), "dwRemoteAuthenticationData": SimTypeInt(signed=False, label="PPP_LCP_INFO_AUTH_DATA"), "dwLcpTerminateReason": SimTypeInt(signed=False, label="UInt32"), "dwLcpRemoteTerminateReason": SimTypeInt(signed=False, label="UInt32"), "dwLcpOptions": SimTypeInt(signed=False, label="UInt32"), "dwLcpRemoteOptions": SimTypeInt(signed=False, label="UInt32"), "dwEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwRemoteEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwCcpError": SimTypeInt(signed=False, label="UInt32"), "dwCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwCcpOptions": SimTypeInt(signed=False, label="UInt32"), "dwRemoteCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwCcpRemoteOptions": SimTypeInt(signed=False, label="UInt32")}, name="PPP_PROJECTION_INFO", pack=False, align=None), "Ikev2ProjectionInfo": SimStruct({"dwIPv4NegotiationError": SimTypeInt(signed=False, label="UInt32"), "wszAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "wszRemoteAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "IPv4SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwIPv6NegotiationError": SimTypeInt(signed=False, label="UInt32"), "bInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bRemoteInterfaceIdentifier": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "bPrefix": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 8), "dwPrefixLength": SimTypeInt(signed=False, label="UInt32"), "IPv6SubInterfaceIndex": SimTypeLongLong(signed=False, label="UInt64"), "dwOptions": SimTypeInt(signed=False, label="UInt32"), "dwAuthenticationProtocol": SimTypeInt(signed=False, label="UInt32"), "dwEapTypeId": SimTypeInt(signed=False, label="UInt32"), "dwCompressionAlgorithm": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32")}, name="IKEV2_PROJECTION_INFO", pack=False, align=None)}, name="<anon>", label="None")}, name="PROJECTION_INFO", pack=False, align=None), "hConnection": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hInterface": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="RAS_CONNECTION_EX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hRasConnection", "pRasConnection"]),
        #
        'MprAdminServerGetInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "fLanOnlyMode": SimTypeInt(signed=False, label="UInt32"), "dwUpTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortsInUse": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "ConfigParams": SimStruct({"IkeConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwNetworkBlackoutTime": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "dwConfigOptions": SimTypeInt(signed=False, label="UInt32"), "dwTotalCertificates": SimTypeInt(signed=False, label="UInt32"), "certificateNames": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "machineCertificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwTotalEkus": SimTypeInt(signed=False, label="UInt32"), "certificateEKUs": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "IsEKUOID": SimTypeInt(signed=True, label="Int32"), "pwszEKU": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="MPR_CERT_EKU", pack=False, align=None), offset=0), "machineCertificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="IKEV2_TUNNEL_CONFIG_PARAMS4", pack=False, align=None)}, name="IKEV2_CONFIG_PARAMS", pack=False, align=None), "PptpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="PPTP_CONFIG_PARAMS", pack=False, align=None), "L2tpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="L2TP_TUNNEL_CONFIG_PARAMS2", pack=False, align=None)}, name="L2TP_CONFIG_PARAMS1", pack=False, align=None), "SstpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "isUseHttps": SimTypeInt(signed=True, label="Int32"), "certAlgorithm": SimTypeInt(signed=False, label="UInt32"), "sstpCertDetails": SimStruct({"isDefault": SimTypeInt(signed=True, label="Int32"), "certBlob": SimTypeBottom(label="CRYPTOAPI_BLOB")}, name="SSTP_CERT_INFO", pack=False, align=None)}, name="SSTP_CONFIG_PARAMS", pack=False, align=None), "GREConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="GRE_CONFIG_PARAMS0", pack=False, align=None)}, name="MPRAPI_TUNNEL_CONFIG_PARAMS1", pack=False, align=None)}, name="MPR_SERVER_EX1", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "pServerInfo"]),
        #
        'MprAdminServerSetInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "setConfigForProtocols": SimTypeInt(signed=False, label="UInt32"), "ConfigParams": SimStruct({"IkeConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwNetworkBlackoutTime": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "dwConfigOptions": SimTypeInt(signed=False, label="UInt32"), "dwTotalCertificates": SimTypeInt(signed=False, label="UInt32"), "certificateNames": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "machineCertificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwTotalEkus": SimTypeInt(signed=False, label="UInt32"), "certificateEKUs": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "IsEKUOID": SimTypeInt(signed=True, label="Int32"), "pwszEKU": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="MPR_CERT_EKU", pack=False, align=None), offset=0), "machineCertificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="IKEV2_TUNNEL_CONFIG_PARAMS4", pack=False, align=None)}, name="IKEV2_CONFIG_PARAMS", pack=False, align=None), "PptpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="PPTP_CONFIG_PARAMS", pack=False, align=None), "L2tpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="L2TP_TUNNEL_CONFIG_PARAMS2", pack=False, align=None)}, name="L2TP_CONFIG_PARAMS1", pack=False, align=None), "SstpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "isUseHttps": SimTypeInt(signed=True, label="Int32"), "certAlgorithm": SimTypeInt(signed=False, label="UInt32"), "sstpCertDetails": SimStruct({"isDefault": SimTypeInt(signed=True, label="Int32"), "certBlob": SimTypeBottom(label="CRYPTOAPI_BLOB")}, name="SSTP_CERT_INFO", pack=False, align=None)}, name="SSTP_CONFIG_PARAMS", pack=False, align=None), "GREConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="GRE_CONFIG_PARAMS0", pack=False, align=None)}, name="MPRAPI_TUNNEL_CONFIG_PARAMS1", pack=False, align=None)}, name="MPR_SERVER_SET_CONFIG_EX1", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "pServerInfo"]),
        #
        'MprConfigServerGetInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "fLanOnlyMode": SimTypeInt(signed=False, label="UInt32"), "dwUpTime": SimTypeInt(signed=False, label="UInt32"), "dwTotalPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortsInUse": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "ConfigParams": SimStruct({"IkeConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwNetworkBlackoutTime": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "dwConfigOptions": SimTypeInt(signed=False, label="UInt32"), "dwTotalCertificates": SimTypeInt(signed=False, label="UInt32"), "certificateNames": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "machineCertificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwTotalEkus": SimTypeInt(signed=False, label="UInt32"), "certificateEKUs": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "IsEKUOID": SimTypeInt(signed=True, label="Int32"), "pwszEKU": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="MPR_CERT_EKU", pack=False, align=None), offset=0), "machineCertificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="IKEV2_TUNNEL_CONFIG_PARAMS4", pack=False, align=None)}, name="IKEV2_CONFIG_PARAMS", pack=False, align=None), "PptpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="PPTP_CONFIG_PARAMS", pack=False, align=None), "L2tpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="L2TP_TUNNEL_CONFIG_PARAMS2", pack=False, align=None)}, name="L2TP_CONFIG_PARAMS1", pack=False, align=None), "SstpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "isUseHttps": SimTypeInt(signed=True, label="Int32"), "certAlgorithm": SimTypeInt(signed=False, label="UInt32"), "sstpCertDetails": SimStruct({"isDefault": SimTypeInt(signed=True, label="Int32"), "certBlob": SimTypeBottom(label="CRYPTOAPI_BLOB")}, name="SSTP_CERT_INFO", pack=False, align=None)}, name="SSTP_CONFIG_PARAMS", pack=False, align=None), "GREConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="GRE_CONFIG_PARAMS0", pack=False, align=None)}, name="MPRAPI_TUNNEL_CONFIG_PARAMS1", pack=False, align=None)}, name="MPR_SERVER_EX1", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "pServerInfo"]),
        #
        'MprConfigServerSetInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "setConfigForProtocols": SimTypeInt(signed=False, label="UInt32"), "ConfigParams": SimStruct({"IkeConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwNetworkBlackoutTime": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "dwConfigOptions": SimTypeInt(signed=False, label="UInt32"), "dwTotalCertificates": SimTypeInt(signed=False, label="UInt32"), "certificateNames": SimTypePointer(SimTypeBottom(label="CRYPTOAPI_BLOB"), offset=0), "machineCertificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwTotalEkus": SimTypeInt(signed=False, label="UInt32"), "certificateEKUs": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "IsEKUOID": SimTypeInt(signed=True, label="Int32"), "pwszEKU": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="MPR_CERT_EKU", pack=False, align=None), offset=0), "machineCertificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="IKEV2_TUNNEL_CONFIG_PARAMS4", pack=False, align=None)}, name="IKEV2_CONFIG_PARAMS", pack=False, align=None), "PptpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="PPTP_CONFIG_PARAMS", pack=False, align=None), "L2tpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "dwTunnelConfigParamFlags": SimTypeInt(signed=False, label="UInt32"), "TunnelConfigParams": SimStruct({"dwIdleTimeout": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionType": SimTypeInt(signed=False, label="UInt32"), "dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSizeForRenegotiation": SimTypeInt(signed=False, label="UInt32"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32")}, name="L2TP_TUNNEL_CONFIG_PARAMS2", pack=False, align=None)}, name="L2TP_CONFIG_PARAMS1", pack=False, align=None), "SstpConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32"), "isUseHttps": SimTypeInt(signed=True, label="Int32"), "certAlgorithm": SimTypeInt(signed=False, label="UInt32"), "sstpCertDetails": SimStruct({"isDefault": SimTypeInt(signed=True, label="Int32"), "certBlob": SimTypeBottom(label="CRYPTOAPI_BLOB")}, name="SSTP_CERT_INFO", pack=False, align=None)}, name="SSTP_CONFIG_PARAMS", pack=False, align=None), "GREConfigParams": SimStruct({"dwNumPorts": SimTypeInt(signed=False, label="UInt32"), "dwPortFlags": SimTypeInt(signed=False, label="UInt32")}, name="GRE_CONFIG_PARAMS0", pack=False, align=None)}, name="MPRAPI_TUNNEL_CONFIG_PARAMS1", pack=False, align=None)}, name="MPR_SERVER_SET_CONFIG_EX1", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "pSetServerConfig"]),
        #
        'MprAdminUpdateConnection': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwIfIndex": SimTypeInt(signed=False, label="UInt32"), "wszLocalEndpointAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "wszRemoteEndpointAddress": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65)}, name="RAS_UPDATE_CONNECTION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hRasConnection", "pRasUpdateConnection"]),
        #
        'MprAdminIsServiceInitialized': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpwsServerName", "fIsServiceInitialized"]),
        #
        'MprAdminInterfaceSetCustomInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "customIkev2Config": SimStruct({"dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSize": SimTypeInt(signed=False, label="UInt32"), "certificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "certificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "vpnTrafficSelectors": SimStruct({"numTsi": SimTypeInt(signed=False, label="UInt32"), "numTsr": SimTypeInt(signed=False, label="UInt32"), "tsI": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0), "tsR": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0)}, name="MPR_VPN_TRAFFIC_SELECTORS", pack=False, align=None)}, name="ROUTER_IKEv2_IF_CUSTOM_CONFIG2", pack=False, align=None)}, name="MPR_IF_CUSTOMINFOEX2", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "pCustomInfo"]),
        #
        'MprAdminInterfaceGetCustomInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "customIkev2Config": SimStruct({"dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSize": SimTypeInt(signed=False, label="UInt32"), "certificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "certificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "vpnTrafficSelectors": SimStruct({"numTsi": SimTypeInt(signed=False, label="UInt32"), "numTsr": SimTypeInt(signed=False, label="UInt32"), "tsI": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0), "tsR": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0)}, name="MPR_VPN_TRAFFIC_SELECTORS", pack=False, align=None)}, name="ROUTER_IKEv2_IF_CUSTOM_CONFIG2", pack=False, align=None)}, name="MPR_IF_CUSTOMINFOEX2", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "pCustomInfo"]),
        #
        'MprConfigInterfaceGetCustomInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "customIkev2Config": SimStruct({"dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSize": SimTypeInt(signed=False, label="UInt32"), "certificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "certificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "vpnTrafficSelectors": SimStruct({"numTsi": SimTypeInt(signed=False, label="UInt32"), "numTsr": SimTypeInt(signed=False, label="UInt32"), "tsI": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0), "tsR": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0)}, name="MPR_VPN_TRAFFIC_SELECTORS", pack=False, align=None)}, name="ROUTER_IKEv2_IF_CUSTOM_CONFIG2", pack=False, align=None)}, name="MPR_IF_CUSTOMINFOEX2", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "pCustomInfo"]),
        #
        'MprConfigInterfaceSetCustomInfoEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Header": SimStruct({"revision": SimTypeChar(label="Byte"), "type": SimTypeChar(label="Byte"), "size": SimTypeShort(signed=False, label="UInt16")}, name="MPRAPI_OBJECT_HEADER", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "customIkev2Config": SimStruct({"dwSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "dwSaDataSize": SimTypeInt(signed=False, label="UInt32"), "certificateName": SimTypeBottom(label="CRYPTOAPI_BLOB"), "customPolicy": SimTypePointer(SimStruct({"dwIntegrityMethod": SimTypeInt(signed=False, label="UInt32"), "dwEncryptionMethod": SimTypeInt(signed=False, label="UInt32"), "dwCipherTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwAuthTransformConstant": SimTypeInt(signed=False, label="UInt32"), "dwPfsGroup": SimTypeInt(signed=False, label="UInt32"), "dwDhGroup": SimTypeInt(signed=False, label="UInt32")}, name="ROUTER_CUSTOM_IKEv2_POLICY0", pack=False, align=None), offset=0), "certificateHash": SimTypeBottom(label="CRYPTOAPI_BLOB"), "dwMmSaLifeTime": SimTypeInt(signed=False, label="UInt32"), "vpnTrafficSelectors": SimStruct({"numTsi": SimTypeInt(signed=False, label="UInt32"), "numTsr": SimTypeInt(signed=False, label="UInt32"), "tsI": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0), "tsR": SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="MPR_VPN_TS_TYPE"), "protocolId": SimTypeChar(label="Byte"), "portStart": SimTypeShort(signed=False, label="UInt16"), "portEnd": SimTypeShort(signed=False, label="UInt16"), "tsPayloadId": SimTypeShort(signed=False, label="UInt16"), "addrStart": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None), "addrEnd": SimStruct({"Type": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"v4": SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), "v6": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None)}, name="<anon>", label="None")}, name="VPN_TS_IP_ADDRESS", pack=False, align=None)}, name="_MPR_VPN_SELECTOR", pack=False, align=None), offset=0)}, name="MPR_VPN_TRAFFIC_SELECTORS", pack=False, align=None)}, name="ROUTER_IKEv2_IF_CUSTOM_CONFIG2", pack=False, align=None)}, name="MPR_IF_CUSTOMINFOEX2", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "pCustomInfo"]),
        #
        'MprAdminConnectionEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "dwLevel", "lplpbBuffer", "dwPrefMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "lpdwResumeHandle"]),
        #
        'MprAdminPortEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "dwLevel", "hRasConnection", "lplpbBuffer", "dwPrefMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "lpdwResumeHandle"]),
        #
        'MprAdminConnectionGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "dwLevel", "hRasConnection", "lplpbBuffer"]),
        #
        'MprAdminPortGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "dwLevel", "hPort", "lplpbBuffer"]),
        #
        'MprAdminConnectionClearStats': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hRasConnection"]),
        #
        'MprAdminPortClearStats': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hPort"]),
        #
        'MprAdminPortReset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hPort"]),
        #
        'MprAdminPortDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hPort"]),
        #
        'MprAdminConnectionRemoveQuarantine': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRasServer", "hRasConnection", "fIsIpAddress"]),
        #
        'MprAdminUserGetInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszServer", "lpszUser", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminUserSetInfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszServer", "lpszUser", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminSendUserMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hConnection", "lpwszMessage"]),
        #
        'MprAdminGetPDCServer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszDomain", "lpszServer", "lpszPDCServer"]),
        #
        'MprAdminIsServiceRunning': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpwsServerName"]),
        #
        'MprAdminServerConnect': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpwsServerName", "phMprServer"]),
        #
        'MprAdminServerDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hMprServer"]),
        #
        'MprAdminServerGetCredentials': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lplpbBuffer"]),
        #
        'MprAdminServerSetCredentials': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminBufferFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pBuffer"]),
        #
        'MprAdminGetErrorString': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwError", "lplpwsErrorString"]),
        #
        'MprAdminServerGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lplpbBuffer"]),
        #
        'MprAdminServerSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminEstablishDomainRasServer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszDomain", "pszMachine", "bEnable"]),
        #
        'MprAdminIsDomainRasServer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszDomain", "pszMachine", "pbIsRasServer"]),
        #
        'MprAdminTransportCreate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwTransportId", "lpwsTransportName", "pGlobalInfo", "dwGlobalInfoSize", "pClientInterfaceInfo", "dwClientInterfaceInfoSize", "lpwsDLLPath"]),
        #
        'MprAdminTransportSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwTransportId", "pGlobalInfo", "dwGlobalInfoSize", "pClientInterfaceInfo", "dwClientInterfaceInfoSize"]),
        #
        'MprAdminTransportGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwTransportId", "ppGlobalInfo", "lpdwGlobalInfoSize", "ppClientInterfaceInfo", "lpdwClientInterfaceInfoSize"]),
        #
        'MprAdminDeviceEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lplpbBuffer", "lpdwTotalEntries"]),
        #
        'MprAdminInterfaceGetHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "lpwsInterfaceName", "phInterface", "fIncludeClientInterfaces"]),
        #
        'MprAdminInterfaceCreate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lpbBuffer", "phInterface"]),
        #
        'MprAdminInterfaceGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwLevel", "lplpbBuffer"]),
        #
        'MprAdminInterfaceSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminInterfaceDelete': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface"]),
        #
        'MprAdminInterfaceDeviceGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwIndex", "dwLevel", "lplpBuffer"]),
        #
        'MprAdminInterfaceDeviceSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwIndex", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminInterfaceTransportRemove': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwTransportId"]),
        #
        'MprAdminInterfaceTransportAdd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwTransportId", "pInterfaceInfo", "dwInterfaceInfoSize"]),
        #
        'MprAdminInterfaceTransportGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwTransportId", "ppInterfaceInfo", "lpdwInterfaceInfoSize"]),
        #
        'MprAdminInterfaceTransportSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwTransportId", "pInterfaceInfo", "dwInterfaceInfoSize"]),
        #
        'MprAdminInterfaceEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lplpbBuffer", "dwPrefMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "lpdwResumeHandle"]),
        #
        'MprAdminInterfaceSetCredentials': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpwsServer", "lpwsInterfaceName", "lpwsUserName", "lpwsDomainName", "lpwsPassword"]),
        #
        'MprAdminInterfaceGetCredentials': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpwsServer", "lpwsInterfaceName", "lpwsUserName", "lpwsPassword", "lpwsDomainName"]),
        #
        'MprAdminInterfaceSetCredentialsEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwLevel", "lpbBuffer"]),
        #
        'MprAdminInterfaceGetCredentialsEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwLevel", "lplpbBuffer"]),
        #
        'MprAdminInterfaceConnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "hEvent", "fSynchronous"]),
        #
        'MprAdminInterfaceDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface"]),
        #
        'MprAdminInterfaceUpdateRoutes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwProtocolId", "hEvent"]),
        #
        'MprAdminInterfaceQueryUpdateResult': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface", "dwProtocolId", "lpdwUpdateResult"]),
        #
        'MprAdminInterfaceUpdatePhonebookInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hInterface"]),
        #
        'MprAdminRegisterConnectionNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hEventNotification"]),
        #
        'MprAdminDeregisterConnectionNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "hEventNotification"]),
        #
        'MprAdminMIBServerConnect': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpwsServerName", "phMibServer"]),
        #
        'MprAdminMIBServerDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hMibServer"]),
        #
        'MprAdminMIBEntryCreate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMibServer", "dwPid", "dwRoutingPid", "lpEntry", "dwEntrySize"]),
        #
        'MprAdminMIBEntryDelete': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMibServer", "dwProtocolId", "dwRoutingPid", "lpEntry", "dwEntrySize"]),
        #
        'MprAdminMIBEntrySet': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMibServer", "dwProtocolId", "dwRoutingPid", "lpEntry", "dwEntrySize"]),
        #
        'MprAdminMIBEntryGet': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMibServer", "dwProtocolId", "dwRoutingPid", "lpInEntry", "dwInEntrySize", "lplpOutEntry", "lpOutEntrySize"]),
        #
        'MprAdminMIBEntryGetFirst': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMibServer", "dwProtocolId", "dwRoutingPid", "lpInEntry", "dwInEntrySize", "lplpOutEntry", "lpOutEntrySize"]),
        #
        'MprAdminMIBEntryGetNext': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMibServer", "dwProtocolId", "dwRoutingPid", "lpInEntry", "dwInEntrySize", "lplpOutEntry", "lpOutEntrySize"]),
        #
        'MprAdminMIBBufferFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pBuffer"]),
        #
        'MprConfigServerInstall': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwLevel", "pBuffer"]),
        #
        'MprConfigServerConnect': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpwsServerName", "phMprConfig"]),
        #
        'MprConfigServerDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hMprConfig"]),
        #
        'MprConfigServerRefresh': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig"]),
        #
        'MprConfigBufferFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pBuffer"]),
        #
        'MprConfigServerGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwLevel", "lplpbBuffer"]),
        #
        'MprConfigServerSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprServer", "dwLevel", "lpbBuffer"]),
        #
        'MprConfigServerBackup': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "lpwsPath"]),
        #
        'MprConfigServerRestore': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "lpwsPath"]),
        #
        'MprConfigTransportCreate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwTransportId", "lpwsTransportName", "pGlobalInfo", "dwGlobalInfoSize", "pClientInterfaceInfo", "dwClientInterfaceInfoSize", "lpwsDLLPath", "phRouterTransport"]),
        #
        'MprConfigTransportDelete': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterTransport"]),
        #
        'MprConfigTransportGetHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwTransportId", "phRouterTransport"]),
        #
        'MprConfigTransportSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterTransport", "pGlobalInfo", "dwGlobalInfoSize", "pClientInterfaceInfo", "dwClientInterfaceInfoSize", "lpwsDLLPath"]),
        #
        'MprConfigTransportGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterTransport", "ppGlobalInfo", "lpdwGlobalInfoSize", "ppClientInterfaceInfo", "lpdwClientInterfaceInfoSize", "lplpwsDLLPath"]),
        #
        'MprConfigTransportEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwLevel", "lplpBuffer", "dwPrefMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "lpdwResumeHandle"]),
        #
        'MprConfigInterfaceCreate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwLevel", "lpbBuffer", "phRouterInterface"]),
        #
        'MprConfigInterfaceDelete': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface"]),
        #
        'MprConfigInterfaceGetHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "lpwsInterfaceName", "phRouterInterface"]),
        #
        'MprConfigInterfaceGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "dwLevel", "lplpBuffer", "lpdwBufferSize"]),
        #
        'MprConfigInterfaceSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "dwLevel", "lpbBuffer"]),
        #
        'MprConfigInterfaceEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwLevel", "lplpBuffer", "dwPrefMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "lpdwResumeHandle"]),
        #
        'MprConfigInterfaceTransportAdd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "dwTransportId", "lpwsTransportName", "pInterfaceInfo", "dwInterfaceInfoSize", "phRouterIfTransport"]),
        #
        'MprConfigInterfaceTransportRemove': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "hRouterIfTransport"]),
        #
        'MprConfigInterfaceTransportGetHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "dwTransportId", "phRouterIfTransport"]),
        #
        'MprConfigInterfaceTransportGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "hRouterIfTransport", "ppInterfaceInfo", "lpdwInterfaceInfoSize"]),
        #
        'MprConfigInterfaceTransportSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "hRouterIfTransport", "pInterfaceInfo", "dwInterfaceInfoSize"]),
        #
        'MprConfigInterfaceTransportEnum': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "hRouterInterface", "dwLevel", "lplpBuffer", "dwPrefMaxLen", "lpdwEntriesRead", "lpdwTotalEntries", "lpdwResumeHandle"]),
        #
        'MprConfigGetFriendlyName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "pszGuidName", "pszBuffer", "dwBufferSize"]),
        #
        'MprConfigGetGuidName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "pszFriendlyName", "pszBuffer", "dwBufferSize"]),
        #
        'MprConfigFilterGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwLevel", "dwTransportId", "lpBuffer"]),
        #
        'MprConfigFilterSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hMprConfig", "dwLevel", "dwTransportId", "lpBuffer"]),
        #
        'MprInfoCreate': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwVersion", "lplpNewHeader"]),
        #
        'MprInfoDelete': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader"]),
        #
        'MprInfoRemoveAll': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader", "lplpNewHeader"]),
        #
        'MprInfoDuplicate': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader", "lplpNewHeader"]),
        #
        'MprInfoBlockAdd': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader", "dwInfoType", "dwItemSize", "dwItemCount", "lpItemData", "lplpNewHeader"]),
        #
        'MprInfoBlockRemove': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader", "dwInfoType", "lplpNewHeader"]),
        #
        'MprInfoBlockSet': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader", "dwInfoType", "dwItemSize", "dwItemCount", "lpItemData", "lplpNewHeader"]),
        #
        'MprInfoBlockFind': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader", "dwInfoType", "lpdwItemSize", "lpdwItemCount", "lplpItemData"]),
        #
        'MprInfoBlockQuerySize': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpHeader"]),
    }

lib.set_prototypes(prototypes)
