/* riemann/message.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/proto/riemann.pb-c.h>
#include <riemann/event.h>
#include <riemann/query.h>

typedef Msg riemann_message_t;

#ifdef __cplusplus
extern "C" {
#endif

riemann_message_t *riemann_message_new (void);
riemann_message_t *riemann_message_create_with_events (riemann_event_t *event, ...);
riemann_message_t *riemann_message_create_with_events_va (riemann_event_t *event, va_list aq);
riemann_message_t *riemann_message_create_with_events_n (size_t n, riemann_event_t **events);
riemann_message_t *riemann_message_create_with_query (riemann_query_t *query);
riemann_message_t *riemann_message_clone (const riemann_message_t *message);
void riemann_message_free (riemann_message_t *message);

int riemann_message_set_events (riemann_message_t *message, ...);
int riemann_message_set_events_va (riemann_message_t *message, va_list aq);
int riemann_message_set_events_n (riemann_message_t *message,
                                  size_t n_events,
                                  riemann_event_t **events);

int riemann_message_append_events (riemann_message_t *message, ...);
int riemann_message_append_events_va (riemann_message_t *message, va_list aq);
int riemann_message_append_events_n (riemann_message_t *message,
                                     size_t n_events,
                                     riemann_event_t **events);

int riemann_message_set_query (riemann_message_t *message,
                               riemann_query_t *query);

uint8_t *riemann_message_to_buffer (riemann_message_t *message, size_t *len);
riemann_message_t *riemann_message_from_buffer (uint8_t *buffer, size_t len);
size_t riemann_message_get_packed_size (riemann_message_t *message);

#ifdef __cplusplus
}
#endif
