/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.util.response;

import de.rub.nds.tlsattacker.attacks.util.response.EqualityError;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseFingerprint;
import de.rub.nds.tlsattacker.core.record.Record;
import java.util.Arrays;

public class FingerPrintChecker {
    public static EqualityError checkEquality(ResponseFingerprint fingerprint1, ResponseFingerprint fingerprint2) {
        int i;
        if (fingerprint1.getMessageList().size() == fingerprint2.getMessageList().size()) {
            for (i = 0; i < fingerprint1.getMessageList().size(); ++i) {
                if (fingerprint1.getMessageList().get(i).toCompactString().equals(fingerprint2.getMessageList().get(i).toCompactString())) continue;
                if (fingerprint1.getMessageList().get(i).getClass().equals(fingerprint2.getMessageList().get(i).getClass())) {
                    return EqualityError.MESSAGE_CONTENT;
                }
                return EqualityError.MESSAGE_CLASS;
            }
        } else {
            return EqualityError.MESSAGE_COUNT;
        }
        if (fingerprint1.getRecordList() != null && fingerprint2.getRecordList() != null) {
            if (fingerprint1.getRecordList().size() == fingerprint2.getRecordList().size()) {
                for (i = 0; i < fingerprint1.getRecordList().size(); ++i) {
                    if (!fingerprint1.getRecordList().get(i).getClass().equals(fingerprint2.getRecordList().get(i).getClass())) {
                        return EqualityError.RECORD_CLASS;
                    }
                    if (((byte[])fingerprint1.getRecordList().get(i).getCompleteRecordBytes().getValue()).length != ((byte[])fingerprint2.getRecordList().get(i).getCompleteRecordBytes().getValue()).length) {
                        return EqualityError.RECORD_CONTENT;
                    }
                    if (fingerprint1.getRecordList().get(i) instanceof Record && fingerprint2.getRecordList().get(i) instanceof Record) {
                        Record thisRecord = (Record)fingerprint1.getRecordList().get(i);
                        Record otherRecord = (Record)fingerprint2.getRecordList().get(i);
                        if (thisRecord.getContentMessageType().getValue() != otherRecord.getContentMessageType().getValue()) {
                            return EqualityError.RECORD_CONTENT_TYPE;
                        }
                        if (Arrays.equals((byte[])thisRecord.getProtocolVersion().getValue(), (byte[])otherRecord.getProtocolVersion().getValue())) continue;
                        return EqualityError.RECORD_VERSION;
                    }
                    if (!Arrays.equals((byte[])fingerprint1.getRecordList().get(i).getCompleteRecordBytes().getValue(), (byte[])fingerprint2.getRecordList().get(i).getCompleteRecordBytes().getValue())) continue;
                    return EqualityError.RECORD_CONTENT;
                }
            } else {
                return EqualityError.RECORD_COUNT;
            }
        }
        if (fingerprint1.getSocketState() == fingerprint2.getSocketState()) {
            return EqualityError.NONE;
        }
        return EqualityError.SOCKET_STATE;
    }

    private FingerPrintChecker() {
    }
}

