"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const tz = __importStar(require("../converters/toZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const legrand_1 = require("../lib/legrand");
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const e = exposes.presets;
const ea = exposes.access;
exports.definitions = [
    {
        zigbeeModel: [" Light switch with neutral\u0000\u0000\u0000\u0000\u0000"],
        model: "K4003C/L4003C/N4003C/NT4003C",
        vendor: "BTicino",
        description: "Light switch with neutral",
        ota: true,
        fromZigbee: [fz.identify, fz.on_off, fz.K4003C_binary_input, legrand_1.fzLegrand.cluster_fc01],
        toZigbee: [tz.on_off, legrand_1.tzLegrand.led_mode, legrand_1.tzLegrand.identify],
        exposes: [e.switch(), e.action(["identify", "on", "off"]), legrand_1.eLegrand.identify(), legrand_1.eLegrand.ledInDark(), legrand_1.eLegrand.ledIfOn()],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genIdentify", "genOnOff", "genBinaryInput"]);
        },
    },
    {
        zigbeeModel: [" Dimmer switch with neutral\u0000\u0000\u0000\u0000"],
        model: "4411C/L4411C/N4411C/NT4411C",
        vendor: "BTicino",
        description: "Dimmer switch with neutral",
        ota: true,
        fromZigbee: [fz.identify, fz.lighting_ballast_configuration, legrand_1.fzLegrand.cluster_fc01],
        toZigbee: [legrand_1.tzLegrand.led_mode, tz.legrand_device_mode, legrand_1.tzLegrand.identify, tz.ballast_config],
        exposes: [
            e.numeric("ballast_minimum_level", ea.ALL).withValueMin(1).withValueMax(254).withDescription("Specifies the minimum brightness value"),
            e.numeric("ballast_maximum_level", ea.ALL).withValueMin(1).withValueMax(254).withDescription("Specifies the maximum brightness value"),
            e.binary("device_mode", ea.ALL, "dimmer_on", "dimmer_off").withDescription("Allow the device to change brightness"),
            legrand_1.eLegrand.identify(),
            legrand_1.eLegrand.ledInDark(),
            legrand_1.eLegrand.ledIfOn(),
        ],
        extend: [m.light({ configureReporting: true })],
    },
    {
        zigbeeModel: ["Bticino Din power consumption module "],
        model: "F20T60A",
        description: "DIN power consumption module (same as Legrand 412015)",
        vendor: "BTicino",
        extend: [m.onOff(), m.electricityMeter({ cluster: "electrical" })],
        fromZigbee: [fz.identify, legrand_1.fzLegrand.cluster_fc01, fz.ignore_basic_report, fz.ignore_genOta],
        toZigbee: [tz.legrand_device_mode, legrand_1.tzLegrand.identify],
        exposes: [
            e
                .enum("device_mode", ea.ALL, ["switch", "auto"])
                .withDescription("switch: allow on/off, auto will use wired action via C1/C2 on contactor for example with HC/HP"),
        ],
    },
    {
        zigbeeModel: ["Power socket Bticino Serie LL "],
        model: "L4531C",
        vendor: "BTicino",
        description: "Power socket with power consumption monitoring",
        fromZigbee: [fz.identify, fz.on_off, fz.electrical_measurement, legrand_1.fzLegrand.cluster_fc01],
        toZigbee: [tz.on_off, legrand_1.tzLegrand.led_mode, legrand_1.tzLegrand.identify],
        exposes: [e.switch(), e.action(["identify"]), e.power(), e.voltage(), e.current()],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genIdentify", "genOnOff", "haElectricalMeasurement"]);
            await reporting.onOff(endpoint);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.activePower(endpoint);
        },
    },
];
//# sourceMappingURL=bticino.js.map