/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.xp;

import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DefaultListCellRenderer
extends javax.swing.DefaultListCellRenderer {
    private JList list;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.list = list;
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            if (this.isFocusPermanentlyLost()) {
                Color focusLostSelectionColor = UIManager.getColor("Label.background");
                this.setBackground(focusLostSelectionColor);
                this.setForeground(list.getForeground());
            } else {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }

    private boolean isFocusPermanentlyLost() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = kfm.getPermanentFocusOwner();
        if (component == null) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(this.getList());
        Window activeWindow = kfm.getActiveWindow();
        if (activeWindow == null) {
            return true;
        }
        return !component.equals(this.getList()) || !activeWindow.equals(window);
    }

    private JList getList() {
        return this.list;
    }
}

