/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.MarkedObject;
import com.lowagie.text.MarkedSection;
import com.lowagie.text.Paragraph;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.factories.ElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class Section
extends ArrayList
implements TextElementArray {
    private static final long serialVersionUID = 3324172577544748043L;
    protected Paragraph title;
    protected String bookmarkTitle;
    protected int numberDepth;
    protected float indentationLeft;
    protected float indentationRight;
    protected float indentation;
    protected boolean bookmarkOpen = true;
    protected boolean triggerNewPage = false;
    protected int subsections = 0;
    protected ArrayList numbers = null;

    protected Section() {
        this.title = new Paragraph();
        this.numberDepth = 1;
    }

    protected Section(Paragraph paragraph, int n) {
        this.numberDepth = n;
        this.title = paragraph;
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                elementListener.add(element);
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 13;
    }

    public boolean isChapter() {
        return this.type() == 16;
    }

    public boolean isSection() {
        return this.type() == 13;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void add(int n, Object object) {
        try {
            Element element = (Element)object;
            if (element.type() != 12 && element.type() != 14 && element.type() != 10 && element.type() != 11 && element.type() != 17 && element.type() != 29 && element.type() != 22 && element.type() != 23 && element.type() != 35 && element.type() != 32 && element.type() != 33 && element.type() != 34) {
                throw new ClassCastException("You can add a " + element.getClass().getName() + " to a Section.");
            }
            super.add(n, element);
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean add(Object object) {
        try {
            Element element = (Element)object;
            if (element.type() == 12 || element.type() == 14 || element.type() == 10 || element.type() == 11 || element.type() == 17 || element.type() == 29 || element.type() == 22 || element.type() == 35 || element.type() == 23 || element.type() == 32 || element.type() == 33 || element.type() == 34) {
                return super.add(object);
            }
            if (element.type() == 13) {
                Section section = (Section)object;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(section);
            }
            if (object instanceof MarkedSection && ((MarkedObject)object).element.type() == 13) {
                MarkedSection markedSection = (MarkedSection)object;
                Section section = (Section)markedSection.element;
                section.setNumbers(++this.subsections, this.numbers);
                return super.add(markedSection);
            }
            if (element instanceof MarkedObject) {
                return super.add(object);
            }
            throw new ClassCastException("You can add a " + element.getClass().getName() + " to a Section.");
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Insertion of illegal Element: " + classCastException.getMessage());
        }
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return true;
    }

    public Section addSection(float f, Paragraph paragraph, int n) {
        Section section = new Section(paragraph, n);
        section.setIndentation(f);
        this.add(section);
        return section;
    }

    public Section addSection(float f, Paragraph paragraph) {
        return this.addSection(f, paragraph, this.numberDepth + 1);
    }

    public Section addSection(Paragraph paragraph, int n) {
        return this.addSection(0.0f, paragraph, n);
    }

    public MarkedSection addMarkedSection() {
        MarkedSection markedSection = new MarkedSection(new Section(null, this.numberDepth + 1));
        this.add(markedSection);
        return markedSection;
    }

    public Section addSection(Paragraph paragraph) {
        return this.addSection(0.0f, paragraph, this.numberDepth + 1);
    }

    public Section addSection(float f, String string, int n) {
        return this.addSection(f, new Paragraph(string), n);
    }

    public Section addSection(String string, int n) {
        return this.addSection(new Paragraph(string), n);
    }

    public Section addSection(float f, String string) {
        return this.addSection(f, new Paragraph(string));
    }

    public Section addSection(String string) {
        return this.addSection(new Paragraph(string));
    }

    public void setTitle(Paragraph paragraph) {
        this.title = paragraph;
    }

    public Paragraph getTitle() {
        if (this.title == null) {
            return null;
        }
        int n = Math.min(this.numbers.size(), this.numberDepth);
        if (n < 1) {
            return this.title;
        }
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < n; ++i) {
            stringBuffer.insert(0, ".");
            stringBuffer.insert(0, (Integer)this.numbers.get(i));
        }
        Paragraph paragraph = new Paragraph(this.title);
        paragraph.add(0, new Chunk(stringBuffer.toString(), this.title.getFont()));
        return paragraph;
    }

    public void setNumberDepth(int n) {
        this.numberDepth = n;
    }

    public int getNumberDepth() {
        return this.numberDepth;
    }

    public void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    public void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public float getIndentationRight() {
        return this.indentationRight;
    }

    public void setIndentation(float f) {
        this.indentation = f;
    }

    public float getIndentation() {
        return this.indentation;
    }

    public void setBookmarkOpen(boolean bl) {
        this.bookmarkOpen = bl;
    }

    public boolean isBookmarkOpen() {
        return this.bookmarkOpen;
    }

    public void setTriggerNewPage(boolean bl) {
        this.triggerNewPage = bl;
    }

    public boolean isTriggerNewPage() {
        return this.triggerNewPage;
    }

    public void setBookmarkTitle(String string) {
        this.bookmarkTitle = string;
    }

    public Paragraph getBookmarkTitle() {
        if (this.bookmarkTitle == null) {
            return this.getTitle();
        }
        return new Paragraph(this.bookmarkTitle);
    }

    public void setChapterNumber(int n) {
        this.numbers.set(this.numbers.size() - 1, new Integer(n));
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Section)) continue;
            ((Section)e).setChapterNumber(n);
        }
    }

    public int getDepth() {
        return this.numbers.size();
    }

    private void setNumbers(int n, ArrayList arrayList) {
        this.numbers = new ArrayList();
        this.numbers.add(new Integer(n));
        this.numbers.addAll(arrayList);
    }

    public Paragraph title() {
        return this.getTitle();
    }

    public int numberDepth() {
        return this.getNumberDepth();
    }

    public float indentationLeft() {
        return this.getIndentationLeft();
    }

    public float indentationRight() {
        return this.getIndentationRight();
    }

    public float indentation() {
        return this.getIndentation();
    }

    public int depth() {
        return this.getDepth();
    }

    public Section addSection(Properties properties) {
        return ElementFactory.getSection(this, properties);
    }
}

